package mahonia

// Taken from /src/pkg/html/entity.go in the Go source code.

// Copyright 2010 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

//package html

// entityList is a list of HTML entity names and their values. The semicolon matters:
// http://www.whatwg.org/specs/web-apps/current-work/multipage/named-character-references.html
// lists both "amp" and "amp;" as two separate entries.
//
// Most entities translate to a single rune (r1); a few translate to two (r1 and r2).
//
// Note that the HTML5 list is larger than the HTML4 list at
// http://www.w3.org/TR/html4/sgml/entities.html
var entityList = []struct {
	name   string
	r1, r2 rune
}{
	{"AElig", '\U000000C6', 0},
	{"AElig;", '\U000000C6', 0},
	{"AMP", '\U00000026', 0},
	{"AMP;", '\U00000026', 0},
	{"Aacute", '\U000000C1', 0},
	{"Aacute;", '\U000000C1', 0},
	{"Abreve;", '\U00000102', 0},
	{"Acirc", '\U000000C2', 0},
	{"Acirc;", '\U000000C2', 0},
	{"Acy;", '\U00000410', 0},
	{"Afr;", '\U0001D504', 0},
	{"Agrave", '\U000000C0', 0},
	{"Agrave;", '\U000000C0', 0},
	{"Alpha;", '\U00000391', 0},
	{"Amacr;", '\U00000100', 0},
	{"And;", '\U00002A53', 0},
	{"Aogon;", '\U00000104', 0},
	{"Aopf;", '\U0001D538', 0},
	{"ApplyFunction;", '\U00002061', 0},
	{"Aring", '\U000000C5', 0},
	{"Aring;", '\U000000C5', 0},
	{"Ascr;", '\U0001D49C', 0},
	{"Assign;", '\U00002254', 0},
	{"Atilde", '\U000000C3', 0},
	{"Atilde;", '\U000000C3', 0},
	{"Auml", '\U000000C4', 0},
	{"Auml;", '\U000000C4', 0},
	{"Backslash;", '\U00002216', 0},
	{"Barv;", '\U00002AE7', 0},
	{"Barwed;", '\U00002306', 0},
	{"Bcy;", '\U00000411', 0},
	{"Because;", '\U00002235', 0},
	{"Bernoullis;", '\U0000212C', 0},
	{"Beta;", '\U00000392', 0},
	{"Bfr;", '\U0001D505', 0},
	{"Bopf;", '\U0001D539', 0},
	{"Breve;", '\U000002D8', 0},
	{"Bscr;", '\U0000212C', 0},
	{"Bumpeq;", '\U0000224E', 0},
	{"CHcy;", '\U00000427', 0},
	{"COPY", '\U000000A9', 0},
	{"COPY;", '\U000000A9', 0},
	{"Cacute;", '\U00000106', 0},
	{"Cap;", '\U000022D2', 0},
	{"CapitalDifferentialD;", '\U00002145', 0},
	{"Cayleys;", '\U0000212D', 0},
	{"Ccaron;", '\U0000010C', 0},
	{"Ccedil", '\U000000C7', 0},
	{"Ccedil;", '\U000000C7', 0},
	{"Ccirc;", '\U00000108', 0},
	{"Cconint;", '\U00002230', 0},
	{"Cdot;", '\U0000010A', 0},
	{"Cedilla;", '\U000000B8', 0},
	{"CenterDot;", '\U000000B7', 0},
	{"Cfr;", '\U0000212D', 0},
	{"Chi;", '\U000003A7', 0},
	{"CircleDot;", '\U00002299', 0},
	{"CircleMinus;", '\U00002296', 0},
	{"CirclePlus;", '\U00002295', 0},
	{"CircleTimes;", '\U00002297', 0},
	{"ClockwiseContourIntegral;", '\U00002232', 0},
	{"CloseCurlyDoubleQuote;", '\U0000201D', 0},
	{"CloseCurlyQuote;", '\U00002019', 0},
	{"Colon;", '\U00002237', 0},
	{"Colone;", '\U00002A74', 0},
	{"Congruent;", '\U00002261', 0},
	{"Conint;", '\U0000222F', 0},
	{"ContourIntegral;", '\U0000222E', 0},
	{"Copf;", '\U00002102', 0},
	{"Coproduct;", '\U00002210', 0},
	{"CounterClockwiseContourIntegral;", '\U00002233', 0},
	{"Cross;", '\U00002A2F', 0},
	{"Cscr;", '\U0001D49E', 0},
	{"Cup;", '\U000022D3', 0},
	{"CupCap;", '\U0000224D', 0},
	{"DD;", '\U00002145', 0},
	{"DDotrahd;", '\U00002911', 0},
	{"DJcy;", '\U00000402', 0},
	{"DScy;", '\U00000405', 0},
	{"DZcy;", '\U0000040F', 0},
	{"Dagger;", '\U00002021', 0},
	{"Darr;", '\U000021A1', 0},
	{"Dashv;", '\U00002AE4', 0},
	{"Dcaron;", '\U0000010E', 0},
	{"Dcy;", '\U00000414', 0},
	{"Del;", '\U00002207', 0},
	{"Delta;", '\U00000394', 0},
	{"Dfr;", '\U0001D507', 0},
	{"DiacriticalAcute;", '\U000000B4', 0},
	{"DiacriticalDot;", '\U000002D9', 0},
	{"DiacriticalDoubleAcute;", '\U000002DD', 0},
	{"DiacriticalGrave;", '\U00000060', 0},
	{"DiacriticalTilde;", '\U000002DC', 0},
	{"Diamond;", '\U000022C4', 0},
	{"DifferentialD;", '\U00002146', 0},
	{"Dopf;", '\U0001D53B', 0},
	{"Dot;", '\U000000A8', 0},
	{"DotDot;", '\U000020DC', 0},
	{"DotEqual;", '\U00002250', 0},
	{"DoubleContourIntegral;", '\U0000222F', 0},
	{"DoubleDot;", '\U000000A8', 0},
	{"DoubleDownArrow;", '\U000021D3', 0},
	{"DoubleLeftArrow;", '\U000021D0', 0},
	{"DoubleLeftRightArrow;", '\U000021D4', 0},
	{"DoubleLeftTee;", '\U00002AE4', 0},
	{"DoubleLongLeftArrow;", '\U000027F8', 0},
	{"DoubleLongLeftRightArrow;", '\U000027FA', 0},
	{"DoubleLongRightArrow;", '\U000027F9', 0},
	{"DoubleRightArrow;", '\U000021D2', 0},
	{"DoubleRightTee;", '\U000022A8', 0},
	{"DoubleUpArrow;", '\U000021D1', 0},
	{"DoubleUpDownArrow;", '\U000021D5', 0},
	{"DoubleVerticalBar;", '\U00002225', 0},
	{"DownArrow;", '\U00002193', 0},
	{"DownArrowBar;", '\U00002913', 0},
	{"DownArrowUpArrow;", '\U000021F5', 0},
	{"DownBreve;", '\U00000311', 0},
	{"DownLeftRightVector;", '\U00002950', 0},
	{"DownLeftTeeVector;", '\U0000295E', 0},
	{"DownLeftVector;", '\U000021BD', 0},
	{"DownLeftVectorBar;", '\U00002956', 0},
	{"DownRightTeeVector;", '\U0000295F', 0},
	{"DownRightVector;", '\U000021C1', 0},
	{"DownRightVectorBar;", '\U00002957', 0},
	{"DownTee;", '\U000022A4', 0},
	{"DownTeeArrow;", '\U000021A7', 0},
	{"Downarrow;", '\U000021D3', 0},
	{"Dscr;", '\U0001D49F', 0},
	{"Dstrok;", '\U00000110', 0},
	{"ENG;", '\U0000014A', 0},
	{"ETH", '\U000000D0', 0},
	{"ETH;", '\U000000D0', 0},
	{"Eacute", '\U000000C9', 0},
	{"Eacute;", '\U000000C9', 0},
	{"Ecaron;", '\U0000011A', 0},
	{"Ecirc", '\U000000CA', 0},
	{"Ecirc;", '\U000000CA', 0},
	{"Ecy;", '\U0000042D', 0},
	{"Edot;", '\U00000116', 0},
	{"Efr;", '\U0001D508', 0},
	{"Egrave", '\U000000C8', 0},
	{"Egrave;", '\U000000C8', 0},
	{"Element;", '\U00002208', 0},
	{"Emacr;", '\U00000112', 0},
	{"EmptySmallSquare;", '\U000025FB', 0},
	{"EmptyVerySmallSquare;", '\U000025AB', 0},
	{"Eogon;", '\U00000118', 0},
	{"Eopf;", '\U0001D53C', 0},
	{"Epsilon;", '\U00000395', 0},
	{"Equal;", '\U00002A75', 0},
	{"EqualTilde;", '\U00002242', 0},
	{"Equilibrium;", '\U000021CC', 0},
	{"Escr;", '\U00002130', 0},
	{"Esim;", '\U00002A73', 0},
	{"Eta;", '\U00000397', 0},
	{"Euml", '\U000000CB', 0},
	{"Euml;", '\U000000CB', 0},
	{"Exists;", '\U00002203', 0},
	{"ExponentialE;", '\U00002147', 0},
	{"Fcy;", '\U00000424', 0},
	{"Ffr;", '\U0001D509', 0},
	{"FilledSmallSquare;", '\U000025FC', 0},
	{"FilledVerySmallSquare;", '\U000025AA', 0},
	{"Fopf;", '\U0001D53D', 0},
	{"ForAll;", '\U00002200', 0},
	{"Fouriertrf;", '\U00002131', 0},
	{"Fscr;", '\U00002131', 0},
	{"GJcy;", '\U00000403', 0},
	{"GT", '\U0000003E', 0},
	{"GT;", '\U0000003E', 0},
	{"Gamma;", '\U00000393', 0},
	{"Gammad;", '\U000003DC', 0},
	{"Gbreve;", '\U0000011E', 0},
	{"Gcedil;", '\U00000122', 0},
	{"Gcirc;", '\U0000011C', 0},
	{"Gcy;", '\U00000413', 0},
	{"Gdot;", '\U00000120', 0},
	{"Gfr;", '\U0001D50A', 0},
	{"Gg;", '\U000022D9', 0},
	{"Gopf;", '\U0001D53E', 0},
	{"GreaterEqual;", '\U00002265', 0},
	{"GreaterEqualLess;", '\U000022DB', 0},
	{"GreaterFullEqual;", '\U00002267', 0},
	{"GreaterGreater;", '\U00002AA2', 0},
	{"GreaterLess;", '\U00002277', 0},
	{"GreaterSlantEqual;", '\U00002A7E', 0},
	{"GreaterTilde;", '\U00002273', 0},
	{"Gscr;", '\U0001D4A2', 0},
	{"Gt;", '\U0000226B', 0},
	{"HARDcy;", '\U0000042A', 0},
	{"Hacek;", '\U000002C7', 0},
	{"Hat;", '\U0000005E', 0},
	{"Hcirc;", '\U00000124', 0},
	{"Hfr;", '\U0000210C', 0},
	{"HilbertSpace;", '\U0000210B', 0},
	{"Hopf;", '\U0000210D', 0},
	{"HorizontalLine;", '\U00002500', 0},
	{"Hscr;", '\U0000210B', 0},
	{"Hstrok;", '\U00000126', 0},
	{"HumpDownHump;", '\U0000224E', 0},
	{"HumpEqual;", '\U0000224F', 0},
	{"IEcy;", '\U00000415', 0},
	{"IJlig;", '\U00000132', 0},
	{"IOcy;", '\U00000401', 0},
	{"Iacute", '\U000000CD', 0},
	{"Iacute;", '\U000000CD', 0},
	{"Icirc", '\U000000CE', 0},
	{"Icirc;", '\U000000CE', 0},
	{"Icy;", '\U00000418', 0},
	{"Idot;", '\U00000130', 0},
	{"Ifr;", '\U00002111', 0},
	{"Igrave", '\U000000CC', 0},
	{"Igrave;", '\U000000CC', 0},
	{"Im;", '\U00002111', 0},
	{"Imacr;", '\U0000012A', 0},
	{"ImaginaryI;", '\U00002148', 0},
	{"Implies;", '\U000021D2', 0},
	{"Int;", '\U0000222C', 0},
	{"Integral;", '\U0000222B', 0},
	{"Intersection;", '\U000022C2', 0},
	{"InvisibleComma;", '\U00002063', 0},
	{"InvisibleTimes;", '\U00002062', 0},
	{"Iogon;", '\U0000012E', 0},
	{"Iopf;", '\U0001D540', 0},
	{"Iota;", '\U00000399', 0},
	{"Iscr;", '\U00002110', 0},
	{"Itilde;", '\U00000128', 0},
	{"Iukcy;", '\U00000406', 0},
	{"Iuml", '\U000000CF', 0},
	{"Iuml;", '\U000000CF', 0},
	{"Jcirc;", '\U00000134', 0},
	{"Jcy;", '\U00000419', 0},
	{"Jfr;", '\U0001D50D', 0},
	{"Jopf;", '\U0001D541', 0},
	{"Jscr;", '\U0001D4A5', 0},
	{"Jsercy;", '\U00000408', 0},
	{"Jukcy;", '\U00000404', 0},
	{"KHcy;", '\U00000425', 0},
	{"KJcy;", '\U0000040C', 0},
	{"Kappa;", '\U0000039A', 0},
	{"Kcedil;", '\U00000136', 0},
	{"Kcy;", '\U0000041A', 0},
	{"Kfr;", '\U0001D50E', 0},
	{"Kopf;", '\U0001D542', 0},
	{"Kscr;", '\U0001D4A6', 0},
	{"LJcy;", '\U00000409', 0},
	{"LT", '\U0000003C', 0},
	{"LT;", '\U0000003C', 0},
	{"Lacute;", '\U00000139', 0},
	{"Lambda;", '\U0000039B', 0},
	{"Lang;", '\U000027EA', 0},
	{"Laplacetrf;", '\U00002112', 0},
	{"Larr;", '\U0000219E', 0},
	{"Lcaron;", '\U0000013D', 0},
	{"Lcedil;", '\U0000013B', 0},
	{"Lcy;", '\U0000041B', 0},
	{"LeftAngleBracket;", '\U000027E8', 0},
	{"LeftArrow;", '\U00002190', 0},
	{"LeftArrowBar;", '\U000021E4', 0},
	{"LeftArrowRightArrow;", '\U000021C6', 0},
	{"LeftCeiling;", '\U00002308', 0},
	{"LeftDoubleBracket;", '\U000027E6', 0},
	{"LeftDownTeeVector;", '\U00002961', 0},
	{"LeftDownVector;", '\U000021C3', 0},
	{"LeftDownVectorBar;", '\U00002959', 0},
	{"LeftFloor;", '\U0000230A', 0},
	{"LeftRightArrow;", '\U00002194', 0},
	{"LeftRightVector;", '\U0000294E', 0},
	{"LeftTee;", '\U000022A3', 0},
	{"LeftTeeArrow;", '\U000021A4', 0},
	{"LeftTeeVector;", '\U0000295A', 0},
	{"LeftTriangle;", '\U000022B2', 0},
	{"LeftTriangleBar;", '\U000029CF', 0},
	{"LeftTriangleEqual;", '\U000022B4', 0},
	{"LeftUpDownVector;", '\U00002951', 0},
	{"LeftUpTeeVector;", '\U00002960', 0},
	{"LeftUpVector;", '\U000021BF', 0},
	{"LeftUpVectorBar;", '\U00002958', 0},
	{"LeftVector;", '\U000021BC', 0},
	{"LeftVectorBar;", '\U00002952', 0},
	{"Leftarrow;", '\U000021D0', 0},
	{"Leftrightarrow;", '\U000021D4', 0},
	{"LessEqualGreater;", '\U000022DA', 0},
	{"LessFullEqual;", '\U00002266', 0},
	{"LessGreater;", '\U00002276', 0},
	{"LessLess;", '\U00002AA1', 0},
	{"LessSlantEqual;", '\U00002A7D', 0},
	{"LessTilde;", '\U00002272', 0},
	{"Lfr;", '\U0001D50F', 0},
	{"Ll;", '\U000022D8', 0},
	{"Lleftarrow;", '\U000021DA', 0},
	{"Lmidot;", '\U0000013F', 0},
	{"LongLeftArrow;", '\U000027F5', 0},
	{"LongLeftRightArrow;", '\U000027F7', 0},
	{"LongRightArrow;", '\U000027F6', 0},
	{"Longleftarrow;", '\U000027F8', 0},
	{"Longleftrightarrow;", '\U000027FA', 0},
	{"Longrightarrow;", '\U000027F9', 0},
	{"Lopf;", '\U0001D543', 0},
	{"LowerLeftArrow;", '\U00002199', 0},
	{"LowerRightArrow;", '\U00002198', 0},
	{"Lscr;", '\U00002112', 0},
	{"Lsh;", '\U000021B0', 0},
	{"Lstrok;", '\U00000141', 0},
	{"Lt;", '\U0000226A', 0},
	{"Map;", '\U00002905', 0},
	{"Mcy;", '\U0000041C', 0},
	{"MediumSpace;", '\U0000205F', 0},
	{"Mellintrf;", '\U00002133', 0},
	{"Mfr;", '\U0001D510', 0},
	{"MinusPlus;", '\U00002213', 0},
	{"Mopf;", '\U0001D544', 0},
	{"Mscr;", '\U00002133', 0},
	{"Mu;", '\U0000039C', 0},
	{"NJcy;", '\U0000040A', 0},
	{"Nacute;", '\U00000143', 0},
	{"Ncaron;", '\U00000147', 0},
	{"Ncedil;", '\U00000145', 0},
	{"Ncy;", '\U0000041D', 0},
	{"NegativeMediumSpace;", '\U0000200B', 0},
	{"NegativeThickSpace;", '\U0000200B', 0},
	{"NegativeThinSpace;", '\U0000200B', 0},
	{"NegativeVeryThinSpace;", '\U0000200B', 0},
	{"NestedGreaterGreater;", '\U0000226B', 0},
	{"NestedLessLess;", '\U0000226A', 0},
	{"NewLine;", '\U0000000A', 0},
	{"Nfr;", '\U0001D511', 0},
	{"NoBreak;", '\U00002060', 0},
	{"NonBreakingSpace;", '\U000000A0', 0},
	{"Nopf;", '\U00002115', 0},
	{"Not;", '\U00002AEC', 0},
	{"NotCongruent;", '\U00002262', 0},
	{"NotCupCap;", '\U0000226D', 0},
	{"NotDoubleVerticalBar;", '\U00002226', 0},
	{"NotElement;", '\U00002209', 0},
	{"NotEqual;", '\U00002260', 0},
	{"NotEqualTilde;", '\u2242', '\u0338'},
	{"NotExists;", '\U00002204', 0},
	{"NotGreater;", '\U0000226F', 0},
	{"NotGreaterEqual;", '\U00002271', 0},
	{"NotGreaterFullEqual;", '\u2267', '\u0338'},
	{"NotGreaterGreater;", '\u226B', '\u0338'},
	{"NotGreaterLess;", '\U00002279', 0},
	{"NotGreaterSlantEqual;", '\u2A7E', '\u0338'},
	{"NotGreaterTilde;", '\U00002275', 0},
	{"NotHumpDownHump;", '\u224E', '\u0338'},
	{"NotHumpEqual;", '\u224F', '\u0338'},
	{"NotLeftTriangle;", '\U000022EA', 0},
	{"NotLeftTriangleBar;", '\u29CF', '\u0338'},
	{"NotLeftTriangleEqual;", '\U000022EC', 0},
	{"NotLess;", '\U0000226E', 0},
	{"NotLessEqual;", '\U00002270', 0},
	{"NotLessGreater;", '\U00002278', 0},
	{"NotLessLess;", '\u226A', '\u0338'},
	{"NotLessSlantEqual;", '\u2A7D', '\u0338'},
	{"NotLessTilde;", '\U00002274', 0},
	{"NotNestedGreaterGreater;", '\u2AA2', '\u0338'},
	{"NotNestedLessLess;", '\u2AA1', '\u0338'},
	{"NotPrecedes;", '\U00002280', 0},
	{"NotPrecedesEqual;", '\u2AAF', '\u0338'},
	{"NotPrecedesSlantEqual;", '\U000022E0', 0},
	{"NotReverseElement;", '\U0000220C', 0},
	{"NotRightTriangle;", '\U000022EB', 0},
	{"NotRightTriangleBar;", '\u29D0', '\u0338'},
	{"NotRightTriangleEqual;", '\U000022ED', 0},
	{"NotSquareSubset;", '\u228F', '\u0338'},
	{"NotSquareSubsetEqual;", '\U000022E2', 0},
	{"NotSquareSuperset;", '\u2290', '\u0338'},
	{"NotSquareSupersetEqual;", '\U000022E3', 0},
	{"NotSubset;", '\u2282', '\u20D2'},
	{"NotSubsetEqual;", '\U00002288', 0},
	{"NotSucceeds;", '\U00002281', 0},
	{"NotSucceedsEqual;", '\u2AB0', '\u0338'},
	{"NotSucceedsSlantEqual;", '\U000022E1', 0},
	{"NotSucceedsTilde;", '\u227F', '\u0338'},
	{"NotSuperset;", '\u2283', '\u20D2'},
	{"NotSupersetEqual;", '\U00002289', 0},
	{"NotTilde;", '\U00002241', 0},
	{"NotTildeEqual;", '\U00002244', 0},
	{"NotTildeFullEqual;", '\U00002247', 0},
	{"NotTildeTilde;", '\U00002249', 0},
	{"NotVerticalBar;", '\U00002224', 0},
	{"Nscr;", '\U0001D4A9', 0},
	{"Ntilde", '\U000000D1', 0},
	{"Ntilde;", '\U000000D1', 0},
	{"Nu;", '\U0000039D', 0},
	{"OElig;", '\U00000152', 0},
	{"Oacute", '\U000000D3', 0},
	{"Oacute;", '\U000000D3', 0},
	{"Ocirc", '\U000000D4', 0},
	{"Ocirc;", '\U000000D4', 0},
	{"Ocy;", '\U0000041E', 0},
	{"Odblac;", '\U00000150', 0},
	{"Ofr;", '\U0001D512', 0},
	{"Ograve", '\U000000D2', 0},
	{"Ograve;", '\U000000D2', 0},
	{"Omacr;", '\U0000014C', 0},
	{"Omega;", '\U000003A9', 0},
	{"Omicron;", '\U0000039F', 0},
	{"Oopf;", '\U0001D546', 0},
	{"OpenCurlyDoubleQuote;", '\U0000201C', 0},
	{"OpenCurlyQuote;", '\U00002018', 0},
	{"Or;", '\U00002A54', 0},
	{"Oscr;", '\U0001D4AA', 0},
	{"Oslash", '\U000000D8', 0},
	{"Oslash;", '\U000000D8', 0},
	{"Otilde", '\U000000D5', 0},
	{"Otilde;", '\U000000D5', 0},
	{"Otimes;", '\U00002A37', 0},
	{"Ouml", '\U000000D6', 0},
	{"Ouml;", '\U000000D6', 0},
	{"OverBar;", '\U0000203E', 0},
	{"OverBrace;", '\U000023DE', 0},
	{"OverBracket;", '\U000023B4', 0},
	{"OverParenthesis;", '\U000023DC', 0},
	{"PartialD;", '\U00002202', 0},
	{"Pcy;", '\U0000041F', 0},
	{"Pfr;", '\U0001D513', 0},
	{"Phi;", '\U000003A6', 0},
	{"Pi;", '\U000003A0', 0},
	{"PlusMinus;", '\U000000B1', 0},
	{"Poincareplane;", '\U0000210C', 0},
	{"Popf;", '\U00002119', 0},
	{"Pr;", '\U00002ABB', 0},
	{"Precedes;", '\U0000227A', 0},
	{"PrecedesEqual;", '\U00002AAF', 0},
	{"PrecedesSlantEqual;", '\U0000227C', 0},
	{"PrecedesTilde;", '\U0000227E', 0},
	{"Prime;", '\U00002033', 0},
	{"Product;", '\U0000220F', 0},
	{"Proportion;", '\U00002237', 0},
	{"Proportional;", '\U0000221D', 0},
	{"Pscr;", '\U0001D4AB', 0},
	{"Psi;", '\U000003A8', 0},
	{"QUOT", '\U00000022', 0},
	{"QUOT;", '\U00000022', 0},
	{"Qfr;", '\U0001D514', 0},
	{"Qopf;", '\U0000211A', 0},
	{"Qscr;", '\U0001D4AC', 0},
	{"RBarr;", '\U00002910', 0},
	{"REG", '\U000000AE', 0},
	{"REG;", '\U000000AE', 0},
	{"Racute;", '\U00000154', 0},
	{"Rang;", '\U000027EB', 0},
	{"Rarr;", '\U000021A0', 0},
	{"Rarrtl;", '\U00002916', 0},
	{"Rcaron;", '\U00000158', 0},
	{"Rcedil;", '\U00000156', 0},
	{"Rcy;", '\U00000420', 0},
	{"Re;", '\U0000211C', 0},
	{"ReverseElement;", '\U0000220B', 0},
	{"ReverseEquilibrium;", '\U000021CB', 0},
	{"ReverseUpEquilibrium;", '\U0000296F', 0},
	{"Rfr;", '\U0000211C', 0},
	{"Rho;", '\U000003A1', 0},
	{"RightAngleBracket;", '\U000027E9', 0},
	{"RightArrow;", '\U00002192', 0},
	{"RightArrowBar;", '\U000021E5', 0},
	{"RightArrowLeftArrow;", '\U000021C4', 0},
	{"RightCeiling;", '\U00002309', 0},
	{"RightDoubleBracket;", '\U000027E7', 0},
	{"RightDownTeeVector;", '\U0000295D', 0},
	{"RightDownVector;", '\U000021C2', 0},
	{"RightDownVectorBar;", '\U00002955', 0},
	{"RightFloor;", '\U0000230B', 0},
	{"RightTee;", '\U000022A2', 0},
	{"RightTeeArrow;", '\U000021A6', 0},
	{"RightTeeVector;", '\U0000295B', 0},
	{"RightTriangle;", '\U000022B3', 0},
	{"RightTriangleBar;", '\U000029D0', 0},
	{"RightTriangleEqual;", '\U000022B5', 0},
	{"RightUpDownVector;", '\U0000294F', 0},
	{"RightUpTeeVector;", '\U0000295C', 0},
	{"RightUpVector;", '\U000021BE', 0},
	{"RightUpVectorBar;", '\U00002954', 0},
	{"RightVector;", '\U000021C0', 0},
	{"RightVectorBar;", '\U00002953', 0},
	{"Rightarrow;", '\U000021D2', 0},
	{"Ropf;", '\U0000211D', 0},
	{"RoundImplies;", '\U00002970', 0},
	{"Rrightarrow;", '\U000021DB', 0},
	{"Rscr;", '\U0000211B', 0},
	{"Rsh;", '\U000021B1', 0},
	{"RuleDelayed;", '\U000029F4', 0},
	{"SHCHcy;", '\U00000429', 0},
	{"SHcy;", '\U00000428', 0},
	{"SOFTcy;", '\U0000042C', 0},
	{"Sacute;", '\U0000015A', 0},
	{"Sc;", '\U00002ABC', 0},
	{"Scaron;", '\U00000160', 0},
	{"Scedil;", '\U0000015E', 0},
	{"Scirc;", '\U0000015C', 0},
	{"Scy;", '\U00000421', 0},
	{"Sfr;", '\U0001D516', 0},
	{"ShortDownArrow;", '\U00002193', 0},
	{"ShortLeftArrow;", '\U00002190', 0},
	{"ShortRightArrow;", '\U00002192', 0},
	{"ShortUpArrow;", '\U00002191', 0},
	{"Sigma;", '\U000003A3', 0},
	{"SmallCircle;", '\U00002218', 0},
	{"Sopf;", '\U0001D54A', 0},
	{"Sqrt;", '\U0000221A', 0},
	{"Square;", '\U000025A1', 0},
	{"SquareIntersection;", '\U00002293', 0},
	{"SquareSubset;", '\U0000228F', 0},
	{"SquareSubsetEqual;", '\U00002291', 0},
	{"SquareSuperset;", '\U00002290', 0},
	{"SquareSupersetEqual;", '\U00002292', 0},
	{"SquareUnion;", '\U00002294', 0},
	{"Sscr;", '\U0001D4AE', 0},
	{"Star;", '\U000022C6', 0},
	{"Sub;", '\U000022D0', 0},
	{"Subset;", '\U000022D0', 0},
	{"SubsetEqual;", '\U00002286', 0},
	{"Succeeds;", '\U0000227B', 0},
	{"SucceedsEqual;", '\U00002AB0', 0},
	{"SucceedsSlantEqual;", '\U0000227D', 0},
	{"SucceedsTilde;", '\U0000227F', 0},
	{"SuchThat;", '\U0000220B', 0},
	{"Sum;", '\U00002211', 0},
	{"Sup;", '\U000022D1', 0},
	{"Superset;", '\U00002283', 0},
	{"SupersetEqual;", '\U00002287', 0},
	{"Supset;", '\U000022D1', 0},
	{"THORN", '\U000000DE', 0},
	{"THORN;", '\U000000DE', 0},
	{"TRADE;", '\U00002122', 0},
	{"TSHcy;", '\U0000040B', 0},
	{"TScy;", '\U00000426', 0},
	{"Tab;", '\U00000009', 0},
	{"Tau;", '\U000003A4', 0},
	{"Tcaron;", '\U00000164', 0},
	{"Tcedil;", '\U00000162', 0},
	{"Tcy;", '\U00000422', 0},
	{"Tfr;", '\U0001D517', 0},
	{"Therefore;", '\U00002234', 0},
	{"Theta;", '\U00000398', 0},
	{"ThickSpace;", '\u205F', '\u200A'},
	{"ThinSpace;", '\U00002009', 0},
	{"Tilde;", '\U0000223C', 0},
	{"TildeEqual;", '\U00002243', 0},
	{"TildeFullEqual;", '\U00002245', 0},
	{"TildeTilde;", '\U00002248', 0},
	{"Topf;", '\U0001D54B', 0},
	{"TripleDot;", '\U000020DB', 0},
	{"Tscr;", '\U0001D4AF', 0},
	{"Tstrok;", '\U00000166', 0},
	{"Uacute", '\U000000DA', 0},
	{"Uacute;", '\U000000DA', 0},
	{"Uarr;", '\U0000219F', 0},
	{"Uarrocir;", '\U00002949', 0},
	{"Ubrcy;", '\U0000040E', 0},
	{"Ubreve;", '\U0000016C', 0},
	{"Ucirc", '\U000000DB', 0},
	{"Ucirc;", '\U000000DB', 0},
	{"Ucy;", '\U00000423', 0},
	{"Udblac;", '\U00000170', 0},
	{"Ufr;", '\U0001D518', 0},
	{"Ugrave", '\U000000D9', 0},
	{"Ugrave;", '\U000000D9', 0},
	{"Umacr;", '\U0000016A', 0},
	{"UnderBar;", '\U0000005F', 0},
	{"UnderBrace;", '\U000023DF', 0},
	{"UnderBracket;", '\U000023B5', 0},
	{"UnderParenthesis;", '\U000023DD', 0},
	{"Union;", '\U000022C3', 0},
	{"UnionPlus;", '\U0000228E', 0},
	{"Uogon;", '\U00000172', 0},
	{"Uopf;", '\U0001D54C', 0},
	{"UpArrow;", '\U00002191', 0},
	{"UpArrowBar;", '\U00002912', 0},
	{"UpArrowDownArrow;", '\U000021C5', 0},
	{"UpDownArrow;", '\U00002195', 0},
	{"UpEquilibrium;", '\U0000296E', 0},
	{"UpTee;", '\U000022A5', 0},
	{"UpTeeArrow;", '\U000021A5', 0},
	{"Uparrow;", '\U000021D1', 0},
	{"Updownarrow;", '\U000021D5', 0},
	{"UpperLeftArrow;", '\U00002196', 0},
	{"UpperRightArrow;", '\U00002197', 0},
	{"Upsi;", '\U000003D2', 0},
	{"Upsilon;", '\U000003A5', 0},
	{"Uring;", '\U0000016E', 0},
	{"Uscr;", '\U0001D4B0', 0},
	{"Utilde;", '\U00000168', 0},
	{"Uuml", '\U000000DC', 0},
	{"Uuml;", '\U000000DC', 0},
	{"VDash;", '\U000022AB', 0},
	{"Vbar;", '\U00002AEB', 0},
	{"Vcy;", '\U00000412', 0},
	{"Vdash;", '\U000022A9', 0},
	{"Vdashl;", '\U00002AE6', 0},
	{"Vee;", '\U000022C1', 0},
	{"Verbar;", '\U00002016', 0},
	{"Vert;", '\U00002016', 0},
	{"VerticalBar;", '\U00002223', 0},
	{"VerticalLine;", '\U0000007C', 0},
	{"VerticalSeparator;", '\U00002758', 0},
	{"VerticalTilde;", '\U00002240', 0},
	{"VeryThinSpace;", '\U0000200A', 0},
	{"Vfr;", '\U0001D519', 0},
	{"Vopf;", '\U0001D54D', 0},
	{"Vscr;", '\U0001D4B1', 0},
	{"Vvdash;", '\U000022AA', 0},
	{"Wcirc;", '\U00000174', 0},
	{"Wedge;", '\U000022C0', 0},
	{"Wfr;", '\U0001D51A', 0},
	{"Wopf;", '\U0001D54E', 0},
	{"Wscr;", '\U0001D4B2', 0},
	{"Xfr;", '\U0001D51B', 0},
	{"Xi;", '\U0000039E', 0},
	{"Xopf;", '\U0001D54F', 0},
	{"Xscr;", '\U0001D4B3', 0},
	{"YAcy;", '\U0000042F', 0},
	{"YIcy;", '\U00000407', 0},
	{"YUcy;", '\U0000042E', 0},
	{"Yacute", '\U000000DD', 0},
	{"Yacute;", '\U000000DD', 0},
	{"Ycirc;", '\U00000176', 0},
	{"Ycy;", '\U0000042B', 0},
	{"Yfr;", '\U0001D51C', 0},
	{"Yopf;", '\U0001D550', 0},
	{"Yscr;", '\U0001D4B4', 0},
	{"Yuml;", '\U00000178', 0},
	{"ZHcy;", '\U00000416', 0},
	{"Zacute;", '\U00000179', 0},
	{"Zcaron;", '\U0000017D', 0},
	{"Zcy;", '\U00000417', 0},
	{"Zdot;", '\U0000017B', 0},
	{"ZeroWidthSpace;", '\U0000200B', 0},
	{"Zeta;", '\U00000396', 0},
	{"Zfr;", '\U00002128', 0},
	{"Zopf;", '\U00002124', 0},
	{"Zscr;", '\U0001D4B5', 0},
	{"aacute", '\U000000E1', 0},
	{"aacute;", '\U000000E1', 0},
	{"abreve;", '\U00000103', 0},
	{"ac;", '\U0000223E', 0},
	{"acE;", '\u223E', '\u0333'},
	{"acd;", '\U0000223F', 0},
	{"acirc", '\U000000E2', 0},
	{"acirc;", '\U000000E2', 0},
	{"acute", '\U000000B4', 0},
	{"acute;", '\U000000B4', 0},
	{"acy;", '\U00000430', 0},
	{"aelig", '\U000000E6', 0},
	{"aelig;", '\U000000E6', 0},
	{"af;", '\U00002061', 0},
	{"afr;", '\U0001D51E', 0},
	{"agrave", '\U000000E0', 0},
	{"agrave;", '\U000000E0', 0},
	{"alefsym;", '\U00002135', 0},
	{"aleph;", '\U00002135', 0},
	{"alpha;", '\U000003B1', 0},
	{"amacr;", '\U00000101', 0},
	{"amalg;", '\U00002A3F', 0},
	{"amp", '\U00000026', 0},
	{"amp;", '\U00000026', 0},
	{"and;", '\U00002227', 0},
	{"andand;", '\U00002A55', 0},
	{"andd;", '\U00002A5C', 0},
	{"andslope;", '\U00002A58', 0},
	{"andv;", '\U00002A5A', 0},
	{"ang;", '\U00002220', 0},
	{"ange;", '\U000029A4', 0},
	{"angle;", '\U00002220', 0},
	{"angmsd;", '\U00002221', 0},
	{"angmsdaa;", '\U000029A8', 0},
	{"angmsdab;", '\U000029A9', 0},
	{"angmsdac;", '\U000029AA', 0},
	{"angmsdad;", '\U000029AB', 0},
	{"angmsdae;", '\U000029AC', 0},
	{"angmsdaf;", '\U000029AD', 0},
	{"angmsdag;", '\U000029AE', 0},
	{"angmsdah;", '\U000029AF', 0},
	{"angrt;", '\U0000221F', 0},
	{"angrtvb;", '\U000022BE', 0},
	{"angrtvbd;", '\U0000299D', 0},
	{"angsph;", '\U00002222', 0},
	{"angst;", '\U000000C5', 0},
	{"angzarr;", '\U0000237C', 0},
	{"aogon;", '\U00000105', 0},
	{"aopf;", '\U0001D552', 0},
	{"ap;", '\U00002248', 0},
	{"apE;", '\U00002A70', 0},
	{"apacir;", '\U00002A6F', 0},
	{"ape;", '\U0000224A', 0},
	{"apid;", '\U0000224B', 0},
	{"apos;", '\U00000027', 0},
	{"approx;", '\U00002248', 0},
	{"approxeq;", '\U0000224A', 0},
	{"aring", '\U000000E5', 0},
	{"aring;", '\U000000E5', 0},
	{"ascr;", '\U0001D4B6', 0},
	{"ast;", '\U0000002A', 0},
	{"asymp;", '\U00002248', 0},
	{"asympeq;", '\U0000224D', 0},
	{"atilde", '\U000000E3', 0},
	{"atilde;", '\U000000E3', 0},
	{"auml", '\U000000E4', 0},
	{"auml;", '\U000000E4', 0},
	{"awconint;", '\U00002233', 0},
	{"awint;", '\U00002A11', 0},
	{"bNot;", '\U00002AED', 0},
	{"backcong;", '\U0000224C', 0},
	{"backepsilon;", '\U000003F6', 0},
	{"backprime;", '\U00002035', 0},
	{"backsim;", '\U0000223D', 0},
	{"backsimeq;", '\U000022CD', 0},
	{"barvee;", '\U000022BD', 0},
	{"barwed;", '\U00002305', 0},
	{"barwedge;", '\U00002305', 0},
	{"bbrk;", '\U000023B5', 0},
	{"bbrktbrk;", '\U000023B6', 0},
	{"bcong;", '\U0000224C', 0},
	{"bcy;", '\U00000431', 0},
	{"bdquo;", '\U0000201E', 0},
	{"becaus;", '\U00002235', 0},
	{"because;", '\U00002235', 0},
	{"bemptyv;", '\U000029B0', 0},
	{"bepsi;", '\U000003F6', 0},
	{"bernou;", '\U0000212C', 0},
	{"beta;", '\U000003B2', 0},
	{"beth;", '\U00002136', 0},
	{"between;", '\U0000226C', 0},
	{"bfr;", '\U0001D51F', 0},
	{"bigcap;", '\U000022C2', 0},
	{"bigcirc;", '\U000025EF', 0},
	{"bigcup;", '\U000022C3', 0},
	{"bigodot;", '\U00002A00', 0},
	{"bigoplus;", '\U00002A01', 0},
	{"bigotimes;", '\U00002A02', 0},
	{"bigsqcup;", '\U00002A06', 0},
	{"bigstar;", '\U00002605', 0},
	{"bigtriangledown;", '\U000025BD', 0},
	{"bigtriangleup;", '\U000025B3', 0},
	{"biguplus;", '\U00002A04', 0},
	{"bigvee;", '\U000022C1', 0},
	{"bigwedge;", '\U000022C0', 0},
	{"bkarow;", '\U0000290D', 0},
	{"blacklozenge;", '\U000029EB', 0},
	{"blacksquare;", '\U000025AA', 0},
	{"blacktriangle;", '\U000025B4', 0},
	{"blacktriangledown;", '\U000025BE', 0},
	{"blacktriangleleft;", '\U000025C2', 0},
	{"blacktriangleright;", '\U000025B8', 0},
	{"blank;", '\U00002423', 0},
	{"blk12;", '\U00002592', 0},
	{"blk14;", '\U00002591', 0},
	{"blk34;", '\U00002593', 0},
	{"block;", '\U00002588', 0},
	{"bne;", '\u003D', '\u20E5'},
	{"bnequiv;", '\u2261', '\u20E5'},
	{"bnot;", '\U00002310', 0},
	{"bopf;", '\U0001D553', 0},
	{"bot;", '\U000022A5', 0},
	{"bottom;", '\U000022A5', 0},
	{"bowtie;", '\U000022C8', 0},
	{"boxDL;", '\U00002557', 0},
	{"boxDR;", '\U00002554', 0},
	{"boxDl;", '\U00002556', 0},
	{"boxDr;", '\U00002553', 0},
	{"boxH;", '\U00002550', 0},
	{"boxHD;", '\U00002566', 0},
	{"boxHU;", '\U00002569', 0},
	{"boxHd;", '\U00002564', 0},
	{"boxHu;", '\U00002567', 0},
	{"boxUL;", '\U0000255D', 0},
	{"boxUR;", '\U0000255A', 0},
	{"boxUl;", '\U0000255C', 0},
	{"boxUr;", '\U00002559', 0},
	{"boxV;", '\U00002551', 0},
	{"boxVH;", '\U0000256C', 0},
	{"boxVL;", '\U00002563', 0},
	{"boxVR;", '\U00002560', 0},
	{"boxVh;", '\U0000256B', 0},
	{"boxVl;", '\U00002562', 0},
	{"boxVr;", '\U0000255F', 0},
	{"boxbox;", '\U000029C9', 0},
	{"boxdL;", '\U00002555', 0},
	{"boxdR;", '\U00002552', 0},
	{"boxdl;", '\U00002510', 0},
	{"boxdr;", '\U0000250C', 0},
	{"boxh;", '\U00002500', 0},
	{"boxhD;", '\U00002565', 0},
	{"boxhU;", '\U00002568', 0},
	{"boxhd;", '\U0000252C', 0},
	{"boxhu;", '\U00002534', 0},
	{"boxminus;", '\U0000229F', 0},
	{"boxplus;", '\U0000229E', 0},
	{"boxtimes;", '\U000022A0', 0},
	{"boxuL;", '\U0000255B', 0},
	{"boxuR;", '\U00002558', 0},
	{"boxul;", '\U00002518', 0},
	{"boxur;", '\U00002514', 0},
	{"boxv;", '\U00002502', 0},
	{"boxvH;", '\U0000256A', 0},
	{"boxvL;", '\U00002561', 0},
	{"boxvR;", '\U0000255E', 0},
	{"boxvh;", '\U0000253C', 0},
	{"boxvl;", '\U00002524', 0},
	{"boxvr;", '\U0000251C', 0},
	{"bprime;", '\U00002035', 0},
	{"breve;", '\U000002D8', 0},
	{"brvbar", '\U000000A6', 0},
	{"brvbar;", '\U000000A6', 0},
	{"bscr;", '\U0001D4B7', 0},
	{"bsemi;", '\U0000204F', 0},
	{"bsim;", '\U0000223D', 0},
	{"bsime;", '\U000022CD', 0},
	{"bsol;", '\U0000005C', 0},
	{"bsolb;", '\U000029C5', 0},
	{"bsolhsub;", '\U000027C8', 0},
	{"bull;", '\U00002022', 0},
	{"bullet;", '\U00002022', 0},
	{"bump;", '\U0000224E', 0},
	{"bumpE;", '\U00002AAE', 0},
	{"bumpe;", '\U0000224F', 0},
	{"bumpeq;", '\U0000224F', 0},
	{"cacute;", '\U00000107', 0},
	{"cap;", '\U00002229', 0},
	{"capand;", '\U00002A44', 0},
	{"capbrcup;", '\U00002A49', 0},
	{"capcap;", '\U00002A4B', 0},
	{"capcup;", '\U00002A47', 0},
	{"capdot;", '\U00002A40', 0},
	{"caps;", '\u2229', '\uFE00'},
	{"caret;", '\U00002041', 0},
	{"caron;", '\U000002C7', 0},
	{"ccaps;", '\U00002A4D', 0},
	{"ccaron;", '\U0000010D', 0},
	{"ccedil", '\U000000E7', 0},
	{"ccedil;", '\U000000E7', 0},
	{"ccirc;", '\U00000109', 0},
	{"ccups;", '\U00002A4C', 0},
	{"ccupssm;", '\U00002A50', 0},
	{"cdot;", '\U0000010B', 0},
	{"cedil", '\U000000B8', 0},
	{"cedil;", '\U000000B8', 0},
	{"cemptyv;", '\U000029B2', 0},
	{"cent", '\U000000A2', 0},
	{"cent;", '\U000000A2', 0},
	{"centerdot;", '\U000000B7', 0},
	{"cfr;", '\U0001D520', 0},
	{"chcy;", '\U00000447', 0},
	{"check;", '\U00002713', 0},
	{"checkmark;", '\U00002713', 0},
	{"chi;", '\U000003C7', 0},
	{"cir;", '\U000025CB', 0},
	{"cirE;", '\U000029C3', 0},
	{"circ;", '\U000002C6', 0},
	{"circeq;", '\U00002257', 0},
	{"circlearrowleft;", '\U000021BA', 0},
	{"circlearrowright;", '\U000021BB', 0},
	{"circledR;", '\U000000AE', 0},
	{"circledS;", '\U000024C8', 0},
	{"circledast;", '\U0000229B', 0},
	{"circledcirc;", '\U0000229A', 0},
	{"circleddash;", '\U0000229D', 0},
	{"cire;", '\U00002257', 0},
	{"cirfnint;", '\U00002A10', 0},
	{"cirmid;", '\U00002AEF', 0},
	{"cirscir;", '\U000029C2', 0},
	{"clubs;", '\U00002663', 0},
	{"clubsuit;", '\U00002663', 0},
	{"colon;", '\U0000003A', 0},
	{"colone;", '\U00002254', 0},
	{"coloneq;", '\U00002254', 0},
	{"comma;", '\U0000002C', 0},
	{"commat;", '\U00000040', 0},
	{"comp;", '\U00002201', 0},
	{"compfn;", '\U00002218', 0},
	{"complement;", '\U00002201', 0},
	{"complexes;", '\U00002102', 0},
	{"cong;", '\U00002245', 0},
	{"congdot;", '\U00002A6D', 0},
	{"conint;", '\U0000222E', 0},
	{"copf;", '\U0001D554', 0},
	{"coprod;", '\U00002210', 0},
	{"copy", '\U000000A9', 0},
	{"copy;", '\U000000A9', 0},
	{"copysr;", '\U00002117', 0},
	{"crarr;", '\U000021B5', 0},
	{"cross;", '\U00002717', 0},
	{"cscr;", '\U0001D4B8', 0},
	{"csub;", '\U00002ACF', 0},
	{"csube;", '\U00002AD1', 0},
	{"csup;", '\U00002AD0', 0},
	{"csupe;", '\U00002AD2', 0},
	{"ctdot;", '\U000022EF', 0},
	{"cudarrl;", '\U00002938', 0},
	{"cudarrr;", '\U00002935', 0},
	{"cuepr;", '\U000022DE', 0},
	{"cuesc;", '\U000022DF', 0},
	{"cularr;", '\U000021B6', 0},
	{"cularrp;", '\U0000293D', 0},
	{"cup;", '\U0000222A', 0},
	{"cupbrcap;", '\U00002A48', 0},
	{"cupcap;", '\U00002A46', 0},
	{"cupcup;", '\U00002A4A', 0},
	{"cupdot;", '\U0000228D', 0},
	{"cupor;", '\U00002A45', 0},
	{"cups;", '\u222A', '\uFE00'},
	{"curarr;", '\U000021B7', 0},
	{"curarrm;", '\U0000293C', 0},
	{"curlyeqprec;", '\U000022DE', 0},
	{"curlyeqsucc;", '\U000022DF', 0},
	{"curlyvee;", '\U000022CE', 0},
	{"curlywedge;", '\U000022CF', 0},
	{"curren", '\U000000A4', 0},
	{"curren;", '\U000000A4', 0},
	{"curvearrowleft;", '\U000021B6', 0},
	{"curvearrowright;", '\U000021B7', 0},
	{"cuvee;", '\U000022CE', 0},
	{"cuwed;", '\U000022CF', 0},
	{"cwconint;", '\U00002232', 0},
	{"cwint;", '\U00002231', 0},
	{"cylcty;", '\U0000232D', 0},
	{"dArr;", '\U000021D3', 0},
	{"dHar;", '\U00002965', 0},
	{"dagger;", '\U00002020', 0},
	{"daleth;", '\U00002138', 0},
	{"darr;", '\U00002193', 0},
	{"dash;", '\U00002010', 0},
	{"dashv;", '\U000022A3', 0},
	{"dbkarow;", '\U0000290F', 0},
	{"dblac;", '\U000002DD', 0},
	{"dcaron;", '\U0000010F', 0},
	{"dcy;", '\U00000434', 0},
	{"dd;", '\U00002146', 0},
	{"ddagger;", '\U00002021', 0},
	{"ddarr;", '\U000021CA', 0},
	{"ddotseq;", '\U00002A77', 0},
	{"deg", '\U000000B0', 0},
	{"deg;", '\U000000B0', 0},
	{"delta;", '\U000003B4', 0},
	{"demptyv;", '\U000029B1', 0},
	{"dfisht;", '\U0000297F', 0},
	{"dfr;", '\U0001D521', 0},
	{"dharl;", '\U000021C3', 0},
	{"dharr;", '\U000021C2', 0},
	{"diam;", '\U000022C4', 0},
	{"diamond;", '\U000022C4', 0},
	{"diamondsuit;", '\U00002666', 0},
	{"diams;", '\U00002666', 0},
	{"die;", '\U000000A8', 0},
	{"digamma;", '\U000003DD', 0},
	{"disin;", '\U000022F2', 0},
	{"div;", '\U000000F7', 0},
	{"divide", '\U000000F7', 0},
	{"divide;", '\U000000F7', 0},
	{"divideontimes;", '\U000022C7', 0},
	{"divonx;", '\U000022C7', 0},
	{"djcy;", '\U00000452', 0},
	{"dlcorn;", '\U0000231E', 0},
	{"dlcrop;", '\U0000230D', 0},
	{"dollar;", '\U00000024', 0},
	{"dopf;", '\U0001D555', 0},
	{"dot;", '\U000002D9', 0},
	{"doteq;", '\U00002250', 0},
	{"doteqdot;", '\U00002251', 0},
	{"dotminus;", '\U00002238', 0},
	{"dotplus;", '\U00002214', 0},
	{"dotsquare;", '\U000022A1', 0},
	{"doublebarwedge;", '\U00002306', 0},
	{"downarrow;", '\U00002193', 0},
	{"downdownarrows;", '\U000021CA', 0},
	{"downharpoonleft;", '\U000021C3', 0},
	{"downharpoonright;", '\U000021C2', 0},
	{"drbkarow;", '\U00002910', 0},
	{"drcorn;", '\U0000231F', 0},
	{"drcrop;", '\U0000230C', 0},
	{"dscr;", '\U0001D4B9', 0},
	{"dscy;", '\U00000455', 0},
	{"dsol;", '\U000029F6', 0},
	{"dstrok;", '\U00000111', 0},
	{"dtdot;", '\U000022F1', 0},
	{"dtri;", '\U000025BF', 0},
	{"dtrif;", '\U000025BE', 0},
	{"duarr;", '\U000021F5', 0},
	{"duhar;", '\U0000296F', 0},
	{"dwangle;", '\U000029A6', 0},
	{"dzcy;", '\U0000045F', 0},
	{"dzigrarr;", '\U000027FF', 0},
	{"eDDot;", '\U00002A77', 0},
	{"eDot;", '\U00002251', 0},
	{"eacute", '\U000000E9', 0},
	{"eacute;", '\U000000E9', 0},
	{"easter;", '\U00002A6E', 0},
	{"ecaron;", '\U0000011B', 0},
	{"ecir;", '\U00002256', 0},
	{"ecirc", '\U000000EA', 0},
	{"ecirc;", '\U000000EA', 0},
	{"ecolon;", '\U00002255', 0},
	{"ecy;", '\U0000044D', 0},
	{"edot;", '\U00000117', 0},
	{"ee;", '\U00002147', 0},
	{"efDot;", '\U00002252', 0},
	{"efr;", '\U0001D522', 0},
	{"eg;", '\U00002A9A', 0},
	{"egrave", '\U000000E8', 0},
	{"egrave;", '\U000000E8', 0},
	{"egs;", '\U00002A96', 0},
	{"egsdot;", '\U00002A98', 0},
	{"el;", '\U00002A99', 0},
	{"elinters;", '\U000023E7', 0},
	{"ell;", '\U00002113', 0},
	{"els;", '\U00002A95', 0},
	{"elsdot;", '\U00002A97', 0},
	{"emacr;", '\U00000113', 0},
	{"empty;", '\U00002205', 0},
	{"emptyset;", '\U00002205', 0},
	{"emptyv;", '\U00002205', 0},
	{"emsp13;", '\U00002004', 0},
	{"emsp14;", '\U00002005', 0},
	{"emsp;", '\U00002003', 0},
	{"eng;", '\U0000014B', 0},
	{"ensp;", '\U00002002', 0},
	{"eogon;", '\U00000119', 0},
	{"eopf;", '\U0001D556', 0},
	{"epar;", '\U000022D5', 0},
	{"eparsl;", '\U000029E3', 0},
	{"eplus;", '\U00002A71', 0},
	{"epsi;", '\U000003B5', 0},
	{"epsilon;", '\U000003B5', 0},
	{"epsiv;", '\U000003F5', 0},
	{"eqcirc;", '\U00002256', 0},
	{"eqcolon;", '\U00002255', 0},
	{"eqsim;", '\U00002242', 0},
	{"eqslantgtr;", '\U00002A96', 0},
	{"eqslantless;", '\U00002A95', 0},
	{"equals;", '\U0000003D', 0},
	{"equest;", '\U0000225F', 0},
	{"equiv;", '\U00002261', 0},
	{"equivDD;", '\U00002A78', 0},
	{"eqvparsl;", '\U000029E5', 0},
	{"erDot;", '\U00002253', 0},
	{"erarr;", '\U00002971', 0},
	{"escr;", '\U0000212F', 0},
	{"esdot;", '\U00002250', 0},
	{"esim;", '\U00002242', 0},
	{"eta;", '\U000003B7', 0},
	{"eth", '\U000000F0', 0},
	{"eth;", '\U000000F0', 0},
	{"euml", '\U000000EB', 0},
	{"euml;", '\U000000EB', 0},
	{"euro;", '\U000020AC', 0},
	{"excl;", '\U00000021', 0},
	{"exist;", '\U00002203', 0},
	{"expectation;", '\U00002130', 0},
	{"exponentiale;", '\U00002147', 0},
	{"fallingdotseq;", '\U00002252', 0},
	{"fcy;", '\U00000444', 0},
	{"female;", '\U00002640', 0},
	{"ffilig;", '\U0000FB03', 0},
	{"fflig;", '\U0000FB00', 0},
	{"ffllig;", '\U0000FB04', 0},
	{"ffr;", '\U0001D523', 0},
	{"filig;", '\U0000FB01', 0},
	{"fjlig;", '\u0066', '\u006A'},
	{"flat;", '\U0000266D', 0},
	{"fllig;", '\U0000FB02', 0},
	{"fltns;", '\U000025B1', 0},
	{"fnof;", '\U00000192', 0},
	{"fopf;", '\U0001D557', 0},
	{"forall;", '\U00002200', 0},
	{"fork;", '\U000022D4', 0},
	{"forkv;", '\U00002AD9', 0},
	{"fpartint;", '\U00002A0D', 0},
	{"frac12", '\U000000BD', 0},
	{"frac12;", '\U000000BD', 0},
	{"frac13;", '\U00002153', 0},
	{"frac14", '\U000000BC', 0},
	{"frac14;", '\U000000BC', 0},
	{"frac15;", '\U00002155', 0},
	{"frac16;", '\U00002159', 0},
	{"frac18;", '\U0000215B', 0},
	{"frac23;", '\U00002154', 0},
	{"frac25;", '\U00002156', 0},
	{"frac34", '\U000000BE', 0},
	{"frac34;", '\U000000BE', 0},
	{"frac35;", '\U00002157', 0},
	{"frac38;", '\U0000215C', 0},
	{"frac45;", '\U00002158', 0},
	{"frac56;", '\U0000215A', 0},
	{"frac58;", '\U0000215D', 0},
	{"frac78;", '\U0000215E', 0},
	{"frasl;", '\U00002044', 0},
	{"frown;", '\U00002322', 0},
	{"fscr;", '\U0001D4BB', 0},
	{"gE;", '\U00002267', 0},
	{"gEl;", '\U00002A8C', 0},
	{"gacute;", '\U000001F5', 0},
	{"gamma;", '\U000003B3', 0},
	{"gammad;", '\U000003DD', 0},
	{"gap;", '\U00002A86', 0},
	{"gbreve;", '\U0000011F', 0},
	{"gcirc;", '\U0000011D', 0},
	{"gcy;", '\U00000433', 0},
	{"gdot;", '\U00000121', 0},
	{"ge;", '\U00002265', 0},
	{"gel;", '\U000022DB', 0},
	{"geq;", '\U00002265', 0},
	{"geqq;", '\U00002267', 0},
	{"geqslant;", '\U00002A7E', 0},
	{"ges;", '\U00002A7E', 0},
	{"gescc;", '\U00002AA9', 0},
	{"gesdot;", '\U00002A80', 0},
	{"gesdoto;", '\U00002A82', 0},
	{"gesdotol;", '\U00002A84', 0},
	{"gesl;", '\u22DB', '\uFE00'},
	{"gesles;", '\U00002A94', 0},
	{"gfr;", '\U0001D524', 0},
	{"gg;", '\U0000226B', 0},
	{"ggg;", '\U000022D9', 0},
	{"gimel;", '\U00002137', 0},
	{"gjcy;", '\U00000453', 0},
	{"gl;", '\U00002277', 0},
	{"glE;", '\U00002A92', 0},
	{"gla;", '\U00002AA5', 0},
	{"glj;", '\U00002AA4', 0},
	{"gnE;", '\U00002269', 0},
	{"gnap;", '\U00002A8A', 0},
	{"gnapprox;", '\U00002A8A', 0},
	{"gne;", '\U00002A88', 0},
	{"gneq;", '\U00002A88', 0},
	{"gneqq;", '\U00002269', 0},
	{"gnsim;", '\U000022E7', 0},
	{"gopf;", '\U0001D558', 0},
	{"grave;", '\U00000060', 0},
	{"gscr;", '\U0000210A', 0},
	{"gsim;", '\U00002273', 0},
	{"gsime;", '\U00002A8E', 0},
	{"gsiml;", '\U00002A90', 0},
	{"gt", '\U0000003E', 0},
	{"gt;", '\U0000003E', 0},
	{"gtcc;", '\U00002AA7', 0},
	{"gtcir;", '\U00002A7A', 0},
	{"gtdot;", '\U000022D7', 0},
	{"gtlPar;", '\U00002995', 0},
	{"gtquest;", '\U00002A7C', 0},
	{"gtrapprox;", '\U00002A86', 0},
	{"gtrarr;", '\U00002978', 0},
	{"gtrdot;", '\U000022D7', 0},
	{"gtreqless;", '\U000022DB', 0},
	{"gtreqqless;", '\U00002A8C', 0},
	{"gtrless;", '\U00002277', 0},
	{"gtrsim;", '\U00002273', 0},
	{"gvertneqq;", '\u2269', '\uFE00'},
	{"gvnE;", '\u2269', '\uFE00'},
	{"hArr;", '\U000021D4', 0},
	{"hairsp;", '\U0000200A', 0},
	{"half;", '\U000000BD', 0},
	{"hamilt;", '\U0000210B', 0},
	{"hardcy;", '\U0000044A', 0},
	{"harr;", '\U00002194', 0},
	{"harrcir;", '\U00002948', 0},
	{"harrw;", '\U000021AD', 0},
	{"hbar;", '\U0000210F', 0},
	{"hcirc;", '\U00000125', 0},
	{"hearts;", '\U00002665', 0},
	{"heartsuit;", '\U00002665', 0},
	{"hellip;", '\U00002026', 0},
	{"hercon;", '\U000022B9', 0},
	{"hfr;", '\U0001D525', 0},
	{"hksearow;", '\U00002925', 0},
	{"hkswarow;", '\U00002926', 0},
	{"hoarr;", '\U000021FF', 0},
	{"homtht;", '\U0000223B', 0},
	{"hookleftarrow;", '\U000021A9', 0},
	{"hookrightarrow;", '\U000021AA', 0},
	{"hopf;", '\U0001D559', 0},
	{"horbar;", '\U00002015', 0},
	{"hscr;", '\U0001D4BD', 0},
	{"hslash;", '\U0000210F', 0},
	{"hstrok;", '\U00000127', 0},
	{"hybull;", '\U00002043', 0},
	{"hyphen;", '\U00002010', 0},
	{"iacute", '\U000000ED', 0},
	{"iacute;", '\U000000ED', 0},
	{"ic;", '\U00002063', 0},
	{"icirc", '\U000000EE', 0},
	{"icirc;", '\U000000EE', 0},
	{"icy;", '\U00000438', 0},
	{"iecy;", '\U00000435', 0},
	{"iexcl", '\U000000A1', 0},
	{"iexcl;", '\U000000A1', 0},
	{"iff;", '\U000021D4', 0},
	{"ifr;", '\U0001D526', 0},
	{"igrave", '\U000000EC', 0},
	{"igrave;", '\U000000EC', 0},
	{"ii;", '\U00002148', 0},
	{"iiiint;", '\U00002A0C', 0},
	{"iiint;", '\U0000222D', 0},
	{"iinfin;", '\U000029DC', 0},
	{"iiota;", '\U00002129', 0},
	{"ijlig;", '\U00000133', 0},
	{"imacr;", '\U0000012B', 0},
	{"image;", '\U00002111', 0},
	{"imagline;", '\U00002110', 0},
	{"imagpart;", '\U00002111', 0},
	{"imath;", '\U00000131', 0},
	{"imof;", '\U000022B7', 0},
	{"imped;", '\U000001B5', 0},
	{"in;", '\U00002208', 0},
	{"incare;", '\U00002105', 0},
	{"infin;", '\U0000221E', 0},
	{"infintie;", '\U000029DD', 0},
	{"inodot;", '\U00000131', 0},
	{"int;", '\U0000222B', 0},
	{"intcal;", '\U000022BA', 0},
	{"integers;", '\U00002124', 0},
	{"intercal;", '\U000022BA', 0},
	{"intlarhk;", '\U00002A17', 0},
	{"intprod;", '\U00002A3C', 0},
	{"iocy;", '\U00000451', 0},
	{"iogon;", '\U0000012F', 0},
	{"iopf;", '\U0001D55A', 0},
	{"iota;", '\U000003B9', 0},
	{"iprod;", '\U00002A3C', 0},
	{"iquest", '\U000000BF', 0},
	{"iquest;", '\U000000BF', 0},
	{"iscr;", '\U0001D4BE', 0},
	{"isin;", '\U00002208', 0},
	{"isinE;", '\U000022F9', 0},
	{"isindot;", '\U000022F5', 0},
	{"isins;", '\U000022F4', 0},
	{"isinsv;", '\U000022F3', 0},
	{"isinv;", '\U00002208', 0},
	{"it;", '\U00002062', 0},
	{"itilde;", '\U00000129', 0},
	{"iukcy;", '\U00000456', 0},
	{"iuml", '\U000000EF', 0},
	{"iuml;", '\U000000EF', 0},
	{"jcirc;", '\U00000135', 0},
	{"jcy;", '\U00000439', 0},
	{"jfr;", '\U0001D527', 0},
	{"jmath;", '\U00000237', 0},
	{"jopf;", '\U0001D55B', 0},
	{"jscr;", '\U0001D4BF', 0},
	{"jsercy;", '\U00000458', 0},
	{"jukcy;", '\U00000454', 0},
	{"kappa;", '\U000003BA', 0},
	{"kappav;", '\U000003F0', 0},
	{"kcedil;", '\U00000137', 0},
	{"kcy;", '\U0000043A', 0},
	{"kfr;", '\U0001D528', 0},
	{"kgreen;", '\U00000138', 0},
	{"khcy;", '\U00000445', 0},
	{"kjcy;", '\U0000045C', 0},
	{"kopf;", '\U0001D55C', 0},
	{"kscr;", '\U0001D4C0', 0},
	{"lAarr;", '\U000021DA', 0},
	{"lArr;", '\U000021D0', 0},
	{"lAtail;", '\U0000291B', 0},
	{"lBarr;", '\U0000290E', 0},
	{"lE;", '\U00002266', 0},
	{"lEg;", '\U00002A8B', 0},
	{"lHar;", '\U00002962', 0},
	{"lacute;", '\U0000013A', 0},
	{"laemptyv;", '\U000029B4', 0},
	{"lagran;", '\U00002112', 0},
	{"lambda;", '\U000003BB', 0},
	{"lang;", '\U000027E8', 0},
	{"langd;", '\U00002991', 0},
	{"langle;", '\U000027E8', 0},
	{"lap;", '\U00002A85', 0},
	{"laquo", '\U000000AB', 0},
	{"laquo;", '\U000000AB', 0},
	{"larr;", '\U00002190', 0},
	{"larrb;", '\U000021E4', 0},
	{"larrbfs;", '\U0000291F', 0},
	{"larrfs;", '\U0000291D', 0},
	{"larrhk;", '\U000021A9', 0},
	{"larrlp;", '\U000021AB', 0},
	{"larrpl;", '\U00002939', 0},
	{"larrsim;", '\U00002973', 0},
	{"larrtl;", '\U000021A2', 0},
	{"lat;", '\U00002AAB', 0},
	{"latail;", '\U00002919', 0},
	{"late;", '\U00002AAD', 0},
	{"lates;", '\u2AAD', '\uFE00'},
	{"lbarr;", '\U0000290C', 0},
	{"lbbrk;", '\U00002772', 0},
	{"lbrace;", '\U0000007B', 0},
	{"lbrack;", '\U0000005B', 0},
	{"lbrke;", '\U0000298B', 0},
	{"lbrksld;", '\U0000298F', 0},
	{"lbrkslu;", '\U0000298D', 0},
	{"lcaron;", '\U0000013E', 0},
	{"lcedil;", '\U0000013C', 0},
	{"lceil;", '\U00002308', 0},
	{"lcub;", '\U0000007B', 0},
	{"lcy;", '\U0000043B', 0},
	{"ldca;", '\U00002936', 0},
	{"ldquo;", '\U0000201C', 0},
	{"ldquor;", '\U0000201E', 0},
	{"ldrdhar;", '\U00002967', 0},
	{"ldrushar;", '\U0000294B', 0},
	{"ldsh;", '\U000021B2', 0},
	{"le;", '\U00002264', 0},
	{"leftarrow;", '\U00002190', 0},
	{"leftarrowtail;", '\U000021A2', 0},
	{"leftharpoondown;", '\U000021BD', 0},
	{"leftharpoonup;", '\U000021BC', 0},
	{"leftleftarrows;", '\U000021C7', 0},
	{"leftrightarrow;", '\U00002194', 0},
	{"leftrightarrows;", '\U000021C6', 0},
	{"leftrightharpoons;", '\U000021CB', 0},
	{"leftrightsquigarrow;", '\U000021AD', 0},
	{"leftthreetimes;", '\U000022CB', 0},
	{"leg;", '\U000022DA', 0},
	{"leq;", '\U00002264', 0},
	{"leqq;", '\U00002266', 0},
	{"leqslant;", '\U00002A7D', 0},
	{"les;", '\U00002A7D', 0},
	{"lescc;", '\U00002AA8', 0},
	{"lesdot;", '\U00002A7F', 0},
	{"lesdoto;", '\U00002A81', 0},
	{"lesdotor;", '\U00002A83', 0},
	{"lesg;", '\u22DA', '\uFE00'},
	{"lesges;", '\U00002A93', 0},
	{"lessapprox;", '\U00002A85', 0},
	{"lessdot;", '\U000022D6', 0},
	{"lesseqgtr;", '\U000022DA', 0},
	{"lesseqqgtr;", '\U00002A8B', 0},
	{"lessgtr;", '\U00002276', 0},
	{"lesssim;", '\U00002272', 0},
	{"lfisht;", '\U0000297C', 0},
	{"lfloor;", '\U0000230A', 0},
	{"lfr;", '\U0001D529', 0},
	{"lg;", '\U00002276', 0},
	{"lgE;", '\U00002A91', 0},
	{"lhard;", '\U000021BD', 0},
	{"lharu;", '\U000021BC', 0},
	{"lharul;", '\U0000296A', 0},
	{"lhblk;", '\U00002584', 0},
	{"ljcy;", '\U00000459', 0},
	{"ll;", '\U0000226A', 0},
	{"llarr;", '\U000021C7', 0},
	{"llcorner;", '\U0000231E', 0},
	{"llhard;", '\U0000296B', 0},
	{"lltri;", '\U000025FA', 0},
	{"lmidot;", '\U00000140', 0},
	{"lmoust;", '\U000023B0', 0},
	{"lmoustache;", '\U000023B0', 0},
	{"lnE;", '\U00002268', 0},
	{"lnap;", '\U00002A89', 0},
	{"lnapprox;", '\U00002A89', 0},
	{"lne;", '\U00002A87', 0},
	{"lneq;", '\U00002A87', 0},
	{"lneqq;", '\U00002268', 0},
	{"lnsim;", '\U000022E6', 0},
	{"loang;", '\U000027EC', 0},
	{"loarr;", '\U000021FD', 0},
	{"lobrk;", '\U000027E6', 0},
	{"longleftarrow;", '\U000027F5', 0},
	{"longleftrightarrow;", '\U000027F7', 0},
	{"longmapsto;", '\U000027FC', 0},
	{"longrightarrow;", '\U000027F6', 0},
	{"looparrowleft;", '\U000021AB', 0},
	{"looparrowright;", '\U000021AC', 0},
	{"lopar;", '\U00002985', 0},
	{"lopf;", '\U0001D55D', 0},
	{"loplus;", '\U00002A2D', 0},
	{"lotimes;", '\U00002A34', 0},
	{"lowast;", '\U00002217', 0},
	{"lowbar;", '\U0000005F', 0},
	{"loz;", '\U000025CA', 0},
	{"lozenge;", '\U000025CA', 0},
	{"lozf;", '\U000029EB', 0},
	{"lpar;", '\U00000028', 0},
	{"lparlt;", '\U00002993', 0},
	{"lrarr;", '\U000021C6', 0},
	{"lrcorner;", '\U0000231F', 0},
	{"lrhar;", '\U000021CB', 0},
	{"lrhard;", '\U0000296D', 0},
	{"lrm;", '\U0000200E', 0},
	{"lrtri;", '\U000022BF', 0},
	{"lsaquo;", '\U00002039', 0},
	{"lscr;", '\U0001D4C1', 0},
	{"lsh;", '\U000021B0', 0},
	{"lsim;", '\U00002272', 0},
	{"lsime;", '\U00002A8D', 0},
	{"lsimg;", '\U00002A8F', 0},
	{"lsqb;", '\U0000005B', 0},
	{"lsquo;", '\U00002018', 0},
	{"lsquor;", '\U0000201A', 0},
	{"lstrok;", '\U00000142', 0},
	{"lt", '\U0000003C', 0},
	{"lt;", '\U0000003C', 0},
	{"ltcc;", '\U00002AA6', 0},
	{"ltcir;", '\U00002A79', 0},
	{"ltdot;", '\U000022D6', 0},
	{"lthree;", '\U000022CB', 0},
	{"ltimes;", '\U000022C9', 0},
	{"ltlarr;", '\U00002976', 0},
	{"ltquest;", '\U00002A7B', 0},
	{"ltrPar;", '\U00002996', 0},
	{"ltri;", '\U000025C3', 0},
	{"ltrie;", '\U000022B4', 0},
	{"ltrif;", '\U000025C2', 0},
	{"lurdshar;", '\U0000294A', 0},
	{"luruhar;", '\U00002966', 0},
	{"lvertneqq;", '\u2268', '\uFE00'},
	{"lvnE;", '\u2268', '\uFE00'},
	{"mDDot;", '\U0000223A', 0},
	{"macr", '\U000000AF', 0},
	{"macr;", '\U000000AF', 0},
	{"male;", '\U00002642', 0},
	{"malt;", '\U00002720', 0},
	{"maltese;", '\U00002720', 0},
	{"map;", '\U000021A6', 0},
	{"mapsto;", '\U000021A6', 0},
	{"mapstodown;", '\U000021A7', 0},
	{"mapstoleft;", '\U000021A4', 0},
	{"mapstoup;", '\U000021A5', 0},
	{"marker;", '\U000025AE', 0},
	{"mcomma;", '\U00002A29', 0},
	{"mcy;", '\U0000043C', 0},
	{"mdash;", '\U00002014', 0},
	{"measuredangle;", '\U00002221', 0},
	{"mfr;", '\U0001D52A', 0},
	{"mho;", '\U00002127', 0},
	{"micro", '\U000000B5', 0},
	{"micro;", '\U000000B5', 0},
	{"mid;", '\U00002223', 0},
	{"midast;", '\U0000002A', 0},
	{"midcir;", '\U00002AF0', 0},
	{"middot", '\U000000B7', 0},
	{"middot;", '\U000000B7', 0},
	{"minus;", '\U00002212', 0},
	{"minusb;", '\U0000229F', 0},
	{"minusd;", '\U00002238', 0},
	{"minusdu;", '\U00002A2A', 0},
	{"mlcp;", '\U00002ADB', 0},
	{"mldr;", '\U00002026', 0},
	{"mnplus;", '\U00002213', 0},
	{"models;", '\U000022A7', 0},
	{"mopf;", '\U0001D55E', 0},
	{"mp;", '\U00002213', 0},
	{"mscr;", '\U0001D4C2', 0},
	{"mstpos;", '\U0000223E', 0},
	{"mu;", '\U000003BC', 0},
	{"multimap;", '\U000022B8', 0},
	{"mumap;", '\U000022B8', 0},
	{"nGg;", '\u22D9', '\u0338'},
	{"nGt;", '\u226B', '\u20D2'},
	{"nGtv;", '\u226B', '\u0338'},
	{"nLeftarrow;", '\U000021CD', 0},
	{"nLeftrightarrow;", '\U000021CE', 0},
	{"nLl;", '\u22D8', '\u0338'},
	{"nLt;", '\u226A', '\u20D2'},
	{"nLtv;", '\u226A', '\u0338'},
	{"nRightarrow;", '\U000021CF', 0},
	{"nVDash;", '\U000022AF', 0},
	{"nVdash;", '\U000022AE', 0},
	{"nabla;", '\U00002207', 0},
	{"nacute;", '\U00000144', 0},
	{"nang;", '\u2220', '\u20D2'},
	{"nap;", '\U00002249', 0},
	{"napE;", '\u2A70', '\u0338'},
	{"napid;", '\u224B', '\u0338'},
	{"napos;", '\U00000149', 0},
	{"napprox;", '\U00002249', 0},
	{"natur;", '\U0000266E', 0},
	{"natural;", '\U0000266E', 0},
	{"naturals;", '\U00002115', 0},
	{"nbsp", '\U000000A0', 0},
	{"nbsp;", '\U000000A0', 0},
	{"nbump;", '\u224E', '\u0338'},
	{"nbumpe;", '\u224F', '\u0338'},
	{"ncap;", '\U00002A43', 0},
	{"ncaron;", '\U00000148', 0},
	{"ncedil;", '\U00000146', 0},
	{"ncong;", '\U00002247', 0},
	{"ncongdot;", '\u2A6D', '\u0338'},
	{"ncup;", '\U00002A42', 0},
	{"ncy;", '\U0000043D', 0},
	{"ndash;", '\U00002013', 0},
	{"ne;", '\U00002260', 0},
	{"neArr;", '\U000021D7', 0},
	{"nearhk;", '\U00002924', 0},
	{"nearr;", '\U00002197', 0},
	{"nearrow;", '\U00002197', 0},
	{"nedot;", '\u2250', '\u0338'},
	{"nequiv;", '\U00002262', 0},
	{"nesear;", '\U00002928', 0},
	{"nesim;", '\u2242', '\u0338'},
	{"nexist;", '\U00002204', 0},
	{"nexists;", '\U00002204', 0},
	{"nfr;", '\U0001D52B', 0},
	{"ngE;", '\u2267', '\u0338'},
	{"nge;", '\U00002271', 0},
	{"ngeq;", '\U00002271', 0},
	{"ngeqq;", '\u2267', '\u0338'},
	{"ngeqslant;", '\u2A7E', '\u0338'},
	{"nges;", '\u2A7E', '\u0338'},
	{"ngsim;", '\U00002275', 0},
	{"ngt;", '\U0000226F', 0},
	{"ngtr;", '\U0000226F', 0},
	{"nhArr;", '\U000021CE', 0},
	{"nharr;", '\U000021AE', 0},
	{"nhpar;", '\U00002AF2', 0},
	{"ni;", '\U0000220B', 0},
	{"nis;", '\U000022FC', 0},
	{"nisd;", '\U000022FA', 0},
	{"niv;", '\U0000220B', 0},
	{"njcy;", '\U0000045A', 0},
	{"nlArr;", '\U000021CD', 0},
	{"nlE;", '\u2266', '\u0338'},
	{"nlarr;", '\U0000219A', 0},
	{"nldr;", '\U00002025', 0},
	{"nle;", '\U00002270', 0},
	{"nleftarrow;", '\U0000219A', 0},
	{"nleftrightarrow;", '\U000021AE', 0},
	{"nleq;", '\U00002270', 0},
	{"nleqq;", '\u2266', '\u0338'},
	{"nleqslant;", '\u2A7D', '\u0338'},
	{"nles;", '\u2A7D', '\u0338'},
	{"nless;", '\U0000226E', 0},
	{"nlsim;", '\U00002274', 0},
	{"nlt;", '\U0000226E', 0},
	{"nltri;", '\U000022EA', 0},
	{"nltrie;", '\U000022EC', 0},
	{"nmid;", '\U00002224', 0},
	{"nopf;", '\U0001D55F', 0},
	{"not", '\U000000AC', 0},
	{"not;", '\U000000AC', 0},
	{"notin;", '\U00002209', 0},
	{"notinE;", '\u22F9', '\u0338'},
	{"notindot;", '\u22F5', '\u0338'},
	{"notinva;", '\U00002209', 0},
	{"notinvb;", '\U000022F7', 0},
	{"notinvc;", '\U000022F6', 0},
	{"notni;", '\U0000220C', 0},
	{"notniva;", '\U0000220C', 0},
	{"notnivb;", '\U000022FE', 0},
	{"notnivc;", '\U000022FD', 0},
	{"npar;", '\U00002226', 0},
	{"nparallel;", '\U00002226', 0},
	{"nparsl;", '\u2AFD', '\u20E5'},
	{"npart;", '\u2202', '\u0338'},
	{"npolint;", '\U00002A14', 0},
	{"npr;", '\U00002280', 0},
	{"nprcue;", '\U000022E0', 0},
	{"npre;", '\u2AAF', '\u0338'},
	{"nprec;", '\U00002280', 0},
	{"npreceq;", '\u2AAF', '\u0338'},
	{"nrArr;", '\U000021CF', 0},
	{"nrarr;", '\U0000219B', 0},
	{"nrarrc;", '\u2933', '\u0338'},
	{"nrarrw;", '\u219D', '\u0338'},
	{"nrightarrow;", '\U0000219B', 0},
	{"nrtri;", '\U000022EB', 0},
	{"nrtrie;", '\U000022ED', 0},
	{"nsc;", '\U00002281', 0},
	{"nsccue;", '\U000022E1', 0},
	{"nsce;", '\u2AB0', '\u0338'},
	{"nscr;", '\U0001D4C3', 0},
	{"nshortmid;", '\U00002224', 0},
	{"nshortparallel;", '\U00002226', 0},
	{"nsim;", '\U00002241', 0},
	{"nsime;", '\U00002244', 0},
	{"nsimeq;", '\U00002244', 0},
	{"nsmid;", '\U00002224', 0},
	{"nspar;", '\U00002226', 0},
	{"nsqsube;", '\U000022E2', 0},
	{"nsqsupe;", '\U000022E3', 0},
	{"nsub;", '\U00002284', 0},
	{"nsubE;", '\u2AC5', '\u0338'},
	{"nsube;", '\U00002288', 0},
	{"nsubset;", '\u2282', '\u20D2'},
	{"nsubseteq;", '\U00002288', 0},
	{"nsubseteqq;", '\u2AC5', '\u0338'},
	{"nsucc;", '\U00002281', 0},
	{"nsucceq;", '\u2AB0', '\u0338'},
	{"nsup;", '\U00002285', 0},
	{"nsupE;", '\u2AC6', '\u0338'},
	{"nsupe;", '\U00002289', 0},
	{"nsupset;", '\u2283', '\u20D2'},
	{"nsupseteq;", '\U00002289', 0},
	{"nsupseteqq;", '\u2AC6', '\u0338'},
	{"ntgl;", '\U00002279', 0},
	{"ntilde", '\U000000F1', 0},
	{"ntilde;", '\U000000F1', 0},
	{"ntlg;", '\U00002278', 0},
	{"ntriangleleft;", '\U000022EA', 0},
	{"ntrianglelefteq;", '\U000022EC', 0},
	{"ntriangleright;", '\U000022EB', 0},
	{"ntrianglerighteq;", '\U000022ED', 0},
	{"nu;", '\U000003BD', 0},
	{"num;", '\U00000023', 0},
	{"numero;", '\U00002116', 0},
	{"numsp;", '\U00002007', 0},
	{"nvDash;", '\U000022AD', 0},
	{"nvHarr;", '\U00002904', 0},
	{"nvap;", '\u224D', '\u20D2'},
	{"nvdash;", '\U000022AC', 0},
	{"nvge;", '\u2265', '\u20D2'},
	{"nvgt;", '\u003E', '\u20D2'},
	{"nvinfin;", '\U000029DE', 0},
	{"nvlArr;", '\U00002902', 0},
	{"nvle;", '\u2264', '\u20D2'},
	{"nvlt;", '\u003C', '\u20D2'},
	{"nvltrie;", '\u22B4', '\u20D2'},
	{"nvrArr;", '\U00002903', 0},
	{"nvrtrie;", '\u22B5', '\u20D2'},
	{"nvsim;", '\u223C', '\u20D2'},
	{"nwArr;", '\U000021D6', 0},
	{"nwarhk;", '\U00002923', 0},
	{"nwarr;", '\U00002196', 0},
	{"nwarrow;", '\U00002196', 0},
	{"nwnear;", '\U00002927', 0},
	{"oS;", '\U000024C8', 0},
	{"oacute", '\U000000F3', 0},
	{"oacute;", '\U000000F3', 0},
	{"oast;", '\U0000229B', 0},
	{"ocir;", '\U0000229A', 0},
	{"ocirc", '\U000000F4', 0},
	{"ocirc;", '\U000000F4', 0},
	{"ocy;", '\U0000043E', 0},
	{"odash;", '\U0000229D', 0},
	{"odblac;", '\U00000151', 0},
	{"odiv;", '\U00002A38', 0},
	{"odot;", '\U00002299', 0},
	{"odsold;", '\U000029BC', 0},
	{"oelig;", '\U00000153', 0},
	{"ofcir;", '\U000029BF', 0},
	{"ofr;", '\U0001D52C', 0},
	{"ogon;", '\U000002DB', 0},
	{"ograve", '\U000000F2', 0},
	{"ograve;", '\U000000F2', 0},
	{"ogt;", '\U000029C1', 0},
	{"ohbar;", '\U000029B5', 0},
	{"ohm;", '\U000003A9', 0},
	{"oint;", '\U0000222E', 0},
	{"olarr;", '\U000021BA', 0},
	{"olcir;", '\U000029BE', 0},
	{"olcross;", '\U000029BB', 0},
	{"oline;", '\U0000203E', 0},
	{"olt;", '\U000029C0', 0},
	{"omacr;", '\U0000014D', 0},
	{"omega;", '\U000003C9', 0},
	{"omicron;", '\U000003BF', 0},
	{"omid;", '\U000029B6', 0},
	{"ominus;", '\U00002296', 0},
	{"oopf;", '\U0001D560', 0},
	{"opar;", '\U000029B7', 0},
	{"operp;", '\U000029B9', 0},
	{"oplus;", '\U00002295', 0},
	{"or;", '\U00002228', 0},
	{"orarr;", '\U000021BB', 0},
	{"ord;", '\U00002A5D', 0},
	{"order;", '\U00002134', 0},
	{"orderof;", '\U00002134', 0},
	{"ordf", '\U000000AA', 0},
	{"ordf;", '\U000000AA', 0},
	{"ordm", '\U000000BA', 0},
	{"ordm;", '\U000000BA', 0},
	{"origof;", '\U000022B6', 0},
	{"oror;", '\U00002A56', 0},
	{"orslope;", '\U00002A57', 0},
	{"orv;", '\U00002A5B', 0},
	{"oscr;", '\U00002134', 0},
	{"oslash", '\U000000F8', 0},
	{"oslash;", '\U000000F8', 0},
	{"osol;", '\U00002298', 0},
	{"otilde", '\U000000F5', 0},
	{"otilde;", '\U000000F5', 0},
	{"otimes;", '\U00002297', 0},
	{"otimesas;", '\U00002A36', 0},
	{"ouml", '\U000000F6', 0},
	{"ouml;", '\U000000F6', 0},
	{"ovbar;", '\U0000233D', 0},
	{"par;", '\U00002225', 0},
	{"para", '\U000000B6', 0},
	{"para;", '\U000000B6', 0},
	{"parallel;", '\U00002225', 0},
	{"parsim;", '\U00002AF3', 0},
	{"parsl;", '\U00002AFD', 0},
	{"part;", '\U00002202', 0},
	{"pcy;", '\U0000043F', 0},
	{"percnt;", '\U00000025', 0},
	{"period;", '\U0000002E', 0},
	{"permil;", '\U00002030', 0},
	{"perp;", '\U000022A5', 0},
	{"pertenk;", '\U00002031', 0},
	{"pfr;", '\U0001D52D', 0},
	{"phi;", '\U000003C6', 0},
	{"phiv;", '\U000003D5', 0},
	{"phmmat;", '\U00002133', 0},
	{"phone;", '\U0000260E', 0},
	{"pi;", '\U000003C0', 0},
	{"pitchfork;", '\U000022D4', 0},
	{"piv;", '\U000003D6', 0},
	{"planck;", '\U0000210F', 0},
	{"planckh;", '\U0000210E', 0},
	{"plankv;", '\U0000210F', 0},
	{"plus;", '\U0000002B', 0},
	{"plusacir;", '\U00002A23', 0},
	{"plusb;", '\U0000229E', 0},
	{"pluscir;", '\U00002A22', 0},
	{"plusdo;", '\U00002214', 0},
	{"plusdu;", '\U00002A25', 0},
	{"pluse;", '\U00002A72', 0},
	{"plusmn", '\U000000B1', 0},
	{"plusmn;", '\U000000B1', 0},
	{"plussim;", '\U00002A26', 0},
	{"plustwo;", '\U00002A27', 0},
	{"pm;", '\U000000B1', 0},
	{"pointint;", '\U00002A15', 0},
	{"popf;", '\U0001D561', 0},
	{"pound", '\U000000A3', 0},
	{"pound;", '\U000000A3', 0},
	{"pr;", '\U0000227A', 0},
	{"prE;", '\U00002AB3', 0},
	{"prap;", '\U00002AB7', 0},
	{"prcue;", '\U0000227C', 0},
	{"pre;", '\U00002AAF', 0},
	{"prec;", '\U0000227A', 0},
	{"precapprox;", '\U00002AB7', 0},
	{"preccurlyeq;", '\U0000227C', 0},
	{"preceq;", '\U00002AAF', 0},
	{"precnapprox;", '\U00002AB9', 0},
	{"precneqq;", '\U00002AB5', 0},
	{"precnsim;", '\U000022E8', 0},
	{"precsim;", '\U0000227E', 0},
	{"prime;", '\U00002032', 0},
	{"primes;", '\U00002119', 0},
	{"prnE;", '\U00002AB5', 0},
	{"prnap;", '\U00002AB9', 0},
	{"prnsim;", '\U000022E8', 0},
	{"prod;", '\U0000220F', 0},
	{"profalar;", '\U0000232E', 0},
	{"profline;", '\U00002312', 0},
	{"profsurf;", '\U00002313', 0},
	{"prop;", '\U0000221D', 0},
	{"propto;", '\U0000221D', 0},
	{"prsim;", '\U0000227E', 0},
	{"prurel;", '\U000022B0', 0},
	{"pscr;", '\U0001D4C5', 0},
	{"psi;", '\U000003C8', 0},
	{"puncsp;", '\U00002008', 0},
	{"qfr;", '\U0001D52E', 0},
	{"qint;", '\U00002A0C', 0},
	{"qopf;", '\U0001D562', 0},
	{"qprime;", '\U00002057', 0},
	{"qscr;", '\U0001D4C6', 0},
	{"quaternions;", '\U0000210D', 0},
	{"quatint;", '\U00002A16', 0},
	{"quest;", '\U0000003F', 0},
	{"questeq;", '\U0000225F', 0},
	{"quot", '\U00000022', 0},
	{"quot;", '\U00000022', 0},
	{"rAarr;", '\U000021DB', 0},
	{"rArr;", '\U000021D2', 0},
	{"rAtail;", '\U0000291C', 0},
	{"rBarr;", '\U0000290F', 0},
	{"rHar;", '\U00002964', 0},
	{"race;", '\u223D', '\u0331'},
	{"racute;", '\U00000155', 0},
	{"radic;", '\U0000221A', 0},
	{"raemptyv;", '\U000029B3', 0},
	{"rang;", '\U000027E9', 0},
	{"rangd;", '\U00002992', 0},
	{"range;", '\U000029A5', 0},
	{"rangle;", '\U000027E9', 0},
	{"raquo", '\U000000BB', 0},
	{"raquo;", '\U000000BB', 0},
	{"rarr;", '\U00002192', 0},
	{"rarrap;", '\U00002975', 0},
	{"rarrb;", '\U000021E5', 0},
	{"rarrbfs;", '\U00002920', 0},
	{"rarrc;", '\U00002933', 0},
	{"rarrfs;", '\U0000291E', 0},
	{"rarrhk;", '\U000021AA', 0},
	{"rarrlp;", '\U000021AC', 0},
	{"rarrpl;", '\U00002945', 0},
	{"rarrsim;", '\U00002974', 0},
	{"rarrtl;", '\U000021A3', 0},
	{"rarrw;", '\U0000219D', 0},
	{"ratail;", '\U0000291A', 0},
	{"ratio;", '\U00002236', 0},
	{"rationals;", '\U0000211A', 0},
	{"rbarr;", '\U0000290D', 0},
	{"rbbrk;", '\U00002773', 0},
	{"rbrace;", '\U0000007D', 0},
	{"rbrack;", '\U0000005D', 0},
	{"rbrke;", '\U0000298C', 0},
	{"rbrksld;", '\U0000298E', 0},
	{"rbrkslu;", '\U00002990', 0},
	{"rcaron;", '\U00000159', 0},
	{"rcedil;", '\U00000157', 0},
	{"rceil;", '\U00002309', 0},
	{"rcub;", '\U0000007D', 0},
	{"rcy;", '\U00000440', 0},
	{"rdca;", '\U00002937', 0},
	{"rdldhar;", '\U00002969', 0},
	{"rdquo;", '\U0000201D', 0},
	{"rdquor;", '\U0000201D', 0},
	{"rdsh;", '\U000021B3', 0},
	{"real;", '\U0000211C', 0},
	{"realine;", '\U0000211B', 0},
	{"realpart;", '\U0000211C', 0},
	{"reals;", '\U0000211D', 0},
	{"rect;", '\U000025AD', 0},
	{"reg", '\U000000AE', 0},
	{"reg;", '\U000000AE', 0},
	{"rfisht;", '\U0000297D', 0},
	{"rfloor;", '\U0000230B', 0},
	{"rfr;", '\U0001D52F', 0},
	{"rhard;", '\U000021C1', 0},
	{"rharu;", '\U000021C0', 0},
	{"rharul;", '\U0000296C', 0},
	{"rho;", '\U000003C1', 0},
	{"rhov;", '\U000003F1', 0},
	{"rightarrow;", '\U00002192', 0},
	{"rightarrowtail;", '\U000021A3', 0},
	{"rightharpoondown;", '\U000021C1', 0},
	{"rightharpoonup;", '\U000021C0', 0},
	{"rightleftarrows;", '\U000021C4', 0},
	{"rightleftharpoons;", '\U000021CC', 0},
	{"rightrightarrows;", '\U000021C9', 0},
	{"rightsquigarrow;", '\U0000219D', 0},
	{"rightthreetimes;", '\U000022CC', 0},
	{"ring;", '\U000002DA', 0},
	{"risingdotseq;", '\U00002253', 0},
	{"rlarr;", '\U000021C4', 0},
	{"rlhar;", '\U000021CC', 0},
	{"rlm;", '\U0000200F', 0},
	{"rmoust;", '\U000023B1', 0},
	{"rmoustache;", '\U000023B1', 0},
	{"rnmid;", '\U00002AEE', 0},
	{"roang;", '\U000027ED', 0},
	{"roarr;", '\U000021FE', 0},
	{"robrk;", '\U000027E7', 0},
	{"ropar;", '\U00002986', 0},
	{"ropf;", '\U0001D563', 0},
	{"roplus;", '\U00002A2E', 0},
	{"rotimes;", '\U00002A35', 0},
	{"rpar;", '\U00000029', 0},
	{"rpargt;", '\U00002994', 0},
	{"rppolint;", '\U00002A12', 0},
	{"rrarr;", '\U000021C9', 0},
	{"rsaquo;", '\U0000203A', 0},
	{"rscr;", '\U0001D4C7', 0},
	{"rsh;", '\U000021B1', 0},
	{"rsqb;", '\U0000005D', 0},
	{"rsquo;", '\U00002019', 0},
	{"rsquor;", '\U00002019', 0},
	{"rthree;", '\U000022CC', 0},
	{"rtimes;", '\U000022CA', 0},
	{"rtri;", '\U000025B9', 0},
	{"rtrie;", '\U000022B5', 0},
	{"rtrif;", '\U000025B8', 0},
	{"rtriltri;", '\U000029CE', 0},
	{"ruluhar;", '\U00002968', 0},
	{"rx;", '\U0000211E', 0},
	{"sacute;", '\U0000015B', 0},
	{"sbquo;", '\U0000201A', 0},
	{"sc;", '\U0000227B', 0},
	{"scE;", '\U00002AB4', 0},
	{"scap;", '\U00002AB8', 0},
	{"scaron;", '\U00000161', 0},
	{"sccue;", '\U0000227D', 0},
	{"sce;", '\U00002AB0', 0},
	{"scedil;", '\U0000015F', 0},
	{"scirc;", '\U0000015D', 0},
	{"scnE;", '\U00002AB6', 0},
	{"scnap;", '\U00002ABA', 0},
	{"scnsim;", '\U000022E9', 0},
	{"scpolint;", '\U00002A13', 0},
	{"scsim;", '\U0000227F', 0},
	{"scy;", '\U00000441', 0},
	{"sdot;", '\U000022C5', 0},
	{"sdotb;", '\U000022A1', 0},
	{"sdote;", '\U00002A66', 0},
	{"seArr;", '\U000021D8', 0},
	{"searhk;", '\U00002925', 0},
	{"searr;", '\U00002198', 0},
	{"searrow;", '\U00002198', 0},
	{"sect", '\U000000A7', 0},
	{"sect;", '\U000000A7', 0},
	{"semi;", '\U0000003B', 0},
	{"seswar;", '\U00002929', 0},
	{"setminus;", '\U00002216', 0},
	{"setmn;", '\U00002216', 0},
	{"sext;", '\U00002736', 0},
	{"sfr;", '\U0001D530', 0},
	{"sfrown;", '\U00002322', 0},
	{"sharp;", '\U0000266F', 0},
	{"shchcy;", '\U00000449', 0},
	{"shcy;", '\U00000448', 0},
	{"shortmid;", '\U00002223', 0},
	{"shortparallel;", '\U00002225', 0},
	{"shy", '\U000000AD', 0},
	{"shy;", '\U000000AD', 0},
	{"sigma;", '\U000003C3', 0},
	{"sigmaf;", '\U000003C2', 0},
	{"sigmav;", '\U000003C2', 0},
	{"sim;", '\U0000223C', 0},
	{"simdot;", '\U00002A6A', 0},
	{"sime;", '\U00002243', 0},
	{"simeq;", '\U00002243', 0},
	{"simg;", '\U00002A9E', 0},
	{"simgE;", '\U00002AA0', 0},
	{"siml;", '\U00002A9D', 0},
	{"simlE;", '\U00002A9F', 0},
	{"simne;", '\U00002246', 0},
	{"simplus;", '\U00002A24', 0},
	{"simrarr;", '\U00002972', 0},
	{"slarr;", '\U00002190', 0},
	{"smallsetminus;", '\U00002216', 0},
	{"smashp;", '\U00002A33', 0},
	{"smeparsl;", '\U000029E4', 0},
	{"smid;", '\U00002223', 0},
	{"smile;", '\U00002323', 0},
	{"smt;", '\U00002AAA', 0},
	{"smte;", '\U00002AAC', 0},
	{"smtes;", '\u2AAC', '\uFE00'},
	{"softcy;", '\U0000044C', 0},
	{"sol;", '\U0000002F', 0},
	{"solb;", '\U000029C4', 0},
	{"solbar;", '\U0000233F', 0},
	{"sopf;", '\U0001D564', 0},
	{"spades;", '\U00002660', 0},
	{"spadesuit;", '\U00002660', 0},
	{"spar;", '\U00002225', 0},
	{"sqcap;", '\U00002293', 0},
	{"sqcaps;", '\u2293', '\uFE00'},
	{"sqcup;", '\U00002294', 0},
	{"sqcups;", '\u2294', '\uFE00'},
	{"sqsub;", '\U0000228F', 0},
	{"sqsube;", '\U00002291', 0},
	{"sqsubset;", '\U0000228F', 0},
	{"sqsubseteq;", '\U00002291', 0},
	{"sqsup;", '\U00002290', 0},
	{"sqsupe;", '\U00002292', 0},
	{"sqsupset;", '\U00002290', 0},
	{"sqsupseteq;", '\U00002292', 0},
	{"squ;", '\U000025A1', 0},
	{"square;", '\U000025A1', 0},
	{"squarf;", '\U000025AA', 0},
	{"squf;", '\U000025AA', 0},
	{"srarr;", '\U00002192', 0},
	{"sscr;", '\U0001D4C8', 0},
	{"ssetmn;", '\U00002216', 0},
	{"ssmile;", '\U00002323', 0},
	{"sstarf;", '\U000022C6', 0},
	{"star;", '\U00002606', 0},
	{"starf;", '\U00002605', 0},
	{"straightepsilon;", '\U000003F5', 0},
	{"straightphi;", '\U000003D5', 0},
	{"strns;", '\U000000AF', 0},
	{"sub;", '\U00002282', 0},
	{"subE;", '\U00002AC5', 0},
	{"subdot;", '\U00002ABD', 0},
	{"sube;", '\U00002286', 0},
	{"subedot;", '\U00002AC3', 0},
	{"submult;", '\U00002AC1', 0},
	{"subnE;", '\U00002ACB', 0},
	{"subne;", '\U0000228A', 0},
	{"subplus;", '\U00002ABF', 0},
	{"subrarr;", '\U00002979', 0},
	{"subset;", '\U00002282', 0},
	{"subseteq;", '\U00002286', 0},
	{"subseteqq;", '\U00002AC5', 0},
	{"subsetneq;", '\U0000228A', 0},
	{"subsetneqq;", '\U00002ACB', 0},
	{"subsim;", '\U00002AC7', 0},
	{"subsub;", '\U00002AD5', 0},
	{"subsup;", '\U00002AD3', 0},
	{"succ;", '\U0000227B', 0},
	{"succapprox;", '\U00002AB8', 0},
	{"succcurlyeq;", '\U0000227D', 0},
	{"succeq;", '\U00002AB0', 0},
	{"succnapprox;", '\U00002ABA', 0},
	{"succneqq;", '\U00002AB6', 0},
	{"succnsim;", '\U000022E9', 0},
	{"succsim;", '\U0000227F', 0},
	{"sum;", '\U00002211', 0},
	{"sung;", '\U0000266A', 0},
	{"sup1", '\U000000B9', 0},
	{"sup1;", '\U000000B9', 0},
	{"sup2", '\U000000B2', 0},
	{"sup2;", '\U000000B2', 0},
	{"sup3", '\U000000B3', 0},
	{"sup3;", '\U000000B3', 0},
	{"sup;", '\U00002283', 0},
	{"supE;", '\U00002AC6', 0},
	{"supdot;", '\U00002ABE', 0},
	{"supdsub;", '\U00002AD8', 0},
	{"supe;", '\U00002287', 0},
	{"supedot;", '\U00002AC4', 0},
	{"suphsol;", '\U000027C9', 0},
	{"suphsub;", '\U00002AD7', 0},
	{"suplarr;", '\U0000297B', 0},
	{"supmult;", '\U00002AC2', 0},
	{"supnE;", '\U00002ACC', 0},
	{"supne;", '\U0000228B', 0},
	{"supplus;", '\U00002AC0', 0},
	{"supset;", '\U00002283', 0},
	{"supseteq;", '\U00002287', 0},
	{"supseteqq;", '\U00002AC6', 0},
	{"supsetneq;", '\U0000228B', 0},
	{"supsetneqq;", '\U00002ACC', 0},
	{"supsim;", '\U00002AC8', 0},
	{"supsub;", '\U00002AD4', 0},
	{"supsup;", '\U00002AD6', 0},
	{"swArr;", '\U000021D9', 0},
	{"swarhk;", '\U00002926', 0},
	{"swarr;", '\U00002199', 0},
	{"swarrow;", '\U00002199', 0},
	{"swnwar;", '\U0000292A', 0},
	{"szlig", '\U000000DF', 0},
	{"szlig;", '\U000000DF', 0},
	{"target;", '\U00002316', 0},
	{"tau;", '\U000003C4', 0},
	{"tbrk;", '\U000023B4', 0},
	{"tcaron;", '\U00000165', 0},
	{"tcedil;", '\U00000163', 0},
	{"tcy;", '\U00000442', 0},
	{"tdot;", '\U000020DB', 0},
	{"telrec;", '\U00002315', 0},
	{"tfr;", '\U0001D531', 0},
	{"there4;", '\U00002234', 0},
	{"therefore;", '\U00002234', 0},
	{"theta;", '\U000003B8', 0},
	{"thetasym;", '\U000003D1', 0},
	{"thetav;", '\U000003D1', 0},
	{"thickapprox;", '\U00002248', 0},
	{"thicksim;", '\U0000223C', 0},
	{"thinsp;", '\U00002009', 0},
	{"thkap;", '\U00002248', 0},
	{"thksim;", '\U0000223C', 0},
	{"thorn", '\U000000FE', 0},
	{"thorn;", '\U000000FE', 0},
	{"tilde;", '\U000002DC', 0},
	{"times", '\U000000D7', 0},
	{"times;", '\U000000D7', 0},
	{"timesb;", '\U000022A0', 0},
	{"timesbar;", '\U00002A31', 0},
	{"timesd;", '\U00002A30', 0},
	{"tint;", '\U0000222D', 0},
	{"toea;", '\U00002928', 0},
	{"top;", '\U000022A4', 0},
	{"topbot;", '\U00002336', 0},
	{"topcir;", '\U00002AF1', 0},
	{"topf;", '\U0001D565', 0},
	{"topfork;", '\U00002ADA', 0},
	{"tosa;", '\U00002929', 0},
	{"tprime;", '\U00002034', 0},
	{"trade;", '\U00002122', 0},
	{"triangle;", '\U000025B5', 0},
	{"triangledown;", '\U000025BF', 0},
	{"triangleleft;", '\U000025C3', 0},
	{"trianglelefteq;", '\U000022B4', 0},
	{"triangleq;", '\U0000225C', 0},
	{"triangleright;", '\U000025B9', 0},
	{"trianglerighteq;", '\U000022B5', 0},
	{"tridot;", '\U000025EC', 0},
	{"trie;", '\U0000225C', 0},
	{"triminus;", '\U00002A3A', 0},
	{"triplus;", '\U00002A39', 0},
	{"trisb;", '\U000029CD', 0},
	{"tritime;", '\U00002A3B', 0},
	{"trpezium;", '\U000023E2', 0},
	{"tscr;", '\U0001D4C9', 0},
	{"tscy;", '\U00000446', 0},
	{"tshcy;", '\U0000045B', 0},
	{"tstrok;", '\U00000167', 0},
	{"twixt;", '\U0000226C', 0},
	{"twoheadleftarrow;", '\U0000219E', 0},
	{"twoheadrightarrow;", '\U000021A0', 0},
	{"uArr;", '\U000021D1', 0},
	{"uHar;", '\U00002963', 0},
	{"uacute", '\U000000FA', 0},
	{"uacute;", '\U000000FA', 0},
	{"uarr;", '\U00002191', 0},
	{"ubrcy;", '\U0000045E', 0},
	{"ubreve;", '\U0000016D', 0},
	{"ucirc", '\U000000FB', 0},
	{"ucirc;", '\U000000FB', 0},
	{"ucy;", '\U00000443', 0},
	{"udarr;", '\U000021C5', 0},
	{"udblac;", '\U00000171', 0},
	{"udhar;", '\U0000296E', 0},
	{"ufisht;", '\U0000297E', 0},
	{"ufr;", '\U0001D532', 0},
	{"ugrave", '\U000000F9', 0},
	{"ugrave;", '\U000000F9', 0},
	{"uharl;", '\U000021BF', 0},
	{"uharr;", '\U000021BE', 0},
	{"uhblk;", '\U00002580', 0},
	{"ulcorn;", '\U0000231C', 0},
	{"ulcorner;", '\U0000231C', 0},
	{"ulcrop;", '\U0000230F', 0},
	{"ultri;", '\U000025F8', 0},
	{"umacr;", '\U0000016B', 0},
	{"uml", '\U000000A8', 0},
	{"uml;", '\U000000A8', 0},
	{"uogon;", '\U00000173', 0},
	{"uopf;", '\U0001D566', 0},
	{"uparrow;", '\U00002191', 0},
	{"updownarrow;", '\U00002195', 0},
	{"upharpoonleft;", '\U000021BF', 0},
	{"upharpoonright;", '\U000021BE', 0},
	{"uplus;", '\U0000228E', 0},
	{"upsi;", '\U000003C5', 0},
	{"upsih;", '\U000003D2', 0},
	{"upsilon;", '\U000003C5', 0},
	{"upuparrows;", '\U000021C8', 0},
	{"urcorn;", '\U0000231D', 0},
	{"urcorner;", '\U0000231D', 0},
	{"urcrop;", '\U0000230E', 0},
	{"uring;", '\U0000016F', 0},
	{"urtri;", '\U000025F9', 0},
	{"uscr;", '\U0001D4CA', 0},
	{"utdot;", '\U000022F0', 0},
	{"utilde;", '\U00000169', 0},
	{"utri;", '\U000025B5', 0},
	{"utrif;", '\U000025B4', 0},
	{"uuarr;", '\U000021C8', 0},
	{"uuml", '\U000000FC', 0},
	{"uuml;", '\U000000FC', 0},
	{"uwangle;", '\U000029A7', 0},
	{"vArr;", '\U000021D5', 0},
	{"vBar;", '\U00002AE8', 0},
	{"vBarv;", '\U00002AE9', 0},
	{"vDash;", '\U000022A8', 0},
	{"vangrt;", '\U0000299C', 0},
	{"varepsilon;", '\U000003F5', 0},
	{"varkappa;", '\U000003F0', 0},
	{"varnothing;", '\U00002205', 0},
	{"varphi;", '\U000003D5', 0},
	{"varpi;", '\U000003D6', 0},
	{"varpropto;", '\U0000221D', 0},
	{"varr;", '\U00002195', 0},
	{"varrho;", '\U000003F1', 0},
	{"varsigma;", '\U000003C2', 0},
	{"varsubsetneq;", '\u228A', '\uFE00'},
	{"varsubsetneqq;", '\u2ACB', '\uFE00'},
	{"varsupsetneq;", '\u228B', '\uFE00'},
	{"varsupsetneqq;", '\u2ACC', '\uFE00'},
	{"vartheta;", '\U000003D1', 0},
	{"vartriangleleft;", '\U000022B2', 0},
	{"vartriangleright;", '\U000022B3', 0},
	{"vcy;", '\U00000432', 0},
	{"vdash;", '\U000022A2', 0},
	{"vee;", '\U00002228', 0},
	{"veebar;", '\U000022BB', 0},
	{"veeeq;", '\U0000225A', 0},
	{"vellip;", '\U000022EE', 0},
	{"verbar;", '\U0000007C', 0},
	{"vert;", '\U0000007C', 0},
	{"vfr;", '\U0001D533', 0},
	{"vltri;", '\U000022B2', 0},
	{"vnsub;", '\u2282', '\u20D2'},
	{"vnsup;", '\u2283', '\u20D2'},
	{"vopf;", '\U0001D567', 0},
	{"vprop;", '\U0000221D', 0},
	{"vrtri;", '\U000022B3', 0},
	{"vscr;", '\U0001D4CB', 0},
	{"vsubnE;", '\u2ACB', '\uFE00'},
	{"vsubne;", '\u228A', '\uFE00'},
	{"vsupnE;", '\u2ACC', '\uFE00'},
	{"vsupne;", '\u228B', '\uFE00'},
	{"vzigzag;", '\U0000299A', 0},
	{"wcirc;", '\U00000175', 0},
	{"wedbar;", '\U00002A5F', 0},
	{"wedge;", '\U00002227', 0},
	{"wedgeq;", '\U00002259', 0},
	{"weierp;", '\U00002118', 0},
	{"wfr;", '\U0001D534', 0},
	{"wopf;", '\U0001D568', 0},
	{"wp;", '\U00002118', 0},
	{"wr;", '\U00002240', 0},
	{"wreath;", '\U00002240', 0},
	{"wscr;", '\U0001D4CC', 0},
	{"xcap;", '\U000022C2', 0},
	{"xcirc;", '\U000025EF', 0},
	{"xcup;", '\U000022C3', 0},
	{"xdtri;", '\U000025BD', 0},
	{"xfr;", '\U0001D535', 0},
	{"xhArr;", '\U000027FA', 0},
	{"xharr;", '\U000027F7', 0},
	{"xi;", '\U000003BE', 0},
	{"xlArr;", '\U000027F8', 0},
	{"xlarr;", '\U000027F5', 0},
	{"xmap;", '\U000027FC', 0},
	{"xnis;", '\U000022FB', 0},
	{"xodot;", '\U00002A00', 0},
	{"xopf;", '\U0001D569', 0},
	{"xoplus;", '\U00002A01', 0},
	{"xotime;", '\U00002A02', 0},
	{"xrArr;", '\U000027F9', 0},
	{"xrarr;", '\U000027F6', 0},
	{"xscr;", '\U0001D4CD', 0},
	{"xsqcup;", '\U00002A06', 0},
	{"xuplus;", '\U00002A04', 0},
	{"xutri;", '\U000025B3', 0},
	{"xvee;", '\U000022C1', 0},
	{"xwedge;", '\U000022C0', 0},
	{"yacute", '\U000000FD', 0},
	{"yacute;", '\U000000FD', 0},
	{"yacy;", '\U0000044F', 0},
	{"ycirc;", '\U00000177', 0},
	{"ycy;", '\U0000044B', 0},
	{"yen", '\U000000A5', 0},
	{"yen;", '\U000000A5', 0},
	{"yfr;", '\U0001D536', 0},
	{"yicy;", '\U00000457', 0},
	{"yopf;", '\U0001D56A', 0},
	{"yscr;", '\U0001D4CE', 0},
	{"yucy;", '\U0000044E', 0},
	{"yuml", '\U000000FF', 0},
	{"yuml;", '\U000000FF', 0},
	{"zacute;", '\U0000017A', 0},
	{"zcaron;", '\U0000017E', 0},
	{"zcy;", '\U00000437', 0},
	{"zdot;", '\U0000017C', 0},
	{"zeetrf;", '\U00002128', 0},
	{"zeta;", '\U000003B6', 0},
	{"zfr;", '\U0001D537', 0},
	{"zhcy;", '\U00000436', 0},
	{"zigrarr;", '\U000021DD', 0},
	{"zopf;", '\U0001D56B', 0},
	{"zscr;", '\U0001D4CF', 0},
	{"zwj;", '\U0000200D', 0},
	{"zwnj;", '\U0000200C', 0},
}
