/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.BlobWithIO;
import java.io.IOException;
import java.io.OutputStream;

class BlobOutputStream
extends OutputStream {
    private BlobWithIO blob;

    BlobOutputStream(BlobWithIO blobWithIO) {
        this.blob = blobWithIO;
    }

    public void write(int n) throws IOException {
        if (n < 0 || n > 255) {
            throw new IOException("not a byte");
        }
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.write(byArray);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.blob == null) {
            throw new IOException("OutputStream is closed");
        }
        if (n < 0 || n >= byArray.length || n2 <= 0 || n + n2 > byArray.length) {
            throw new IOException("invalid offset/length");
        }
        try {
            this.blob.append(byArray, n, n2);
        }
        catch (Exception exception) {
            throw new IOException("I/O error on Blob write(): " + exception);
        }
    }

    public void flush() throws IOException {
        if (this.blob == null) {
            throw new IOException("OutputStream is closed");
        }
    }

    public void close() {
        this.blob = null;
    }
}

