/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.ClobWithIO;
import java.io.IOException;
import java.io.Writer;

class ClobWriter
extends Writer {
    private ClobWithIO clob;

    ClobWriter(ClobWithIO clobWithIO) {
        this.clob = clobWithIO;
    }

    public void write(int n) throws IOException {
        if (n < 0 || n > 255) {
            throw new IOException("not a char");
        }
        char[] cArray = new char[]{(char)(n & 0xFF)};
        this.write(cArray);
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.clob == null) {
            throw new IOException("Writer is closed");
        }
        if (n < 0 || n >= cArray.length || n2 <= 0 || n + n2 > cArray.length) {
            throw new IOException("invalid offset/length");
        }
        try {
            this.clob.append(cArray, n, n2);
        }
        catch (Exception exception) {
            throw new IOException("I/O error on Clob write(): " + exception);
        }
    }

    public void flush() throws IOException {
        if (this.clob == null) {
            throw new IOException("Writer is closed");
        }
    }

    public void close() throws IOException {
        this.clob = null;
    }
}

