/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app.classloader;

import COM.ibm.db2.app.classloader.ClassLoaderResource;
import COM.ibm.db2.app.classloader.ClassProvider;
import COM.ibm.db2.app.classloader.JarResource;
import COM.ibm.db2.app.util.InvalidationException;
import COM.ibm.db2.app.util.Validatable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarFileClassProvider
implements ClassProvider,
Validatable {
    File jarFile;
    long timeStamp;
    private static char jarSeparatorChar = (char)47;

    public JarFileClassProvider(File file) {
        if (!file.isFile()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is not a valid jar file");
        }
        this.jarFile = file;
        this.timeStamp = this.jarFile.lastModified();
    }

    public String getClassPath() {
        return this.jarFile.getAbsolutePath();
    }

    public byte[] getClassBytes(String string) {
        byte[] byArray = null;
        try {
            ZipEntry zipEntry;
            JarFile jarFile = new JarFile(this.jarFile);
            string = string.replace('.', jarSeparatorChar) + ".class";
            if (string.startsWith("/")) {
                string = string.substring(1, string.length());
            }
            if ((zipEntry = jarFile.getEntry(string)) == null) {
                jarFile.close();
                return null;
            }
            int n = (int)zipEntry.getSize();
            int n2 = 0;
            int n3 = 0;
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            if (n > -1) {
                byArray = new byte[n];
                while (n - n2 > 0) {
                    n3 = inputStream.read(byArray, n2, n - n2);
                    if (n3 == -1) break;
                    n2 += n3;
                }
                if (n != n2) {
                    byArray = null;
                    throw new IOException("unexpected EOF reading class: " + string);
                }
            } else {
                int n4 = 1024;
                byte[] byArray2 = new byte[n4];
                do {
                    if ((n3 = inputStream.read(byArray2, n2, n4 - n2)) == n4 - n2) {
                        byte[] byArray3 = new byte[n4 * 2];
                        System.arraycopy(byArray2, 0, byArray3, 0, n4);
                        byArray2 = byArray3;
                        byArray3 = null;
                        n4 += n4;
                    }
                    if (n3 <= 0) continue;
                    n2 += n3;
                } while (n3 != -1);
                byArray = new byte[n2];
                System.arraycopy(byArray2, 0, byArray, 0, n2);
                byArray2 = null;
            }
            jarFile.close();
        }
        catch (Exception exception) {
            byArray = null;
        }
        return byArray;
    }

    public ClassLoaderResource getResource(String string) {
        try {
            if (this.hasResource(string)) {
                return new JarResource(this.jarFile, string);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getAbsoluteResourcePath(String string) {
        if (this.hasResource(string)) {
            return this.jarFile.getAbsolutePath();
        }
        return null;
    }

    public boolean hasResource(String string) {
        boolean bl = false;
        if (string.startsWith("/")) {
            string = string.substring(1, string.length());
        }
        try {
            JarFile jarFile = new JarFile(this.jarFile);
            ZipEntry zipEntry = jarFile.getEntry(string);
            if (zipEntry != null) {
                bl = true;
            }
            jarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public String toString() {
        return this.getClass().getName() + " " + this.jarFile.getAbsolutePath();
    }

    public void validate() throws InvalidationException {
        if (!this.jarFile.exists()) {
            throw new InvalidationException("JarFileClassProvider is invalid", this.jarFile.getAbsolutePath() + " has been deleted");
        }
        if (this.timeStamp != this.jarFile.lastModified()) {
            throw new InvalidationException("JarFileClassProvider is invalid", this.jarFile.getAbsolutePath() + " has been updated");
        }
    }

    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (InvalidationException invalidationException) {
            return false;
        }
    }
}

