/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2ReusableConnection;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import com.ibm.db2.jcc.SQLJConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class DB2PooledConnection
implements PooledConnection {
    protected Vector listeners = null;
    protected int hdbc = 0;
    protected boolean fConnected = false;
    protected DB2ReusableConnection conApp = null;
    protected COM.ibm.db2.jdbc.net.DB2ReusableConnection conNet = null;
    protected ResourceBundle errMsgClass = null;
    protected Object sqlExcptGen;
    protected int sqlSuccess = 0;
    private String databaseName;
    private String serverName;
    private int portNumber;
    Properties info;
    private boolean fXAConnection = false;
    private int id;

    DB2PooledConnection() throws SQLException {
    }

    public DB2PooledConnection(String string, Properties properties) throws SQLException {
        this.initialize(string, properties);
    }

    public DB2PooledConnection(String string, String string2, int n, Properties properties, boolean bl) throws SQLException {
        this.initialize(string, string2, n, properties, bl);
    }

    public void initialize(String string, Properties properties) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "initialize( " + string + ", info )");
        }
        this.setup();
        this.databaseName = string;
        this.info = properties;
        this.sqlExcptGen = new COM.ibm.db2.jdbc.app.SQLExceptionGenerator(this.errMsgClass);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "initialize()");
        }
    }

    public void initialize(String string, String string2, int n, Properties properties, boolean bl) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "initialize( " + string + ", " + string2 + ", " + n + ", " + "info, " + bl + " )");
        }
        this.setup();
        this.databaseName = string;
        this.serverName = string2;
        this.portNumber = n;
        this.info = properties;
        this.fXAConnection = bl;
        this.sqlExcptGen = new SQLExceptionGenerator(this.errMsgClass);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "initialize()");
        }
    }

    public void setup() {
        this.listeners = new Vector();
        this.errMsgClass = ResourceBundle.getBundle("COM.ibm.db2.mri.DB2ErrorMessages");
    }

    public void setID(int n) {
        this.id = n;
    }

    public int getID() {
        return this.id;
    }

    public Connection getConnection() throws SQLException {
        SQLJConnection sQLJConnection;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getConnection()");
            DB2Trace.data(10, "hdbc = " + this.hdbc + "; fConnected = " + this.fConnected);
        }
        if (null == this.serverName || this.portNumber <= 0) {
            this.conApp = new DB2ReusableConnection(this.databaseName, this.info, this.hdbc, this, this.fConnected);
            if (this.hdbc == 0) {
                this.hdbc = this.conApp.getHandle();
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "hdbc", this.hdbc);
                }
            }
            sQLJConnection = this.conApp;
            this.fConnected = true;
        } else {
            this.conNet = new COM.ibm.db2.jdbc.net.DB2ReusableConnection(this.serverName, this.portNumber, this.databaseName, this.info, this.hdbc, this, this.fConnected);
            if (this.hdbc == 0) {
                this.hdbc = this.conNet.getHandle();
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(30, "hdbc", this.hdbc);
                }
            }
            sQLJConnection = this.conNet;
            this.fConnected = true;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "getConnection()");
        }
        return sQLJConnection;
    }

    public void close() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "close()");
            DB2Trace.data(10, "hdbc", this.hdbc);
        }
        if (null == this.serverName || this.portNumber <= 0) {
            if (this.conApp != null) {
                this.conApp.realClose();
            }
        } else if (this.conNet != null) {
            this.conNet.realClose();
        }
        this.fConnected = false;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "close()");
        }
    }

    public void backToPool() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "backToPool()");
            DB2Trace.data(10, "hdbc", this.hdbc);
        }
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            connectionEventListener.connectionClosed(connectionEvent);
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "backToPool()");
        }
    }

    public void exceptionThrown(SQLException sQLException) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "exceptionThrown()");
            DB2Trace.data(10, "ex.getMessage()", sQLException.getMessage());
        }
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
            connectionEventListener.connectionErrorOccurred(connectionEvent);
            this.printToLog("connectionErrorOccured event sent to listener: " + connectionEventListener);
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "exceptionThrown()");
        }
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.addElement(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.removeElement(connectionEventListener);
    }

    void printToLog(String string) {
    }
}

