/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc;

import javax.transaction.xa.Xid;

public class DB2Xid
implements Xid {
    private int formatID;
    private int gtrid_length;
    private int bqual_length;
    private byte[] data;
    private static final int XidDATASIZE = 128;
    public static final int MAXGTRIDSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    private static final String hextab = "0123456789ABCDEF";

    public DB2Xid() {
        this.data = new byte[128];
        this.formatID = -1;
    }

    public DB2Xid(int n, byte[] byArray, byte[] byArray2) {
        this.formatID = n;
        this.gtrid_length = byArray.length;
        this.bqual_length = byArray2.length;
        this.data = new byte[128];
        System.arraycopy(byArray, 0, this.data, 0, this.gtrid_length);
        System.arraycopy(byArray2, 0, this.data, this.gtrid_length, this.bqual_length);
    }

    public int hashCode() {
        if (this.formatID == -1) {
            return -1;
        }
        return this.formatID + this.gtrid_length - this.bqual_length;
    }

    public String toString() {
        int n = this.gtrid_length + this.bqual_length;
        StringBuffer stringBuffer = new StringBuffer(n + n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.data[n2] & 0xFF;
            stringBuffer.append(hextab.charAt(n3 / 16));
            stringBuffer.append(hextab.charAt(n3 & 0xF));
            if ((n2 + 1) % 4 == 0 && n2 + 1 < n) {
                stringBuffer.append(" ");
            }
            ++n2;
        }
        String string = new String("{Xid: formatID(" + this.formatID + "), " + "gtrid_length(" + this.gtrid_length + "), " + "bqual_length(" + this.bqual_length + "), " + "data(" + stringBuffer + ")" + "}");
        return string;
    }

    public byte[] getBranchQualifier() {
        byte[] byArray = new byte[this.bqual_length];
        System.arraycopy(this.data, this.gtrid_length, byArray, 0, this.bqual_length);
        return byArray;
    }

    public void setBranchQualifier(byte[] byArray) {
        this.bqual_length = byArray.length > 64 ? 64 : byArray.length;
        System.arraycopy(byArray, 0, this.data, this.gtrid_length, this.bqual_length);
    }

    public int getFormatId() {
        return this.formatID;
    }

    public void setFormatID(int n) {
        this.formatID = n;
    }

    public byte[] getGlobalTransactionId() {
        byte[] byArray = new byte[this.gtrid_length];
        System.arraycopy(this.data, 0, byArray, 0, this.gtrid_length);
        return byArray;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getGtridLength() {
        return this.gtrid_length;
    }

    public int getBqualLength() {
        return this.bqual_length;
    }
}

