/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class DB2CharReader
extends Reader {
    protected int lobType;
    protected int lobLocator;
    protected int docLength;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected boolean closed;
    protected boolean markSupported = true;
    protected int rc = 0;
    protected int encoding;
    protected int currentPosition;
    protected int numBytesRead;
    protected int markedPosition;
    protected int bufferPos = 0;
    protected int bufferEnd = 0;
    protected static final int defaultBufferSize = 16000;
    protected char[] buffer = null;

    protected native int SQLGetLength(int var1);

    protected native String SQLReadStr(int var1, int var2, int var3);

    public DB2CharReader(DB2Statement dB2Statement, int n, int n2) throws SQLException {
        this.lobType = n;
        this.lobLocator = n2;
        DB2Connection dB2Connection = this.connection = (DB2Connection)dB2Statement.getConnection();
        synchronized (dB2Connection) {
            this.statement = this.connection.getInputStreamStmt();
            this.docLength = this.SQLGetLength(this.statement.statementHandle);
            this.connection.sqlExcptGen.check_return_code(this.statement, this.rc);
            this.closed = false;
            this.currentPosition = 1;
            this.markedPosition = 1;
        }
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        char[] cArray = new char[1];
        int n = this.read(cArray, 0, 1);
        if (n == -1) {
            return -1;
        }
        return cArray[0];
    }

    public int read(char[] cArray) throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        return this.read(cArray, 0, cArray.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        int n4 = 0;
        try {
            int n5;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "read( buf, " + n + ", " + n2 + " )");
            }
            int n6 = n2;
            if (this.buffer != null && (n5 = this.bufferEnd - this.bufferPos) != 0) {
                if (n6 <= n5) {
                    System.arraycopy(this.buffer, this.bufferPos, cArray, n, n6);
                    this.bufferPos += n6;
                    n4 = n6;
                    n6 = 0;
                } else {
                    System.arraycopy(this.buffer, this.bufferPos, cArray, n, n5);
                    this.bufferPos += n5;
                    n4 = n5;
                    n6 -= n5;
                }
            }
            if (n6 != 0 && this.currentPosition <= this.docLength) {
                String string;
                n5 = 0;
                n2 = Math.max(16000, n6);
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(30, "currentPosition", this.currentPosition);
                    DB2Trace.data(30, "charsToRead", n6);
                    DB2Trace.data(30, "len", n2);
                }
                try {
                    this.numBytesRead = 0;
                    DB2Statement dB2Statement = this.statement;
                    synchronized (dB2Statement) {
                        string = this.SQLReadStr(n2, this.statement.statementHandle, this.connection.connectionHandle);
                        if (this.rc != 0) {
                            this.connection.sqlExcptGen.check_return_code(this.statement, this.rc);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new IOException(sQLException.getMessage());
                }
                if (string != null) {
                    int n7 = string.length();
                    this.buffer = string.toCharArray();
                    n5 = n7;
                    this.currentPosition = this.lobType == 41 ? (this.currentPosition += this.numBytesRead) : (this.currentPosition += n7);
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(40, "numBytesRead", this.numBytesRead);
                    DB2Trace.data(40, "charsAvailable", n5);
                }
                this.bufferPos = 0;
                this.bufferEnd = n5;
                if (n5 != 0) {
                    if (n6 <= n5) {
                        System.arraycopy(this.buffer, this.bufferPos, cArray, n + n4, n6);
                        this.bufferPos += n6;
                        n4 += n6;
                    } else {
                        System.arraycopy(this.buffer, this.bufferPos, cArray, n + n4, n5);
                        this.bufferPos += n5;
                        n4 += n5;
                    }
                }
            }
            if (n4 == 0) {
                n4 = -1;
            }
            n3 = n4;
            Object var11_13 = null;
            if (!DB2Trace.TraceOn) return n3;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "read()", n4);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "read()", n4);
        return n3;
    }

    public void close() {
        this.closed = true;
    }

    public boolean markSupported() {
        return this.markSupported;
    }

    public void mark(int n) throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        if (!this.markSupported()) {
            this.connection.sqlExcptGen.throwNotSupportedIO("Mark()");
        }
        this.markedPosition = this.currentPosition;
    }

    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        if (!this.markSupported()) {
            this.connection.sqlExcptGen.throwNotSupportedIO("reset()");
        }
        this.currentPosition = this.markedPosition;
    }

    public long skip(long l) throws IOException {
        int n;
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        if (!this.markSupported()) {
            this.connection.sqlExcptGen.throwNotSupportedIO("skip()");
        }
        if ((long)(n = this.docLength - this.currentPosition) < l) {
            this.currentPosition = this.docLength;
            return n;
        }
        this.currentPosition = (int)((long)this.currentPosition + l);
        return l;
    }

    int getLocator() {
        return this.lobLocator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getLength() throws SQLException {
        long l;
        int n = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getLength()");
            }
            DB2Statement dB2Statement = this.statement;
            synchronized (dB2Statement) {
                this.docLength = this.SQLGetLength(this.statement.statementHandle);
                this.connection.sqlExcptGen.check_return_code(this.statement, this.rc);
            }
            n = this.docLength;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "docLength", this.docLength);
            }
            l = n;
            Object var6_5 = null;
            if (!DB2Trace.TraceOn) return l;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getLength()", n);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getLength()", n);
        return l;
    }

    void moveTo(int n) {
        this.currentPosition = n < this.docLength ? n : this.docLength;
    }
}

