/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Exception;
import COM.ibm.db2.jdbc.DB2PooledConnection;
import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import java.sql.SQLException;
import java.util.Properties;

public class DB2ReusableConnection
extends DB2Connection {
    private DB2PooledConnection pCon = null;
    private boolean shouldBeDisconnected = false;

    public DB2ReusableConnection(String string, Properties properties, int n, DB2PooledConnection dB2PooledConnection, boolean bl) throws SQLException {
        super(string, properties, n, bl);
        this.pCon = dB2PooledConnection;
    }

    public void close() throws SQLException {
        DB2Trace.methodEntry(this, "close()");
        if (this.shouldBeDisconnected) {
            super.close();
        } else if (!this.closed) {
            if (this.inputStreamStmt != null) {
                this.inputStreamStmt.close();
                this.inputStreamStmt = null;
            }
            super.setClosed(true);
            if (this.isConnectionAlive(this.connectionHandle)) {
                super.resetConnectionDefaults();
                this.pCon.backToPool();
            } else {
                try {
                    this.realClose();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (this.pCon != null) {
                    this.pCon.exceptionThrown(new DB2Exception(this.errMsgClass.getString("0600"), "S1000", -99999, null));
                }
            }
        }
        DB2Trace.methodExit(this, "close()");
        DB2Trace.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void realClose() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "realClose()");
            }
            this.close2();
            Object var2_1 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "realClose()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "realClose()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finalize() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "finalize()");
            }
            this.shouldBeDisconnected = true;
            if (this.inputStreamStmt != null) {
                if (this.closed) {
                    this.closed = false;
                    this.inputStreamStmt.close();
                    this.closed = true;
                } else {
                    this.inputStreamStmt.close();
                }
                this.inputStreamStmt = null;
            }
            super.finalize();
            Object var2_1 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "finalize()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "finalize()");
    }
}

