/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.net.DB2Convertor;
import java.io.ByteArrayInputStream;
import java.sql.SQLException;

public class DB2Message {
    protected byte[] outMsg = new byte[0];
    protected int lenInMsg = 0;
    protected byte[] buffer;
    protected int current;

    protected byte[] int2AofB(int n) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)(n & 0xFF);
        byArray[2] = (byte)((n & 0xFF00) >> 8);
        byArray[1] = (byte)((n & 0xFF0000) >> 16);
        byArray[0] = (byte)((n & 0xFF000000) >> 24);
        return byArray;
    }

    protected byte[] short2AofB(short s) {
        byte[] byArray = new byte[2];
        byArray[1] = (byte)(s & 0xFF);
        byArray[0] = (byte)((s & 0xFF00) >> 8);
        return byArray;
    }

    public synchronized void reset() {
        this.outMsg = new byte[0];
    }

    protected void append(byte[] byArray) {
        byte[] byArray2 = new byte[this.outMsg.length + byArray.length];
        System.arraycopy(this.outMsg, 0, byArray2, 0, this.outMsg.length);
        System.arraycopy(byArray, 0, byArray2, this.outMsg.length, byArray.length);
        this.outMsg = new byte[byArray2.length];
        System.arraycopy(byArray2, 0, this.outMsg, 0, this.outMsg.length);
    }

    public synchronized void addParam(int n) {
        this.append(this.int2AofB(n));
    }

    public synchronized void addParam(String string) {
        this.addParam(new DB2Convertor(string).toAsciiByteArray());
    }

    public void addParam(byte by) {
        byte[] byArray = new byte[]{by};
        this.append(byArray);
    }

    public void addParam(byte[] byArray) {
        if (null == byArray) {
            this.addParam(0);
        } else {
            this.append(this.int2AofB(byArray.length));
            this.append(byArray);
        }
    }

    public void addParam(short s) {
        this.append(this.int2AofB(s));
    }

    public void addParamShort(short s) {
        this.append(this.short2AofB(s));
    }

    public void addParam(double d) {
        String string = String.valueOf(d);
        this.addParam(string);
    }

    public synchronized byte[] outMessage() {
        byte[] byArray = new byte[this.outMsg.length + 6];
        System.arraycopy(this.short2AofB((short)1), 0, byArray, 0, 2);
        System.arraycopy(this.int2AofB(this.outMsg.length), 2, byArray, 0, 4);
        System.arraycopy(this.outMsg, 0, byArray, 6, this.outMsg.length);
        this.outMsg = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.outMsg, 0, this.outMsg.length);
        return this.outMsg;
    }

    public synchronized void recv(byte[] byArray) throws SQLException {
        this.lenInMsg = byArray.length;
        this.buffer = new byte[this.lenInMsg];
        System.arraycopy(byArray, 0, this.buffer, 0, this.lenInMsg);
        this.current = 0;
    }

    public String nextAsciiStr() {
        byte[] byArray = this.nextAofB();
        if (null == byArray) {
            return "";
        }
        char[] cArray = new char[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            cArray[n] = (char)byArray[n];
            ++n;
        }
        return new String(cArray);
    }

    public String nextUnicodeStr() {
        byte[] byArray = this.nextAofB();
        if (null == byArray) {
            return "";
        }
        return new DB2Convertor(byArray).toStr();
    }

    public byte nextByte() {
        byte by = this.buffer[this.current];
        ++this.current;
        return by;
    }

    public int nextInt() {
        int n = 0;
        boolean bl = false;
        byte[] byArray = new byte[4];
        int n2 = 0;
        while (n2 < 4) {
            byArray[n2] = this.buffer[this.current + n2];
            ++n2;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n3 = byteArrayInputStream.read();
        int n4 = byteArrayInputStream.read();
        int n5 = byteArrayInputStream.read();
        int n6 = byteArrayInputStream.read();
        n = n3 << 24 | n4 << 16 | n5 << 8 | n6;
        this.current += 4;
        return n;
    }

    public long nextLong() {
        String string = this.nextAsciiStr();
        Long l = new Long(string);
        return l;
    }

    public short nextShort() {
        int n = 0;
        boolean bl = false;
        short s = 0;
        byte[] byArray = new byte[2];
        int n2 = 0;
        while (n2 < 2) {
            byArray[n2] = this.buffer[this.current + n2];
            ++n2;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n3 = byteArrayInputStream.read();
        int n4 = byteArrayInputStream.read();
        n = n3 << 8 | n4;
        s = (short)n;
        this.current += 2;
        return s;
    }

    public float nextFloat() {
        String string = this.nextAsciiStr();
        Float f = new Float(string);
        return f.floatValue();
    }

    public double nextDouble() {
        String string = this.nextAsciiStr();
        Double d = new Double(string);
        return d;
    }

    public byte[] nextAofB() {
        int n = this.nextInt();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = this.buffer[n2 + this.current];
            ++n2;
        }
        this.current += n;
        return byArray;
    }
}

