/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Exception;
import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Binary2AsciiInputStream;
import COM.ibm.db2.jdbc.net.DB2Blob;
import COM.ibm.db2.jdbc.net.DB2CharReader;
import COM.ibm.db2.jdbc.net.DB2Clob;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2DataObject;
import COM.ibm.db2.jdbc.net.DB2InputStream;
import COM.ibm.db2.jdbc.net.DB2OutputParameters;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2ResultSet;
import COM.ibm.db2.jdbc.net.DB2ScrollableResultSet;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class DB2RowObject {
    protected DB2Connection connection = null;
    protected DB2Statement statement = null;
    private DB2ResultSet resultset = null;
    protected DB2Request db2req = null;
    protected SQLExceptionGenerator sqlExcptGen = null;
    protected int length = 0;
    protected short[] sqltype = null;
    private boolean cleared = true;
    private int currentRow = 0;
    private Object[] fetchedRows = null;
    private int firstFetchedIndex = 0;
    private int firstFetchedRow = 0;
    private int numFetchedRows = 0;
    private boolean unboundColumns = false;
    private boolean endOfData = false;

    public DB2RowObject() throws SQLException {
    }

    public DB2RowObject(DB2ResultSet dB2ResultSet) throws SQLException {
        this.connection = dB2ResultSet.statement.connection;
        this.resultset = dB2ResultSet;
        this.statement = dB2ResultSet.statement;
        this.db2req = dB2ResultSet.db2req;
        this.sqlExcptGen = dB2ResultSet.sqlExcptGen;
    }

    protected void reset() {
        this.cleared = true;
        this.currentRow = 0;
        this.firstFetchedIndex = 0;
        this.firstFetchedRow = 0;
        this.numFetchedRows = 0;
        this.endOfData = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void activate() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "activate()");
            }
            this.cleared = false;
            this.length = this.resultset.statement.colCount;
            if (null == this.sqltype || this.length > this.sqltype.length) {
                this.sqltype = new short[this.length];
            }
            if (null != this.fetchedRows) {
                int n = 0;
                while (n < this.fetchedRows.length) {
                    if (null != this.fetchedRows[n] && ((DB2DataObject[])this.fetchedRows[n]).length < this.length) {
                        DB2DataObject[] dB2DataObjectArray = new DB2DataObject[this.length];
                        System.arraycopy(this.fetchedRows[n], 0, dB2DataObjectArray, 0, ((DB2DataObject[])this.fetchedRows[n]).length);
                        this.fetchedRows[n] = dB2DataObjectArray;
                    }
                    ++n;
                }
            }
            this.unboundColumns = false;
            int n = 0;
            while (n < this.length) {
                this.sqltype[n] = (short)this.resultset.rsMetaData.colBaseTypesNotAdjusted[n];
                if (!this.resultset.preFetched[n]) {
                    this.unboundColumns = true;
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "sqltype[" + n + "]", this.sqltype[n]);
                }
                ++n;
            }
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(100, "length", this.length);
            DB2Trace.data(100, "unboundColumns", String.valueOf(this.unboundColumns));
            DB2Trace.methodExit(this, "activate()");
            throw throwable;
        }
        DB2Trace.data(100, "length", this.length);
        DB2Trace.data(100, "unboundColumns", String.valueOf(this.unboundColumns));
        DB2Trace.methodExit(this, "activate()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int forwardOnlyNext() throws SQLException {
        int n;
        int n2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "forwardOnlyNext()");
            }
            this.resultset.clearWarnings();
            if (this.cleared) {
                this.activate();
            }
            ++this.currentRow;
            if (this.currentRow < this.firstFetchedRow || this.currentRow > this.firstFetchedRow + this.numFetchedRows - 1) {
                if (this.endOfData) {
                    this.currentRow = this.firstFetchedRow + this.numFetchedRows;
                    n2 = 100;
                } else {
                    n = 1;
                    if (this.unboundColumns) {
                        n = 1;
                    } else if (this.resultset.fetchSize > 0) {
                        n = this.resultset.fetchSize;
                    } else if (this.statement.CLIBlockSize > 0) {
                        n = this.statement.CLIBlockSize;
                    }
                    try {
                        DB2Request dB2Request = this.db2req;
                        synchronized (dB2Request) {
                            this.db2req.write((short)34);
                            this.db2req.write(this.resultset.stmtHandle);
                            this.db2req.write(n);
                            this.db2req.sendAndRecv();
                            n2 = this.getDataFromBuffer(this.currentRow, n, 0, 0);
                        }
                    }
                    catch (IOException iOException) {
                        this.sqlExcptGen.socketException("08S01a");
                    }
                    if (100 == n2) {
                        this.endOfData = true;
                        if (this.currentRow >= this.firstFetchedRow && this.currentRow <= this.firstFetchedRow + this.numFetchedRows - 1) {
                            n2 = 0;
                        }
                    }
                }
            }
            n = n2;
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(100, "endOfData", String.valueOf(this.endOfData));
            DB2Trace.data(100, "currentRow", this.currentRow);
            DB2Trace.methodExit((Object)this, "forwardOnlyNext()", n2);
            throw throwable;
        }
        DB2Trace.data(100, "endOfData", String.valueOf(this.endOfData));
        DB2Trace.data(100, "currentRow", this.currentRow);
        DB2Trace.methodExit((Object)this, "forwardOnlyNext()", n2);
        return n;
    }

    protected int next() throws SQLException {
        return this.fetchScroll(this.currentRow + 1);
    }

    protected int getDataFromBuffer() throws IOException {
        this.currentRow = 1;
        return this.getDataFromBuffer(1, 1, 0, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getDataFromBuffer(int n, int n2, int n3, int n4) throws IOException {
        int n5;
        int n6;
        block41: {
            int n7;
            block39: {
                n6 = 0;
                try {
                    int n8;
                    Object[] objectArray;
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getDataFromBuffer( " + n + ", " + n2 + ", " + n3 + ", " + n4 + " )");
                    }
                    if (n2 < 1) {
                        n7 = n6;
                        Object var20_8 = null;
                        if (!DB2Trace.TraceOn) return n7;
                        break block39;
                    }
                    short s = 0;
                    short s2 = 0;
                    short s3 = 0;
                    short s4 = 0;
                    short s5 = 0;
                    short s6 = 0;
                    int n9 = 0;
                    int n10 = 0;
                    if (null == this.fetchedRows || this.fetchedRows.length < n3 + n2 + n4) {
                        block40: {
                            objectArray = new Object[n3 + n2 + n4];
                            if (null != this.fetchedRows) {
                                n8 = 0;
                                n5 = this.firstFetchedIndex;
                                while (true) {
                                    if (n8 >= this.fetchedRows.length) {
                                        this.firstFetchedIndex = 0;
                                        n8 = this.fetchedRows.length;
                                        break block40;
                                    }
                                    objectArray[n8] = this.fetchedRows[n5 % this.fetchedRows.length];
                                    ++n8;
                                    ++n5;
                                }
                            }
                            n8 = 0;
                        }
                        while (true) {
                            if (n8 >= objectArray.length) {
                                this.fetchedRows = objectArray;
                                break;
                            }
                            objectArray[n8] = new DB2DataObject[this.length];
                            ++n8;
                        }
                    }
                    if (n3 > 0 || n4 > 0) {
                        n5 = this.firstFetchedIndex - this.firstFetchedRow;
                        n10 = (n + n5 + this.fetchedRows.length) % this.fetchedRows.length;
                    } else {
                        n10 = 0;
                    }
                    this.firstFetchedIndex = (n10 - n3 + this.fetchedRows.length) % this.fetchedRows.length;
                    this.firstFetchedRow = n - n3;
                    this.numFetchedRows = n3;
                    int n11 = n;
                    block19: while (n11 < n + n2) {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(10, "row", n11);
                            DB2Trace.data(10, "index", n10);
                        }
                        if (null != this.resultset && (n6 = this.db2req.readInt()) != 0 && n6 != 1) break;
                        objectArray = (DB2DataObject[])this.fetchedRows[n10];
                        n8 = 0;
                        while (true) {
                            if (n8 >= this.length) {
                                ++this.numFetchedRows;
                                n10 = (n10 + 1) % this.fetchedRows.length;
                                ++n11;
                                continue block19;
                            }
                            if (this.resultset == null || this.resultset.preFetched[n8]) {
                                int n12 = this.db2req.readInt();
                                if (DB2Trace.TraceOn) {
                                    DB2Trace.data(30, "sqltype[" + n8 + "]", this.sqltype[n8]);
                                    DB2Trace.data(30, "sqlind", n12);
                                }
                                if (null == objectArray[n8]) {
                                    objectArray[n8] = new DB2DataObject();
                                }
                                if (n12 == -1) {
                                    ((DB2DataObject)objectArray[n8]).set(null);
                                } else {
                                    switch (this.sqltype[n8]) {
                                        case 5: {
                                            ((DB2DataObject)objectArray[n8]).set(this.db2req.readShort());
                                            break;
                                        }
                                        case 4: {
                                            ((DB2DataObject)objectArray[n8]).set(this.db2req.readInt());
                                            break;
                                        }
                                        case -5: {
                                            ((DB2DataObject)objectArray[n8]).set(this.db2req.readLong());
                                            break;
                                        }
                                        case 91: {
                                            s = this.db2req.readShort();
                                            s2 = this.db2req.readShort();
                                            s3 = this.db2req.readShort();
                                            ((DB2DataObject)objectArray[n8]).setDate(s, s2, s3);
                                            break;
                                        }
                                        case 92: {
                                            s4 = this.db2req.readShort();
                                            s5 = this.db2req.readShort();
                                            s6 = this.db2req.readShort();
                                            ((DB2DataObject)objectArray[n8]).setTime(s4, s5, s6);
                                            break;
                                        }
                                        case 93: {
                                            s = this.db2req.readShort();
                                            s2 = this.db2req.readShort();
                                            s3 = this.db2req.readShort();
                                            s4 = this.db2req.readShort();
                                            s5 = this.db2req.readShort();
                                            s6 = this.db2req.readShort();
                                            n9 = this.db2req.readInt();
                                            ((DB2DataObject)objectArray[n8]).setTimestamp(s, s2, s3, s4, s5, s6, n9);
                                            break;
                                        }
                                        case 6: 
                                        case 8: {
                                            ((DB2DataObject)objectArray[n8]).set(this.db2req.readDouble());
                                            break;
                                        }
                                        case 7: {
                                            ((DB2DataObject)objectArray[n8]).set(this.db2req.readFloat());
                                            break;
                                        }
                                        case -400: 
                                        case -97: 
                                        case -96: 
                                        case -95: 
                                        case -10: 
                                        case -9: 
                                        case -8: 
                                        case -1: 
                                        case 1: 
                                        case 2: 
                                        case 3: 
                                        case 12: {
                                            ((DB2DataObject)objectArray[n8]).set(this.db2req.readString());
                                            break;
                                        }
                                        case -4: 
                                        case -3: 
                                        case -2: {
                                            ((DB2DataObject)objectArray[n8]).set(this.db2req.readBytes());
                                            break;
                                        }
                                        case -351: 
                                        case 31: 
                                        case 41: {
                                            ((DB2DataObject)objectArray[n8]).set(this.db2req.readInt());
                                            break;
                                        }
                                        case -98: {
                                            if (null == this.resultset) {
                                                ((DB2DataObject)objectArray[n8]).set(this.db2req.readBytes());
                                                break;
                                            }
                                            ((DB2DataObject)objectArray[n8]).set(this.db2req.readInt());
                                            break;
                                        }
                                        case -350: 
                                        case -99: {
                                            if (null == this.resultset) {
                                                ((DB2DataObject)objectArray[n8]).set(this.db2req.readString());
                                                break;
                                            }
                                            ((DB2DataObject)objectArray[n8]).set(this.db2req.readInt());
                                            break;
                                        }
                                        default: {
                                            ((DB2DataObject)objectArray[n8]).set(null);
                                        }
                                    }
                                }
                            }
                            ++n8;
                        }
                    }
                    if (this.numFetchedRows - n3 == n2) {
                        this.numFetchedRows += n4;
                    }
                    n5 = n6;
                    break block41;
                }
                catch (Throwable throwable) {
                    Object var20_10 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.data(100, "firstFetchedIndex", this.firstFetchedIndex);
                    DB2Trace.data(100, "firstFetchedRow", this.firstFetchedRow);
                    DB2Trace.data(100, "numFetchedRows", this.numFetchedRows);
                    DB2Trace.data(100, "currentRow", this.currentRow);
                    DB2Trace.methodExit((Object)this, "getDataFromBuffer()", n6);
                    throw throwable;
                }
            }
            DB2Trace.data(100, "firstFetchedIndex", this.firstFetchedIndex);
            DB2Trace.data(100, "firstFetchedRow", this.firstFetchedRow);
            DB2Trace.data(100, "numFetchedRows", this.numFetchedRows);
            DB2Trace.data(100, "currentRow", this.currentRow);
            DB2Trace.methodExit((Object)this, "getDataFromBuffer()", n6);
            return n7;
        }
        Object var20_9 = null;
        if (!DB2Trace.TraceOn) return n5;
        DB2Trace.data(100, "firstFetchedIndex", this.firstFetchedIndex);
        DB2Trace.data(100, "firstFetchedRow", this.firstFetchedRow);
        DB2Trace.data(100, "numFetchedRows", this.numFetchedRows);
        DB2Trace.data(100, "currentRow", this.currentRow);
        DB2Trace.methodExit((Object)this, "getDataFromBuffer()", n6);
        return n5;
    }

    private DB2DataObject getElement(int n) {
        DB2DataObject[] dB2DataObjectArray = null;
        if (this.currentRow >= this.firstFetchedRow && this.currentRow <= this.firstFetchedRow + this.numFetchedRows) {
            int n2 = (this.firstFetchedIndex + this.currentRow - this.firstFetchedRow) % this.fetchedRows.length;
            dB2DataObjectArray = (DB2DataObject[])this.fetchedRows[n2];
        }
        return dB2DataObjectArray[n];
    }

    protected boolean elementIsNull(int n) throws SQLException {
        if (this.resultset != null && this.resultset.getRow() == 0) {
            throw new DB2Exception("Current row is invalid", "24000");
        }
        DB2DataObject dB2DataObject = this.getElement(n);
        return null == dB2DataObject || dB2DataObject.isNull();
    }

    protected String getString(int n) throws SQLException {
        if (this.elementIsNull(n)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        String string = null;
        switch (this.sqltype[n]) {
            case -97: 
            case -96: 
            case -95: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                string = this.getStringValueData(n);
                break;
            }
            case -351: 
            case -350: 
            case -99: 
            case -98: 
            case 31: 
            case 41: {
                if (null == this.resultset) {
                    string = this.getStringValueData(n);
                    break;
                }
                string = this.resultset.getStringData(n + 1);
                break;
            }
            default: {
                string = this.getDataAsString(n);
            }
        }
        return string;
    }

    protected boolean getBoolean(int n) throws SQLException {
        if (this.elementIsNull(n)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return false;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        boolean bl = false;
        switch (this.sqltype[n]) {
            case -5: 
            case 4: 
            case 5: {
                long l = this.getLongValueData(n);
                if (l == 0L) break;
                bl = true;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte by = this.getByteValueData(n);
                if (by == 0) break;
                bl = true;
                break;
            }
            case 7: {
                float f = this.getFloatValueData(n);
                if (f == 0.0f) break;
                bl = true;
                break;
            }
            case 6: 
            case 8: {
                double d = this.getDoubleValueData(n);
                if (d == 0.0) break;
                bl = true;
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = this.getDecimalValueData(n);
                if (bigDecimal.compareTo(new BigDecimal(0.0)) == 0) break;
                bl = true;
                break;
            }
            case 91: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 92: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 93: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case -99: 
            case -1: 
            case 1: 
            case 12: {
                String string = this.getStringValueData(n);
                if (string == null) {
                    bl = false;
                    break;
                }
                if ((string = string.trim()).equals("1")) {
                    bl = true;
                    break;
                }
                bl = new Boolean(string);
                break;
            }
            default: {
                Object object = this.getObject(n);
                String string = object.toString();
                if (string != null) {
                    long l = Long.parseLong(string.trim());
                    if (l == 0L) break;
                    bl = true;
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return bl;
    }

    protected byte getByte(int n) throws SQLException {
        if (this.elementIsNull(n)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return 0;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        byte by = 0;
        switch (this.sqltype[n]) {
            case -5: 
            case 4: 
            case 5: {
                long l = this.getLongValueData(n);
                by = (byte)l;
                if ((long)by == l) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                by = this.getByteValueData(n);
                break;
            }
            case 7: {
                float f = this.getFloatValueData(n);
                by = (byte)f;
                if ((float)by == f) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 6: 
            case 8: {
                double d = this.getDoubleValueData(n);
                by = (byte)d;
                if ((double)by == d) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 2: 
            case 3: {
                short s = this.getShort(n);
                by = (byte)s;
                if ((short)by == s) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 91: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 92: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 93: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            default: {
                Object object = this.getObject(n);
                String string = object.toString();
                if (string != null) {
                    char c = string.trim().charAt(0);
                    by = (byte)c;
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return by;
    }

    protected short getShort(int n) throws SQLException {
        if (this.elementIsNull(n)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return 0;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        short s = 0;
        switch (this.sqltype[n]) {
            case 5: {
                long l = this.getLongValueData(n);
                s = (short)l;
                break;
            }
            case -5: 
            case 4: {
                long l = this.getLongValueData(n);
                if (l >= -32768L && l <= 32767L) {
                    s = (short)l;
                    if ((long)s == l) break;
                    this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                    break;
                }
                throw new NumberFormatException();
            }
            case 7: {
                float f = this.getFloatValueData(n);
                s = new Double(f).shortValue();
                if ((float)s == f) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 6: 
            case 8: {
                double d = this.getDoubleValueData(n);
                s = new Double(d).shortValue();
                if ((double)s == d) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = this.getDecimalValueData(n);
                long l = bigDecimal.longValue();
                if (l >= -32768L && l <= 32767L) {
                    s = (short)l;
                    if ((float)s == bigDecimal.floatValue()) break;
                    this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                    break;
                }
                throw new NumberFormatException();
            }
            case 91: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 92: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 93: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            default: {
                Object object = this.getObject(n);
                String string = object.toString();
                if (string != null) {
                    s = Short.parseShort(string.trim());
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return s;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getInt(int n) throws SQLException {
        int n2;
        int n3;
        block18: {
            int n4;
            block17: {
                n3 = 0;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getInt( " + n + " )");
                    }
                    if (this.elementIsNull(n)) {
                        if (this.resultset != null) {
                            this.resultset.nullTag = true;
                        }
                        n4 = 0;
                        Object var7_10 = null;
                        if (!DB2Trace.TraceOn) return n4;
                        break block17;
                    }
                    if (this.resultset != null) {
                        this.resultset.nullTag = false;
                    }
                    switch (this.sqltype[n]) {
                        case 4: 
                        case 5: {
                            long l = this.getLongValueData(n);
                            n3 = (int)l;
                            break;
                        }
                        case -5: {
                            long l = this.getLongValueData(n);
                            if (l < Integer.MIN_VALUE) throw new NumberFormatException();
                            if (l > Integer.MAX_VALUE) throw new NumberFormatException();
                            n3 = (int)l;
                            if ((long)n3 == l) break;
                            this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                            break;
                        }
                        case 7: {
                            float f = this.getFloatValueData(n);
                            n3 = new Double(f).intValue();
                            if ((float)n3 == f) break;
                            this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                            break;
                        }
                        case 6: 
                        case 8: {
                            double d = this.getDoubleValueData(n);
                            n3 = new Double(d).intValue();
                            if ((double)n3 == d) break;
                            this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                            break;
                        }
                        case 2: 
                        case 3: {
                            BigDecimal bigDecimal = this.getDecimalValueData(n);
                            long l = bigDecimal.longValue();
                            if (l < Integer.MIN_VALUE) throw new NumberFormatException();
                            if (l > Integer.MAX_VALUE) throw new NumberFormatException();
                            n3 = (int)l;
                            if ((float)n3 == bigDecimal.floatValue()) break;
                            this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                            break;
                        }
                        case 91: {
                            SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                            break;
                        }
                        case 92: {
                            SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                            break;
                        }
                        case 93: {
                            SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                            break;
                        }
                        default: {
                            Object object = this.getObject(n);
                            String string = object.toString();
                            if (string != null) {
                                n3 = Integer.parseInt(string.trim());
                                break;
                            }
                            if (this.resultset == null) break;
                            this.resultset.nullTag = false;
                        }
                    }
                    n2 = n3;
                    break block18;
                }
                catch (Throwable throwable) {
                    Object var7_12 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit((Object)this, "getInt()", n3);
                    throw throwable;
                }
            }
            DB2Trace.methodExit((Object)this, "getInt()", n3);
            return n4;
        }
        Object var7_11 = null;
        if (!DB2Trace.TraceOn) return n2;
        DB2Trace.methodExit((Object)this, "getInt()", n3);
        return n2;
    }

    protected long getLong(int n) throws SQLException {
        if (this.elementIsNull(n)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return 0L;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        long l = 0L;
        switch (this.sqltype[n]) {
            case -5: 
            case 4: 
            case 5: {
                l = this.getLongValueData(n);
                break;
            }
            case 7: {
                float f = this.getFloatValueData(n);
                l = new Double(f).longValue();
                if ((float)l == f) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 6: 
            case 8: {
                double d = this.getDoubleValueData(n);
                l = new Double(d).longValue();
                if ((double)l == d) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = this.getDecimalValueData(n);
                l = bigDecimal.longValue();
                if ((float)l == bigDecimal.floatValue()) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 91: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 92: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 93: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            default: {
                Object object = this.getObject(n);
                String string = object.toString();
                if (string != null) {
                    l = Long.parseLong(string.trim());
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return l;
    }

    protected float getFloat(int n) throws SQLException {
        if (this.elementIsNull(n)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return 0.0f;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        float f = 0.0f;
        switch (this.sqltype[n]) {
            case -5: 
            case 4: 
            case 5: {
                f = this.getLongValueData(n);
                break;
            }
            case 7: {
                f = this.getFloatValueData(n);
                break;
            }
            case 6: 
            case 8: {
                double d = this.getDoubleValueData(n);
                f = (float)d;
                if (Math.abs(d) == Double.POSITIVE_INFINITY || Math.abs(f) != Float.POSITIVE_INFINITY) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            default: {
                Object object = this.getObject(n);
                String string = object.toString();
                if (string != null) {
                    Float f2 = new Float(string.trim());
                    f = f2.floatValue();
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return f;
    }

    protected double getDouble(int n) throws SQLException {
        if (this.elementIsNull(n)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return 0.0;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        double d = 0.0;
        switch (this.sqltype[n]) {
            case -5: 
            case 4: 
            case 5: {
                d = this.getLongValueData(n);
                break;
            }
            case 7: {
                d = this.getFloatValueData(n);
                break;
            }
            case 6: 
            case 8: {
                d = this.getDoubleValueData(n);
                break;
            }
            default: {
                Object object = this.getObject(n);
                String string = object.toString();
                if (string != null) {
                    Double d2 = new Double(string.trim());
                    d = d2;
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return d;
    }

    protected byte[] getBytes(int n) throws SQLException {
        if (this.elementIsNull(n)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        byte[] byArray = null;
        switch (this.sqltype[n]) {
            case -4: 
            case -3: 
            case -2: {
                byArray = this.getBytesValueData(n);
                break;
            }
            case -351: 
            case -350: 
            case -99: 
            case -98: 
            case 31: 
            case 41: {
                if (null == this.resultset) {
                    byArray = this.getBytesValueData(n);
                    break;
                }
                byArray = this.resultset.getBytesData(n + 1);
                break;
            }
            default: {
                Object object = this.getObject(n);
                String string = object.toString();
                if (string != null) {
                    byArray = string.trim().getBytes();
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Date getDate(int n, Calendar calendar) throws SQLException {
        Object object;
        Date date = null;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getDate(" + n + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            if (this.elementIsNull(n)) {
                if (this.resultset != null) {
                    this.resultset.nullTag = true;
                }
                Date date2 = null;
                Object var9_6 = null;
                if (!DB2Trace.TraceOn) return date2;
                DB2Trace.methodExit((Object)this, "getDate(...)", date == null ? "NULL" : date.toString());
                return date2;
            }
            if (this.resultset != null) {
                this.resultset.nullTag = false;
            }
            if (this.sqltype[n] == 91) {
                object = (int[])this.getElement((int)n).oValue;
                int n2 = object[0];
                int n3 = object[1];
                int n4 = object[2];
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "Year(+1900)", n2 + 1900);
                    DB2Trace.data(10, "Month(+1)", n3 + 1);
                    DB2Trace.data(10, "Date", n4);
                }
                calendar = (Calendar)calendar.clone();
                calendar.set(n2 + 1900, n3, n4, 0, 0, 0);
                calendar.set(14, 0);
                date = new Date(calendar.getTime().getTime());
            } else if (this.sqltype[n] == 93) {
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                object = this.getTimestamp(n, calendar);
                calendar.setTime((java.util.Date)object);
                date = new Date(calendar.getTime().getTime());
            } else if (this.sqltype[n] == 92) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(30, "Time sqltype", 92);
                }
                date = null;
            } else {
                object = this.getObject(n);
                String string = object.toString();
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(40, "tmpStr", string);
                }
                if (string != null) {
                    try {
                        date = Date.valueOf(string.trim());
                    }
                    catch (Exception exception) {
                        date = null;
                    }
                } else if (this.resultset != null) {
                    this.resultset.nullTag = false;
                }
            }
            object = date;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getDate(...)", date == null ? "NULL" : date.toString());
            throw throwable;
        }
        Object var9_7 = null;
        if (!DB2Trace.TraceOn) return object;
        DB2Trace.methodExit((Object)this, "getDate(...)", date == null ? "NULL" : date.toString());
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Time getTime(int n, Calendar calendar) throws SQLException {
        Object object;
        Time time = null;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTime(" + n + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            if (this.elementIsNull(n)) {
                if (this.resultset != null) {
                    this.resultset.nullTag = true;
                }
                Time time2 = null;
                Object var9_6 = null;
                if (!DB2Trace.TraceOn) return time2;
                DB2Trace.methodExit((Object)this, "getTime(...)", time == null ? "NULL" : time.toString());
                return time2;
            }
            if (this.resultset != null) {
                this.resultset.nullTag = false;
            }
            if (this.sqltype[n] == 92) {
                object = (int[])this.getElement((int)n).oValue;
                int n2 = object[0];
                Object object2 = object[1];
                Object object3 = object[2];
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "hour", n2);
                    DB2Trace.data(10, "minute", (int)object2);
                    DB2Trace.data(10, "second", (int)object3);
                }
                calendar = (Calendar)calendar.clone();
                calendar.set(1970, 0, 1, n2, (int)object2, (int)object3);
                calendar.set(14, 0);
                time = new Time(calendar.getTime().getTime());
            } else if (this.sqltype[n] == 93) {
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                object = this.getTimestamp(n, calendar);
                calendar.setTime((java.util.Date)object);
                time = new Time(calendar.getTime().getTime());
            } else {
                object = this.getObject(n);
                String string = object.toString();
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(30, "tmpStr", string);
                }
                if (string != null) {
                    string = string.trim().replace('.', ':');
                    time = Time.valueOf(string);
                } else if (this.resultset != null) {
                    this.resultset.nullTag = false;
                }
            }
            object = time;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getTime(...)", time == null ? "NULL" : time.toString());
            throw throwable;
        }
        Object var9_7 = null;
        if (!DB2Trace.TraceOn) return object;
        DB2Trace.methodExit((Object)this, "getTime(...)", time == null ? "NULL" : time.toString());
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Object object;
        Timestamp timestamp = null;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTimestamp(" + n + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            if (this.elementIsNull(n)) {
                if (this.resultset != null) {
                    this.resultset.nullTag = true;
                }
                Timestamp timestamp2 = null;
                Object var13_6 = null;
                if (!DB2Trace.TraceOn) return timestamp2;
                DB2Trace.methodExit((Object)this, "getTimestamp(...)", timestamp == null ? "NULL" : timestamp.toString());
                return timestamp2;
            }
            if (this.resultset != null) {
                this.resultset.nullTag = false;
            }
            if (this.sqltype[n] == 93) {
                object = (int[])this.getElement((int)n).oValue;
                int n2 = object[0];
                int n3 = object[1];
                Object object2 = object[2];
                Object object3 = object[3];
                Object object4 = object[4];
                Object object5 = object[5];
                Object object6 = object[6];
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "year", n2);
                    DB2Trace.data(10, "month", n3);
                    DB2Trace.data(10, "date", (int)object2);
                    DB2Trace.data(10, "hour", (int)object3);
                    DB2Trace.data(10, "minute", (int)object4);
                    DB2Trace.data(10, "second", (int)object5);
                    DB2Trace.data(10, "nano", (int)object6);
                }
                calendar = (Calendar)calendar.clone();
                calendar.set(n2 + 1900, n3, (int)object2, (int)object3, (int)object4, (int)object5);
                calendar.set(14, 0);
                timestamp = new Timestamp(calendar.getTime().getTime());
                timestamp.setNanos((int)object6);
            } else if (this.sqltype[n] == 91) {
                object = this.getDate(n, calendar);
                calendar.setTime((java.util.Date)object);
                timestamp = new Timestamp(calendar.getTime().getTime());
            } else {
                object = this.getObject(n);
                String string = object.toString();
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(30, "tmpStr", string);
                }
                if (string != null) {
                    String string2 = "0000-00-00 00:00:00.000000000";
                    StringBuffer stringBuffer = new StringBuffer(string.trim());
                    int n4 = stringBuffer.length();
                    if (n4 >= 10) {
                        stringBuffer.setCharAt(4, '-');
                        stringBuffer.setCharAt(7, '-');
                        if (n4 >= 19) {
                            stringBuffer.setCharAt(10, ' ');
                            stringBuffer.setCharAt(13, ':');
                            stringBuffer.setCharAt(16, ':');
                            if (n4 >= 21) {
                                stringBuffer.setCharAt(19, '.');
                            }
                        }
                    }
                    if (n4 < 29) {
                        stringBuffer.append(string2.substring(n4));
                    }
                    string = stringBuffer.toString();
                    timestamp = Timestamp.valueOf(string);
                } else if (this.resultset != null) {
                    this.resultset.nullTag = false;
                }
            }
            object = timestamp;
        }
        catch (Throwable throwable) {
            Object var13_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getTimestamp(...)", timestamp == null ? "NULL" : timestamp.toString());
            throw throwable;
        }
        Object var13_7 = null;
        if (!DB2Trace.TraceOn) return object;
        DB2Trace.methodExit((Object)this, "getTimestamp(...)", timestamp == null ? "NULL" : timestamp.toString());
        return object;
    }

    protected BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.elementIsNull(n)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        BigDecimal bigDecimal = null;
        switch (this.sqltype[n]) {
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                bigDecimal = this.getDecimalValueData(n);
                break;
            }
            default: {
                Object object = this.getObject(n);
                String string = object.toString();
                if (string != null) {
                    try {
                        string = DB2ResultSet.cvtScientific(string);
                        bigDecimal = new BigDecimal(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.sqlExcptGen.rsException("22005");
                    }
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return bigDecimal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getObject(int n) throws SQLException {
        Object var15_32;
        block35: {
            URL uRL;
            block34: {
                DB2Clob dB2Clob;
                block33: {
                    DB2Blob dB2Blob;
                    block32: {
                        Timestamp timestamp;
                        block31: {
                            Time time;
                            block30: {
                                Date date;
                                block29: {
                                    byte[] byArray;
                                    block28: {
                                        Double d;
                                        block27: {
                                            Float f;
                                            block26: {
                                                Long l;
                                                block25: {
                                                    Integer n2;
                                                    block24: {
                                                        BigDecimal bigDecimal;
                                                        block23: {
                                                            String string;
                                                            block22: {
                                                                Object var2_2;
                                                                block21: {
                                                                    try {
                                                                        if (DB2Trace.TraceOn) {
                                                                            DB2Trace.methodEntry(this, "getObject( " + n + " )");
                                                                        }
                                                                        if (this.elementIsNull(n)) {
                                                                            if (this.resultset != null) {
                                                                                this.resultset.nullTag = true;
                                                                            }
                                                                            var2_2 = null;
                                                                            Object var17_4 = null;
                                                                            if (!DB2Trace.TraceOn) return var2_2;
                                                                            break block21;
                                                                        }
                                                                        if (this.resultset != null) {
                                                                            this.resultset.nullTag = false;
                                                                        }
                                                                        switch (this.sqltype[n]) {
                                                                            case -97: 
                                                                            case -96: 
                                                                            case -95: 
                                                                            case -10: 
                                                                            case -9: 
                                                                            case -8: 
                                                                            case -1: 
                                                                            case 1: 
                                                                            case 12: {
                                                                                string = this.getStringValueData(n);
                                                                                break block22;
                                                                            }
                                                                            case 2: 
                                                                            case 3: {
                                                                                bigDecimal = this.getDecimalValueData(n);
                                                                                break block23;
                                                                            }
                                                                            case 4: 
                                                                            case 5: {
                                                                                n2 = new Integer((int)this.getLongValueData(n));
                                                                                break block24;
                                                                            }
                                                                            case -5: {
                                                                                l = new Long(this.getLongValueData(n));
                                                                                break block25;
                                                                            }
                                                                            case 7: {
                                                                                f = new Float(this.getFloatValueData(n));
                                                                                break block26;
                                                                            }
                                                                            case 6: 
                                                                            case 8: {
                                                                                d = new Double(this.getDoubleValueData(n));
                                                                                break block27;
                                                                            }
                                                                            case -4: 
                                                                            case -3: 
                                                                            case -2: {
                                                                                byArray = this.getBytesValueData(n);
                                                                                break block28;
                                                                            }
                                                                            case 91: {
                                                                                date = this.getDate(n, Calendar.getInstance());
                                                                                break block29;
                                                                            }
                                                                            case 92: {
                                                                                time = this.getTime(n, Calendar.getInstance());
                                                                                break block30;
                                                                            }
                                                                            case 93: {
                                                                                timestamp = this.getTimestamp(n, Calendar.getInstance());
                                                                                break block31;
                                                                            }
                                                                            case -98: 
                                                                            case 31: {
                                                                                dB2Blob = this.getBlob(n);
                                                                                break block32;
                                                                            }
                                                                            case -351: 
                                                                            case -350: 
                                                                            case -99: 
                                                                            case 41: {
                                                                                dB2Clob = this.getClob(n);
                                                                                break block33;
                                                                            }
                                                                            case -400: 
                                                                            case 70: {
                                                                                uRL = this.getURL(n);
                                                                                break block34;
                                                                            }
                                                                            default: {
                                                                                this.sqlExcptGen.rsException("22005");
                                                                                var15_32 = null;
                                                                                break;
                                                                            }
                                                                        }
                                                                        break block35;
                                                                    }
                                                                    catch (Throwable throwable) {
                                                                        Object var17_19 = null;
                                                                        if (!DB2Trace.TraceOn) throw throwable;
                                                                        DB2Trace.methodExit(this, "getObject()");
                                                                        throw throwable;
                                                                    }
                                                                }
                                                                DB2Trace.methodExit(this, "getObject()");
                                                                return var2_2;
                                                            }
                                                            Object var17_5 = null;
                                                            if (!DB2Trace.TraceOn) return string;
                                                            DB2Trace.methodExit(this, "getObject()");
                                                            return string;
                                                        }
                                                        Object var17_6 = null;
                                                        if (!DB2Trace.TraceOn) return bigDecimal;
                                                        DB2Trace.methodExit(this, "getObject()");
                                                        return bigDecimal;
                                                    }
                                                    Object var17_7 = null;
                                                    if (!DB2Trace.TraceOn) return n2;
                                                    DB2Trace.methodExit(this, "getObject()");
                                                    return n2;
                                                }
                                                Object var17_8 = null;
                                                if (!DB2Trace.TraceOn) return l;
                                                DB2Trace.methodExit(this, "getObject()");
                                                return l;
                                            }
                                            Object var17_9 = null;
                                            if (!DB2Trace.TraceOn) return f;
                                            DB2Trace.methodExit(this, "getObject()");
                                            return f;
                                        }
                                        Object var17_10 = null;
                                        if (!DB2Trace.TraceOn) return d;
                                        DB2Trace.methodExit(this, "getObject()");
                                        return d;
                                    }
                                    Object var17_11 = null;
                                    if (!DB2Trace.TraceOn) return byArray;
                                    DB2Trace.methodExit(this, "getObject()");
                                    return byArray;
                                }
                                Object var17_12 = null;
                                if (!DB2Trace.TraceOn) return date;
                                DB2Trace.methodExit(this, "getObject()");
                                return date;
                            }
                            Object var17_13 = null;
                            if (!DB2Trace.TraceOn) return time;
                            DB2Trace.methodExit(this, "getObject()");
                            return time;
                        }
                        Object var17_14 = null;
                        if (!DB2Trace.TraceOn) return timestamp;
                        DB2Trace.methodExit(this, "getObject()");
                        return timestamp;
                    }
                    Object var17_15 = null;
                    if (!DB2Trace.TraceOn) return dB2Blob;
                    DB2Trace.methodExit(this, "getObject()");
                    return dB2Blob;
                }
                Object var17_16 = null;
                if (!DB2Trace.TraceOn) return dB2Clob;
                DB2Trace.methodExit(this, "getObject()");
                return dB2Clob;
            }
            Object var17_17 = null;
            if (!DB2Trace.TraceOn) return uRL;
            DB2Trace.methodExit(this, "getObject()");
            return uRL;
        }
        Object var17_18 = null;
        if (!DB2Trace.TraceOn) return var15_32;
        DB2Trace.methodExit(this, "getObject()");
        return var15_32;
    }

    private long getLongValueData(int n) {
        return this.getElement((int)n).lValue;
    }

    private double getDoubleValueData(int n) {
        return this.getElement((int)n).dValue;
    }

    private float getFloatValueData(int n) {
        return this.getElement((int)n).fValue;
    }

    private String getStringValueData(int n) {
        return (String)this.getElement((int)n).oValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDataAsString(int n) throws SQLException {
        String string;
        String string2 = "";
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getDataAsString( " + n + " )");
                DB2Trace.data(10, "sqltype", this.sqltype[n]);
            }
            switch (this.sqltype[n]) {
                case -4: 
                case -3: 
                case -2: {
                    byte[] byArray = (byte[])this.getElement((int)n).oValue;
                    StringBuffer stringBuffer = new StringBuffer("");
                    int n2 = 0;
                    while (n2 < byArray.length) {
                        byte by = byArray[n2];
                        String string3 = Integer.toHexString(by).toUpperCase();
                        int n3 = string3.length();
                        if (n3 == 1) {
                            stringBuffer.append("0");
                        } else if (n3 > 2) {
                            string3 = string3.substring(n3 - 2);
                        }
                        stringBuffer.append(string3);
                        ++n2;
                    }
                    string2 = stringBuffer.toString();
                    break;
                }
                case 91: {
                    Date date = this.getDate(n, Calendar.getInstance());
                    if (this.resultset.wasNull()) break;
                    StringBuffer stringBuffer = new StringBuffer("");
                    String string4 = date.toString();
                    int n4 = string4.indexOf(45);
                    if (n4 < 4) {
                        switch (n4) {
                            case 1: {
                                stringBuffer.append("000");
                                break;
                            }
                            case 2: {
                                stringBuffer.append("00");
                                break;
                            }
                            case 3: {
                                stringBuffer.append("0");
                            }
                        }
                    }
                    stringBuffer.append(string4);
                    stringBuffer.setLength(10);
                    string2 = stringBuffer.toString();
                    break;
                }
                case 92: {
                    Time time = this.getTime(n, Calendar.getInstance());
                    if (this.resultset.wasNull()) break;
                    string2 = time.toString();
                    break;
                }
                case 93: {
                    Timestamp timestamp = this.getTimestamp(n, Calendar.getInstance());
                    if (this.resultset.wasNull()) break;
                    StringBuffer stringBuffer = new StringBuffer("");
                    String string5 = timestamp.toString();
                    int n5 = string5.indexOf(45);
                    if (n5 < 4) {
                        switch (n5) {
                            case 1: {
                                stringBuffer.append("000");
                                break;
                            }
                            case 2: {
                                stringBuffer.append("00");
                                break;
                            }
                            case 3: {
                                stringBuffer.append("0");
                            }
                        }
                    }
                    stringBuffer.append(string5);
                    stringBuffer.append("000000");
                    stringBuffer.setLength(26);
                    string2 = stringBuffer.toString();
                    break;
                }
                default: {
                    string2 = this.getElement(n).toString();
                }
            }
            string = string2;
            Object var14_19 = null;
            if (!DB2Trace.TraceOn) return string;
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getDataAsString()", string2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getDataAsString()", string2);
        return string;
    }

    private byte[] getBytesValueData(int n) {
        byte[] byArray = (byte[])this.getElement((int)n).oValue;
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    private byte getByteValueData(int n) {
        byte[] byArray = (byte[])this.getElement((int)n).oValue;
        return byArray[0];
    }

    private BigDecimal getDecimalValueData(int n) throws SQLException {
        BigDecimal bigDecimal = null;
        String string = this.getElement(n).toString();
        try {
            string = DB2ResultSet.cvtScientific(string);
            bigDecimal = new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.sqlExcptGen.rsException("22005");
        }
        return bigDecimal;
    }

    protected InputStream getAsciiStream(int n) throws SQLException {
        InputStream inputStream = null;
        String string = null;
        if (this.elementIsNull(n)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        switch (this.sqltype[n]) {
            case -351: 
            case -350: 
            case -99: 
            case 41: {
                int n2 = this.sqltype[n];
                if (-99 == this.sqltype[n]) {
                    n2 = 41;
                } else if (-350 == this.sqltype[n]) {
                    n2 = -351;
                }
                int n3 = (int)this.getElement((int)n).lValue;
                inputStream = new DB2InputStream(this.resultset.statement, n3, n2, false);
                this.resultset.addIsList((DB2InputStream)inputStream);
                break;
            }
            case -98: 
            case 31: {
                int n4 = (int)this.getElement((int)n).lValue;
                inputStream = new DB2Binary2AsciiInputStream(this.resultset.statement, n4, 31);
                this.resultset.addIsList((DB2InputStream)inputStream);
                break;
            }
            case -97: 
            case -96: 
            case -95: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                string = (String)this.getElement((int)n).oValue;
                break;
            }
            default: {
                string = this.getDataAsString(n);
            }
        }
        if (inputStream == null) {
            inputStream = string == null ? new ByteArrayInputStream(new byte[0]) : new ByteArrayInputStream(string.getBytes());
        }
        return inputStream;
    }

    protected InputStream getUnicodeStream(int n) throws SQLException {
        InputStream inputStream = null;
        String string = null;
        if (this.elementIsNull(n)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        switch (this.sqltype[n]) {
            case -351: 
            case -350: 
            case -99: 
            case 41: {
                int n2 = this.sqltype[n];
                if (-99 == this.sqltype[n]) {
                    n2 = 41;
                } else if (-350 == this.sqltype[n]) {
                    n2 = -351;
                }
                int n3 = (int)this.getElement((int)n).lValue;
                inputStream = new DB2InputStream(this.resultset.statement, n3, n2, true);
                this.resultset.addIsList((DB2InputStream)inputStream);
                break;
            }
            case -98: 
            case 31: {
                int n4 = (int)this.getElement((int)n).lValue;
                inputStream = new DB2Binary2AsciiInputStream(this.resultset.statement, n4, 31);
                this.resultset.addIsList((DB2InputStream)inputStream);
                break;
            }
            case -97: 
            case -96: 
            case -95: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                string = (String)this.getElement((int)n).oValue;
                break;
            }
            default: {
                string = this.getDataAsString(n);
            }
        }
        if (inputStream == null) {
            if (string == null) {
                inputStream = new ByteArrayInputStream(new byte[0]);
            } else {
                try {
                    inputStream = new ByteArrayInputStream(string.getBytes("UTF8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException(unsupportedEncodingException.toString());
                }
            }
        }
        return inputStream;
    }

    protected InputStream getBinaryStream(int n) throws SQLException {
        InputStream inputStream = null;
        if (this.elementIsNull(n)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        switch (this.sqltype[n]) {
            case -351: 
            case -350: 
            case -99: 
            case -98: 
            case 31: 
            case 41: {
                int n2 = this.sqltype[n];
                if (-99 == this.sqltype[n]) {
                    n2 = 41;
                } else if (-98 == this.sqltype[n]) {
                    n2 = 31;
                } else if (-350 == this.sqltype[n]) {
                    n2 = -351;
                }
                int n3 = (int)this.getElement((int)n).lValue;
                inputStream = new DB2InputStream(this.resultset.statement, n3, n2, false);
                this.resultset.addIsList((DB2InputStream)inputStream);
                break;
            }
            default: {
                inputStream = new ByteArrayInputStream(this.getBytes(n));
            }
        }
        return inputStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int fetchScroll(int n) throws SQLException {
        int n2;
        int n3 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "fetchScroll( " + n + " )");
            }
            this.resultset.clearWarnings();
            if (this.cleared) {
                this.activate();
            }
            int n4 = ((DB2ScrollableResultSet)this.resultset).getNumRows();
            if (n < 1) {
                this.currentRow = 0;
            } else if (n > n4) {
                this.currentRow = n4 + 1;
            } else if (n >= this.firstFetchedRow && n <= this.firstFetchedRow + this.numFetchedRows - 1) {
                this.currentRow = n;
            } else {
                n2 = 0;
                int n5 = 1;
                boolean bl = false;
                int n6 = 0;
                int n7 = 0;
                this.currentRow = n;
                if (this.unboundColumns) {
                    n5 = 1;
                } else if (this.resultset.fetchSize > 0) {
                    n5 = this.resultset.fetchSize;
                } else if (this.statement.CLIBlockSize > 0) {
                    n5 = this.statement.CLIBlockSize;
                }
                if (1 == n5) {
                    n2 = n;
                } else if (n5 >= n4) {
                    n2 = 1;
                } else if (1001 == this.resultset.fetchDirection) {
                    n2 = n - n5 + 1;
                    if (n2 < 1) {
                        n2 = 1;
                    }
                } else {
                    n2 = n;
                    if (n2 + n5 - 1 > n4) {
                        n2 = n4 - n5 + 1;
                    }
                }
                if (this.fetchedRows != null) {
                    int n8 = n2 + n5 - 1;
                    int n9 = this.firstFetchedRow + this.numFetchedRows - 1;
                    if (n2 >= this.firstFetchedRow && n2 <= n9) {
                        n6 = n9 - n2 + 1;
                        n2 += n6;
                        n5 -= n6;
                    } else if (n8 >= this.firstFetchedRow && n8 <= n9) {
                        n7 = n8 - this.firstFetchedRow + 1;
                        n5 -= n7;
                    }
                }
                try {
                    DB2Request dB2Request = this.db2req;
                    synchronized (dB2Request) {
                        this.db2req.write((short)203);
                        this.db2req.write(this.resultset.stmtHandle);
                        this.db2req.write(n2);
                        this.db2req.write(n5);
                        this.db2req.sendAndRecv();
                        n3 = this.getDataFromBuffer(n2, n5, n6, n7);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    this.sqlExcptGen.socketException("08S01a");
                }
            }
            n2 = n3;
            Object var13_14 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(100, "currentRow", this.currentRow);
            DB2Trace.methodExit((Object)this, "fetchScroll()", n3);
            throw throwable;
        }
        DB2Trace.data(100, "currentRow", this.currentRow);
        DB2Trace.methodExit((Object)this, "fetchScroll()", n3);
        return n2;
    }

    protected int previous() throws SQLException {
        return this.fetchScroll(this.currentRow - 1);
    }

    protected int absolute(int n) throws SQLException {
        return this.fetchScroll(n);
    }

    protected int relative(int n) throws SQLException {
        return this.fetchScroll(this.currentRow + n);
    }

    protected int first() throws SQLException {
        return this.fetchScroll(1);
    }

    protected Reader getCharacterStream(int n) throws SQLException {
        Reader reader = null;
        if (this.elementIsNull(n)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        short s = this.sqltype[n];
        int n2 = 41;
        if (-99 == s || -350 == s) {
            switch (s) {
                case -99: {
                    n2 = 41;
                    break;
                }
                case -350: {
                    n2 = -351;
                }
            }
            int n3 = (int)this.getElement((int)n).lValue;
            reader = new DB2CharReader(this.resultset.statement, n3, n2);
        } else {
            String string = this.resultset.getString(n + 1);
            if (this.resultset.nullTag) {
                return null;
            }
            if (string == null) {
                return new StringReader(new String());
            }
            reader = new StringReader(string);
        }
        return reader;
    }

    protected DB2Clob getClob(int n) throws SQLException {
        DB2Clob dB2Clob = null;
        if (this instanceof DB2OutputParameters) {
            String string = this.getString(n);
            if (null == string) {
                return null;
            }
            dB2Clob = new DB2Clob(string);
        } else {
            if (this.elementIsNull(n)) {
                if (this.resultset != null) {
                    this.resultset.nullTag = true;
                }
                return null;
            }
            if (this.resultset != null) {
                this.resultset.nullTag = false;
            }
            short s = this.sqltype[n];
            int n2 = 41;
            if (-99 == s || -350 == s) {
                switch (s) {
                    case -99: {
                        n2 = 41;
                        break;
                    }
                    case -350: {
                        n2 = -351;
                    }
                }
                int n3 = (int)this.getElement((int)n).lValue;
                dB2Clob = new DB2Clob(this.resultset.statement, n3, n2);
            }
        }
        return dB2Clob;
    }

    protected DB2Blob getBlob(int n) throws SQLException {
        DB2Blob dB2Blob = null;
        if (this instanceof DB2OutputParameters) {
            byte[] byArray = this.getBytes(n);
            if (null == byArray) {
                return null;
            }
            dB2Blob = new DB2Blob(byArray);
        } else {
            if (this.elementIsNull(n)) {
                if (this.resultset != null) {
                    this.resultset.nullTag = true;
                }
                return null;
            }
            if (this.resultset != null) {
                this.resultset.nullTag = false;
            }
            int n2 = (int)this.getElement((int)n).lValue;
            dB2Blob = new DB2Blob(this.resultset.statement, n2);
        }
        return dB2Blob;
    }

    protected URL getURL(int n) throws SQLException {
        if (this.elementIsNull(n)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        try {
            return new URL((String)this.getElement((int)n).oValue);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SQLException(malformedURLException.getMessage());
        }
    }
}

