/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jndi;

import COM.ibm.db2.jdbc.DB2DataSource;
import COM.ibm.db2.jndi.DB2NameClassList;
import COM.ibm.db2.jndi.DB2NameClassObjectList;
import COM.ibm.db2.mri.DB2Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;

class DB2Context
implements Context {
    private Hashtable env;
    protected Hashtable bindings = null;
    private File storageFile = null;
    private boolean saveBeforeExit = false;
    private boolean calledByApplet = false;
    private DB2Messages msg = null;
    private String[] tokens = new String[1];
    private static final String DEFAULT_STORAGE_FILENAME = ".db2.jndi";

    DB2Context(Hashtable hashtable) {
        Object object;
        this.env = hashtable != null ? (Hashtable)hashtable.clone() : null;
        this.msg = new DB2Messages();
        try {
            object = System.getProperty("user.home");
            this.storageFile = new File((String)object, DEFAULT_STORAGE_FILENAME);
        }
        catch (SecurityException securityException) {
            this.calledByApplet = true;
        }
        try {
            if (this.calledByApplet) {
                if (hashtable == null) {
                    this.tokens[0] = "java.naming.provider.url";
                    throw new MalformedURLException(this.msg.getString("0636", this.tokens));
                }
                String string = (String)hashtable.get("java.naming.provider.url");
                if (string == null) {
                    System.out.println("DB2Context Environment Properties:");
                    Enumeration enumeration = hashtable.keys();
                    if (!enumeration.hasMoreElements()) {
                        System.out.println("  None");
                    }
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        String string3 = (String)hashtable.get(string2);
                        System.out.println("  " + string2 + " = " + string3);
                    }
                    this.tokens[0] = "java.naming.provider.url";
                    throw new MalformedURLException(this.msg.getString("0636", this.tokens));
                }
                URL uRL = new URL(string + "/" + DEFAULT_STORAGE_FILENAME);
                object = uRL.openStream();
            } else {
                object = new FileInputStream(this.storageFile);
            }
            ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
            try {
                if (((InputStream)object).available() > 0) {
                    this.bindings = (Hashtable)objectInputStream.readObject();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println(classNotFoundException.toString());
            }
            objectInputStream.close();
            ((InputStream)object).close();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            this.bindings = new Hashtable(11);
        }
    }

    public Object lookup(String string) throws NamingException {
        if (string.equals("")) {
            return new DB2Context(this.env);
        }
        Object v = this.bindings.get(string);
        if (v == null) {
            this.tokens[0] = string;
            throw new NameNotFoundException(this.msg.getString("0637", this.tokens));
        }
        return this.dereference(v);
    }

    protected Object dereference(Object object) {
        if (object instanceof Reference) {
            Object object2 = null;
            try {
                object2 = NamingManager.getObjectInstance(object, null, this, this.env);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
            return object2;
        }
        return object;
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String string, Object object) throws NamingException {
        if (this.calledByApplet) {
            this.tokens[0] = "bind()";
            throw new OperationNotSupportedException(this.msg.getString("0635", this.tokens));
        }
        if (string.equals("")) {
            throw new InvalidNameException(this.msg.getString("0639"));
        }
        if (this.bindings.get(string) != null) {
            this.tokens[0] = string;
            throw new NameAlreadyBoundException(this.msg.getString("0638", this.tokens));
        }
        this.bindings.put(string, ((DB2DataSource)object).getReference());
        this.saveBeforeExit = true;
    }

    public void bind(Name name, Object object) throws NamingException {
        this.bind(name.toString(), object);
    }

    public void rebind(String string, Object object) throws NamingException {
        if (this.calledByApplet) {
            this.tokens[0] = "rebind()";
            throw new OperationNotSupportedException(this.msg.getString("0635", this.tokens));
        }
        if (string.equals("")) {
            throw new InvalidNameException(this.msg.getString("0639"));
        }
        this.bindings.put(string, ((DB2DataSource)object).getReference());
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.rebind(name.toString(), object);
    }

    public void unbind(String string) throws NamingException {
        if (this.calledByApplet) {
            this.tokens[0] = "unbind()";
            throw new OperationNotSupportedException(this.msg.getString("0635", this.tokens));
        }
        if (string.equals("")) {
            throw new InvalidNameException(this.msg.getString("0639"));
        }
        this.bindings.remove(string);
        this.saveBeforeExit = true;
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String string, String string2) throws NamingException {
        if (this.calledByApplet) {
            this.tokens[0] = "rename()";
            throw new OperationNotSupportedException(this.msg.getString("0635", this.tokens));
        }
        if (string.equals("") || string2.equals("")) {
            throw new InvalidNameException(this.msg.getString("0639"));
        }
        if (this.bindings.get(string2) != null) {
            this.tokens[0] = string2;
            throw new NameAlreadyBoundException("0638");
        }
        Object v = this.bindings.remove(string);
        if (v == null) {
            this.tokens[0] = string;
            throw new NameNotFoundException(this.msg.getString("0637", this.tokens));
        }
        this.bindings.put(string2, v);
        this.saveBeforeExit = true;
    }

    public void rename(Name name, Name name2) throws NamingException {
        this.rename(name.toString(), name2.toString());
    }

    public NamingEnumeration list(String string) throws NamingException {
        if (string.equals("")) {
            return new DB2NameClassList(this.bindings);
        }
        Object object = this.lookup(string);
        if (object instanceof Context) {
            return ((Context)object).list("");
        }
        this.tokens[0] = string;
        throw new NotContextException(this.msg.getString("0640", this.tokens));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (string.equals("")) {
            return new DB2NameClassObjectList(this);
        }
        Object object = this.lookup(string);
        if (object instanceof Context) {
            return ((Context)object).listBindings("");
        }
        this.tokens[0] = string;
        throw new NotContextException(this.msg.getString("0640", this.tokens));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String string) throws NamingException {
        this.tokens[0] = "destroySubcontext()";
        throw new OperationNotSupportedException(this.msg.getString("0626", this.tokens));
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String string) throws NamingException {
        this.tokens[0] = "createSubcontext()";
        throw new OperationNotSupportedException(this.msg.getString("0626", this.tokens));
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String string) throws NamingException {
        this.tokens[0] = "getNameParser()";
        throw new OperationNotSupportedException(this.msg.getString("0626", this.tokens));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String string, String string2) throws NamingException {
        Name name = this.composeName(new CompositeName(string), new CompositeName(string2));
        return name.toString();
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (this.env == null) {
            this.env = new Hashtable(5, 0.75f);
        }
        return this.env.put(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.env == null) {
            return null;
        }
        return this.env.remove(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.env == null) {
            this.env = new Hashtable(3, 0.75f);
        }
        return this.env;
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    public void close() throws NamingException {
        if (!this.calledByApplet && this.saveBeforeExit) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.storageFile);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this.bindings);
                objectOutputStream.flush();
                objectOutputStream.close();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println(iOException.toString());
            }
        }
        this.env = null;
        this.bindings = null;
    }
}

