/*
 *  Copyright 2008-2010 biaoping.yin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.frameworkset.http.converter.feed;

import org.frameworkset.http.MediaType;
import org.frameworkset.util.annotations.ValueConstants;

import com.sun.syndication.feed.atom.Feed;

/**
 * Implementation of {@link converter.HttpMessageConverter} that can read and write Atom feeds.
 * Specifically, this converter can handle {@link Feed} objects, from the <a href="https://rome.dev.java.net/">ROME</a>
 * project.
 *
 * <p>By default, this converter reads and writes the media type ({@code application/atom+xml}). This can
 * be overridden by setting the {@link #setSupportedMediaTypes(java.util.List) supportedMediaTypes} property.
 *
 * @author Arjen Poutsma
 * @see Feed
 * @since 3.0.2
 */
public class AtomFeedHttpMessageConverter extends AbstractWireFeedHttpMessageConverter<Feed> {

	public AtomFeedHttpMessageConverter() {
		super(new MediaType("application", "atom+xml"));
	}

	@Override
	public boolean supports(Class<?> clazz) {
		return Feed.class.isAssignableFrom(clazz);
	}

	 
	public boolean canWrite(String datatype) {
		// TODO Auto-generated method stub
		if(datatype == null)
			return false;
		
		if(datatype.equals(ValueConstants.datatype_atom))
				return true;
		else
			return false;
	}
	public   boolean canWrite(MediaType mediaType)
	{
		return true;
	}
}
