/*!
 * FEA v1.4.0 (http://dev.asthis.net/fea)
 * Copyright 2015-2016 AsThis
 * Licensed under MIT (http://dev.asthis.net/fea/LICENSE)
 */
if(typeof jQuery === 'undefined') {
	throw new Error('FEA\'s JavaScript requires jQuery');
}

(function (global, $, doc) {
	'use strict';

	var FEA = $.FEA || {}, $html = $('html'), $win = $(window);

	FEA.version = '1.4.0';

	FEA.langdirection = $html.attr('dir') === 'rtl' ? 'right' : 'left';

	FEA.support = {};
	FEA.support.touch = (
		('ontouchstart' in window && navigator.userAgent.toLowerCase().match(/mobile|tablet/)) ||
		(global.DocumentTouch && document instanceof global.DocumentTouch)  ||
		(global.navigator.msPointerEnabled && global.navigator.msMaxTouchPoints > 0) || //IE 10
		(global.navigator.pointerEnabled && global.navigator.maxTouchPoints > 0) || //IE >=11
		false
	);
	FEA.support.transition = (function() {
		var transitionEnd = (function() {
			var element = doc.body || doc.documentElement,
				transEndEventNames = {
					WebkitTransition: 'webkitTransitionEnd',
					MozTransition: 'transitionend',
					OTransition: 'oTransitionEnd otransitionend',
					transition: 'transitionend'
				}, name;
			for(name in transEndEventNames) {
				if(element.style[name] !== undefined) {
					return transEndEventNames[name];
				}
			}
		}());
		return transitionEnd && { end: transitionEnd };
	})();
	FEA.support.translate3d = (function() {
		var translate3D = 'translate3d(0px, 0px, 0px)',
			tempElem = document.createElement('div'),
			regex = /translate3d\(0px, 0px, 0px\)/g,
			asSupport;

		tempElem.style.cssText = '-moz-transform:' + translate3D +
			'; -ms-transform:' + translate3D +
			'; -o-transform:' + translate3D +
			'; -webkit-transform:' + translate3D +
			'; transform:' + translate3D;
		asSupport = tempElem.style.cssText.match(regex);
		return (asSupport !== null && asSupport.length === 1);
	})();
	FEA.support.animation = (function() {
		var animationEnd = (function() {
			var element = doc.body || doc.documentElement,
				animEndEventNames = {
					WebkitAnimation: 'webkitAnimationEnd',
					MozAnimation: 'animationend',
					OAnimation: 'oAnimationEnd oanimationend',
					animation: 'animationend'
				}, name;
			for(name in animEndEventNames) {
				if(element.style[name] !== undefined) {
					return animEndEventNames[name];
				}
			}
		}());
		return animationEnd && { end: animationEnd };
	})();

	FEA.utils = {};
	FEA.utils.options = function (string) {
		if($.isPlainObject(string)) {
			return string;
		}
		var start = (string ? string.indexOf('{') : -1), options = {};
		if(start !== -1) {
			try {
				options = (new Function('',
					'var json = ' + string.substr(start) + ';' +
					'if("undefined" == typeof(JSON)) { return json; }' +
					'else { return JSON.parse(JSON.stringify(json)); }'))();
			} catch (e) { }
		}
		return options;
	};
	FEA.utils.isInView = function(element, options) {
		var $element = element;

		if(!$element.is(':visible')) {
			return false;
		}

		var windowLeft = $win.scrollLeft(),
			windowTop = $win.scrollTop(),
			position = $element.position(),
			offset = $element.offset(),
			$parent = $element.parent();

		options = $.extend({topoffset:0, leftoffset:0}, options);

		if($parent.hasClass('scrollable-box')) {
			if(position.left >= 0 &&
				position.top >= 0 &&
				position.top + $element.height() <= $parent.height() &&
				position.left + $element.width() <= $parent.width()) {
				return true;
			}
			else {
				return false;
			}
		}
		else {
			if(offset.top + $element.height() >= windowTop &&
				offset.top - options.topoffset <= windowTop + $win.height() &&
				offset.left + $element.width() >= windowLeft &&
				offset.left - options.leftoffset <= windowLeft + $win.width()) {
				return true;
			}
			else {
				return false;
			}
		}
	};

	$.FEA = FEA;

}(window, jQuery, window.document));

(function ($, FEA) {
	'use strict';

	// Class
	var Alert = function (element, options) {
		var base = this;

		base.element = element;
		base.options = $.extend({}, Alert.defaults, options);
		base.element.on('click', base.options.trigger, function (e) {
			base.close();
			e.preventDefault();
		});
	};

	Alert.defaults = {
		'fade' : true,
		'duration' : 200,
		'trigger' : '.alert-close'
	};

	Alert.prototype.close = function () {
		var element = this.element;

		if(this.options.fade) {
			element.css('overflow', 'hidden')
				.css('max-height', element.height())
				.animate({
				'height': 0,
				'opacity': 0,
				'padding-top': 0,
				'padding-bottom': 0,
				'margin-top': 0,
				'margin-bottom': 0
			}, this.options.duration, removeElement);
		}
		else {
			removeElement();
		}

		function removeElement() {
			element.remove();
		}
	};

	// Plugin
	var old = $.fn.alert;
	$.fn.alert = function (option) {
		return this.each(function () {
			var $this = $(this),
				data = $this.data('alert'),
				options = typeof option === 'object' && option;

			if(!data) {
				$this.data('alert', (data = new Alert($this, options)));
			}
		});
	};
	// for common use
	$.fn.alert.Constructor = Alert;
	// no conflict
	$.fn.alert.noConflict = function () {
		$.fn.alert = old;
		return this;
	};

	// Data API
	$(document).ready(function () {
		$('[data-alert]').each(function () {
			var element = $(this);
			new Alert(element, FEA.utils.options(element.data('alert')));
		});
	});
}(jQuery, jQuery.FEA));

(function ($, FEA) {
	'use strict';

	// Class
	var Dropdown = function (element, options) {
		var base = this,
			remainIdle = false;

		base.element = element;
		base.options = $.extend({}, Dropdown.defaults, options);
		base.target = base.element.find('.dropdown');
		base.centered = base.target.hasClass('dropdown-center');
		base.justified = base.options.justify ? $(base.options.justify) : false;

		var isDisabled = base.element.children().first().hasClass('disabled') || base.element.children().first().is('[disabled]');
		if(isDisabled) {
			return;
		}

		if(base.element.children().first().is('a') &&
			('#' === base.element.children().first().attr('href') || '' === base.element.children().first().attr('href')) ) {
			base.element.children().first().on('click', function (e) {
				e.preventDefault();
			});
		}

		if('click' === base.options.mode) {
			base.element.on('click', function (e) {
				base.show();
				$(document).one('click', function () {
					base.target.hide();
				});
				e.stopPropagation();
			});
		}
		else {
			remainIdle = setTimeout(function () {
				base.show();
			}, base.options.remaintime);

			base.element.on('mouseleave', function () {
				clearTimeout(remainIdle);
				remainIdle = setTimeout(function () {
					base.target.hide();
				}, base.options.remaintime);
			}).children().on('mouseenter', function () {
				clearTimeout(remainIdle);
			});
		}
	};

	Dropdown.defaults = {
		'mode' : 'hover',
		'remaintime' : 200,
		'justify' : false
	};

	Dropdown.prototype.show = function () {
		var target  = this.target.css('margin-left', '').css('min-width', ''),
			offset = target.show().offset(),
			width = target.outerWidth();

		// centered dropdown
		if(this.centered) {
			var marginDerection = ($.FEA.langdirection === 'right') ? 'margin-right' : 'margin-left';
			target.css(marginDerection,
				(parseFloat(width) / 2 - target.parent().width() / 2) * -1);
			offset = target.offset();

			// reset dropdown
			if(offset.left < 0) {
				target.css('margin-left', '');
				offset = target.offset();
			}
		}

		// justify dropdown
		if(this.justified && this.justified.length) {
			var jwidth = this.justified.outerWidth();

			target.css('min-width', jwidth);
			target.css('margin-left', this.justified.offset().left - offset.left);

			offset = target.offset();
		}
	};

	// Plugin
	var old = $.fn.dropdown;
	$.fn.dropdown = function (option) {
		return this.each(function () {
			var $this = $(this),
				data = $this.data('dropdown'),
				options = typeof option === 'object' && option;

			if(!data) {
				$this.data('dropdown', (data = new Dropdown($this, options)));
			}
		});
	};
	// for common use
	$.fn.dropdown.Constructor = Dropdown;
	// no conflict
	$.fn.dropdown.noConflict = function () {
		$.fn.dropdown = old;
		return this;
	};

	// Data API
	$(document).on('mouseenter.dropdown.FEA', '[data-dropdown]', function () {
		var element = $(this);
		new Dropdown(element, FEA.utils.options(element.data('dropdown')));
	});
}(jQuery, jQuery.FEA));

(function ($, FEA) {
	'use strict';

	// Class
	var InputPassword = function (element, options) {
		var base = this;

		base.element = element;
		base.options = $.extend({}, InputPassword.defaults, options);
		base.input = base.element.find('input');

		base.init();

		base.txt.on('click', function (e) {
			e.preventDefault();
			var type = base.input.attr('type');

			base.input.attr('type', type === 'text' ? 'password' : 'text');
			base.txt.html(base.options[type === 'text' ? 'txtHide' : 'txtShow']);
		});
	};

	InputPassword.prototype.init = function() {
		var base = this,
			type = base.input.attr('type');

		base.txt = $('<span />').addClass(base.options.txtCls).html(base.options[type === 'text' ? 'txtShow' : 'txtHide']);
		base.element.append(base.txt);

		var paddingName = $.FEA.langdirection === 'right' ? 'padding-left' : 'padding-right',
			paddingVal = parseFloat(base.input.css(paddingName)) * 2 + base.txt.width();

		base.input.css(paddingName, paddingVal + 'px');
	};
	InputPassword.defaults = {
		txtShow: '<i class="icon-eye"></i>',
		txtHide: '<i class="icon-eye-close"></i>',
		txtCls: 'input-password-toggle'
	};

	// Plugin
	var oldInputPassword = $.fn.inputPassword;
	$.fn.inputPassword = function (option) {
		return this.each(function () {
			var $this = $(this),
				data = $this.data('inputPassword'),
				options = typeof option === 'object' && option;

			if(!data) {
				$this.data('inputPassword', (data = new InputPassword($this, options)));
			}
		});
	};
	// for common use
	$.fn.inputPassword.Constructor = InputPassword;
	// no conflict
	$.fn.inputPassword.noConflict = function () {
		$.fn.inputPassword = oldInputPassword;
		return this;
	};

	// Data API
	$(document).ready(function () {
		$('[data-input-password]').each(function () {
			var element = $(this);
			new InputPassword(element, FEA.utils.options(element.data('inputPassword')));
		});
	});

	// Class
	var InputSelect = function (element, options) {
		var base = this;

		base.element = element;
		base.options = $.extend({}, InputSelect.defaults, options);
		base.select = base.element.find('select');
		base.target = base.element.find(base.options.target);

		base.process();

		base.select.on('change', function () {
			base.process();
		});
	};

	InputSelect.prototype.process = function() {
		var base = this,
			select = base.select[0],
			selectedVal = select.options[select.selectedIndex].text;

		try {
			if(base.options.target === 'input') {
				base.target.val(selectedVal);
			}
			else {
				base.target.text(selectedVal);
			}
		} catch(e) {}

		base.element[base.select.val() ? 'addClass':'removeClass'](base.options.activeCls);
	};
	InputSelect.defaults = {
		target: '>span:first',
		activeCls: 'active'
	};

	// Plugin
	var oldInputSelect = $.fn.inputSelect;
	$.fn.inputSelect = function (option) {
		return this.each(function () {
			var $this = $(this),
				data = $this.data('inputSelect'),
				options = typeof option === 'object' && option;

			if(!data) {
				$this.data('inputSelect', (data = new InputSelect($this, options)));
			}
		});
	};
	// for common use
	$.fn.inputSelect.Constructor = InputSelect;
	// no conflict
	$.fn.inputSelect.noConflict = function () {
		$.fn.inputSelect = oldInputSelect;
		return this;
	};

	// Data API
	$(document).ready(function () {
		$('[data-input-select]').each(function () {
			var element = $(this);
			new InputSelect(element, FEA.utils.options(element.data('inputSelect')));
		});
	});
}(jQuery, jQuery.FEA));

(function ($, FEA) {
	'use strict';

	// Class
	var Nav = function (element, options) {
		var base = this;

		base.element = element;
		base.options = $.extend({}, Nav.defaults, options);
		base.element.on('click', '> li.nav-parent > a[href="#"]', function (e) {
			var $parent = $(this).parent(),
				isOpen = $parent.hasClass('open');

			if(!base.options.multiple) {
				base.element.find('> li.nav-parent').removeClass('open');
			}

			if(isOpen) {
				$parent.removeClass('open');
			}
			else {
				$parent.addClass('open');
			}
			e.preventDefault();
		});
	};

	Nav.defaults = {
		'multiple' : false
	};

	// Plugin
	var old = $.fn.nav;
	$.fn.nav = function (option) {
		return this.each(function () {
			var $this = $(this),
				data = $this.data('nav'),
				options = typeof option === 'object' && option;

			if(!data) {
				$this.data('nav', (data = new Nav($this, options)));
			}
		});
	};
	// for common use
	$.fn.nav.Constructor = Nav;
	// no conflict
	$.fn.nav.noConflict = function () {
		$.fn.nav = old;
		return this;
	};

	// Data API
	$(document).ready(function () {
		$('[data-nav]').each(function () {
			var element = $(this);
			new Nav(element, FEA.utils.options(element.data('nav')));
		});
	});
}(jQuery, jQuery.FEA));

(function ($, FEA) {
	'use strict';

	// ScrollSpy Class
	var ScrollSpy = function (element, options) {
		var base = this, $win = $(window);

		base.element = element;
		base.options = $.extend({}, ScrollSpy.defaults, options);

		this.element.on('scroll.scrollspy.FEA', function () {
			base.process();
		});
		$win.on('scroll.scrollspy.FEA', function () {
			base.process();
		});
	};

	ScrollSpy.defaults = {
		'target' : false,
		'cls' : 'scrollspy-inview',
		'repeat' : false,
		'delay' : 0
	};

	ScrollSpy.prototype.process = function () {
		var base = this,
			elements = base.options.target ? base.element.css('opacity', '1').find(base.options.target) : base.element,
			delayIdx = elements.length === 1 ? 1 : 0;

		elements.each(function() {
			var element = $(this);
			if(base.options.target) {
				element.css('opacity', '0');
			}
			if(FEA.utils.isInView(element)) {
				setTimeout(function(){ element.addClass(base.options.cls); }, base.options.delay * delayIdx);
				delayIdx++;
			}
			else if(base.options.repeat) {
				element.removeClass(base.options.cls);
			}
		});
	};

	// Plugin
	var oldScrollspy = $.fn.scrollspy;
	$.fn.scrollspy = function (option) {
		return this.each(function () {
			var $this = $(this),
				data = $this.data('scrollspy'),
				options = typeof option === 'object' && option;

			if(!data) {
				$this.data('scrollspy', (data = new ScrollSpy($this, options)));
			}
		});
	};
	// for common use
	$.fn.scrollspy.Constructor = ScrollSpy;
	// no conflict
	$.fn.scrollspy.noConflict = function () {
		$.fn.scrollspy = oldScrollspy;
		return this;
	};

	// ScrollNav Class
	var ScrollNav = function (element, options) {
		var base = this, $win = $(window);

		base.element = element;
		base.options = $.extend({}, ScrollNav.defaults, options);

		this.element.on('scroll.scrollnav.FEA', function () {
			base.process();
		});
		$win.on('scroll.scrollnav.FEA', function () {
			base.process();
		});
	};

	ScrollNav.defaults = {
		'activeCls' : 'active',
		'target' : false,
		'closest' : 'li',
		'offset' : 10
	};

	ScrollNav.prototype.process = function () {
		var spyIds = [],
			links = $(this.options.target).find('a[href^="#"]').each(function () {
				if('#' !== $(this).attr('href')) {
					spyIds.push($(this).attr('href'));
				}
			}),
			$spyIds = $(spyIds.join(','));

		if(!$spyIds.length) {
			return;
		}

		var inviews = [];
		for(var i = 0 ; i < $spyIds.length ; i++) {
			if(FEA.utils.isInView($spyIds.eq(i))) {
				inviews.push($spyIds.eq(i));
			}
		}

		if(!inviews.length) {
			return;
		}

		var base = this, $win = $(window),
			scrollTop,
			target = (function () {
				for(var i = 0; i < inviews.length; i++) {
					if(inviews[i].parent().hasClass('scrollable-box')) {
						scrollTop = inviews[i].parent().position().top;
						if(inviews[i].position().top - base.options.offset <= 0) {
							return inviews[i];
						}
					}
					else {
						scrollTop = $win.scrollTop();
						if(inviews[i].offset().top - base.options.offset <= scrollTop) {
							return inviews[i];
						}
					}
				}
			})();

		if(!target) {
			return;
		}

		if(base.options.closest) {
			links.closest(base.options.closest).removeClass(base.options.activeCls).end().filter('a[href="#' + target.attr('id') + '"]').closest(base.options.closest).addClass(base.options.activeCls);
		}
		else {
			links.removeClass(base.options.activeCls).filter('a[href="#' + target.attr('id') + '"]').addClass(base.options.activeCls);
		}
	};

	// Plugin
	var oldScrollnav = $.fn.scrollnav;
	$.fn.scrollnav = function (option) {
		return this.each(function () {
			var $this = $(this),
				data = $this.data('scrollnav'),
				options = typeof option === 'object' && option;

			if(!data) {
				$this.data('scrollnav', (data = new ScrollNav($this, options)));
			}
		});
	};
	// for common use
	$.fn.scrollnav.Constructor = ScrollNav;
	// no conflict
	$.fn.scrollnav.noConflict = function () {
		$.fn.scrollnav = oldScrollnav;
		return this;
	};

	// Data API
	$(document).ready(function () {
		$('[data-scrollspy]').each(function () {
			var element = $(this);
			new ScrollSpy(element, FEA.utils.options(element.data('scrollspy')));
		});
		$('[data-scrollnav]').each(function () {
			var element = $(this);
			new ScrollNav(element, FEA.utils.options(element.data('scrollnav')));
		});
	});
}(jQuery, jQuery.FEA));

(function ($, FEA) {
	'use strict';

	// Class
	var SmoothScroll = function (element, options) {
		var base = this;

		base.element = element;
		base.options = $.extend({}, SmoothScroll.defaults, options);

		this.element.on('click', function () {
			var ele = ($(this.hash).length ? $(this.hash) : $('body')),
				target = ele.offset().top - base.options.offset,
				docheight = $(document).height(),
				winheight = $(window).height();

			if((target + winheight) > docheight) {
				target = docheight - winheight;
			}
			$('html,body').stop().animate({ scrollTop: target }, base.options.duration, base.options.transition);

			return false;
		});
		this.element.trigger('click');
	};

	SmoothScroll.defaults = {
		'duration' : 1000,
		'transition' : 'easeOutExpo',
		'offset' : 0
	};

	if(!$.easing.easeOutExpo) {
		$.easing.easeOutExpo = function (x, t, b, c, d) { return (t === d) ? b + c : c * (-Math.pow(2, -10 * t / d) + 1) + b; };
	}

	// Plugin
	var old = $.fn.smoothScroll;
	$.fn.smoothScroll = function (option) {
		return this.each(function () {
			var $this = $(this),
				data = $this.data('smooth-scroll'),
				options = typeof option === 'object' && option;

			if(!data) {
				$this.data('smooth-scroll', (data = new SmoothScroll($this, options)));
			}
		});
	};
	// for common use
	$.fn.smoothScroll.Constructor = SmoothScroll;
	// no conflict
	$.fn.smoothScroll.noConflict = function () {
		$.fn.smoothScroll = old;
		return this;
	};

	// Data API
	$(document).on('click.smooth-scroll.FEA', '[data-smooth-scroll]', function () {
		var element = $(this);
		new SmoothScroll(element, FEA.utils.options(element.data('smoothScroll')));
	});
}(jQuery, jQuery.FEA));

(function ($, FEA) {
	'use strict';

	var sticked = [],
		$window = $(window),
		$document = $(document),
		windowHeight = $window.height(),

		scroller = function () {
			var scrollTop = $window.scrollTop(),
				documentHeight = $document.height(),
				dwh = documentHeight - windowHeight,
				extra = (scrollTop > dwh) ? dwh - scrollTop : 0,
				sticky, elementTop, newTop, containerBottom, etse, stickyHeight;

			for(var i = 0; i < sticked.length; i++) {
				sticky = sticked[i];
				if(!sticky.stickyElement.is(':visible')) {
					continue;
				}

				if(sticky.top < 0) {
					newTop = 0;
				}
				else {
					stickyHeight = sticky.stickyElement.outerHeight();
					newTop = documentHeight - stickyHeight - sticky.top - scrollTop - extra;
					newTop = newTop < 0 ? newTop + sticky.top : sticky.top;
				}

				if(sticky.boundary && sticky.boundary.length) {
					var bTop = sticky.boundary.offset().top;
					if(sticky.boundtoparent) {
						containerBottom = documentHeight - (bTop + sticky.boundary.outerHeight() - parseInt(sticky.boundary.css('padding-bottom')));
					}
					else {
						//containerBottom = documentHeight - (bTop - parseInt(sticky.boundary.css('margin-top')));
						containerBottom = documentHeight - (bTop);
					}
					newTop = (scrollTop + stickyHeight) > (documentHeight - containerBottom - (sticky.top < 0 ? 0 : sticky.top)) ?
						(documentHeight - containerBottom) - (scrollTop + stickyHeight) :
						newTop;
				}

				elementTop = sticky.stickyWrapper.offset().top, etse = elementTop - sticky.top - extra;
				if(scrollTop <= etse) {
					if(sticky.currentTop !== null) {
						sticky.stickyElement.css({ 'position': '', 'top': '', 'width': '' }).parent().removeClass(sticky.clsactive);
						sticky.currentTop = null;
					}
				}
				else {
					if(sticky.currentTop !== newTop) {
						var _w = (sticky.stickyElement.css('box-sizing') === 'border-box') ? sticky.stickyElement.outerWidth() : sticky.stickyElement.width();
						sticky.stickyElement.css({ 'position': 'fixed', 'top': newTop, 'width':  _w});
						if(sticky.getWidthFrom !== null) {
							sticky.stickyElement.css('width', $(sticky.getWidthFrom).width());
						}

						sticky.stickyElement.parent().addClass(sticky.clsactive);
						sticky.currentTop = newTop;
					}
				}
			}
		},

		resizer = function () {
			windowHeight = $window.height();
		};

	// Class
	var Sticky = function (element, options) {
		var base = this;

		base.element = element;
		base.options = $.extend({}, Sticky.defaults, options);

		if(!base.check(base.options)) {
			return;
		}

		var stickyId = base.element.attr('id') || ('s' + Math.ceil(Math.random() * 10000)),
			wrapper = $('<div></div>').attr('id', 'sticky-' + stickyId).addClass(base.options.clswrapper).css( { 'z-index': base.options.zindex } );

		base.element.css({ 'z-index': base.options.zindex + 1 }).wrapAll(wrapper);

		if(base.element.css('float') === 'right') {
			base.element.css({ 'float': 'none'}).parent().css({ 'float': 'right' });
		}

		var stickyWrapper = base.element.parent(),
			_h = (base.element.css('box-sizing') === 'border-box') ? base.element.outerHeight() : base.element.height();
		stickyWrapper.css('height', _h);

		var boundary = base.options.boundary, boundtoparent = false;
		if(base.options.boundary) {
			if(base.options.boundary === true) {
				boundary = stickyWrapper.parent();
				boundtoparent = true;
			}
			else if(typeof base.options.boundary === 'string') {
				boundary = $(boundary);
			}
		}
		sticked.push({
			media: base.options.media,
			top: base.options.top,
			stickyElement: base.element,
			currentTop: null,
			stickyWrapper: stickyWrapper,
			clsactive: base.options.clsactive,
			getWidthFrom: base.options.getWidthFrom,
			boundary: boundary,
			boundtoparent: boundtoparent
		});

	};

	Sticky.defaults = {
		'disabled' : false,
		'media' : false,
		'zindex' : 1015,
		'top' : 0,
		'clsactive' : 'active',
		'clswrapper' : 'sticky',
		'getWidthFrom' : null,
		'boundary' : false
	};

	Sticky.prototype.check = function(option) {
		if (option.disabled) {
			return false;
		}
		// check media
		if(option.media) {
			switch(typeof(option.media)) {
				case 'number':
					if (window.innerWidth < option.media) {
						return false;
					}
					break;
				case 'string':
					if(window.matchMedia && !window.matchMedia(option.media).matches) {
						return false;
					}
				break;
			}
		}
		return true;
	};

	// Plugin
	var old = $.fn.sticky;
	$.fn.sticky = function (option) {
		return this.each(function () {
			var $this = $(this),
				data = $this.data('sticky'),
				options = typeof option === 'object' && option;

			if(!data) {
				$this.data('sticky', (data = new Sticky($this, options)));
			}
		});
	};
	$.fn.sticky.noConflict = function () {
		$.fn.sticky = old;
		return this;
	};
	// for common use
	$.fn.sticky.Constructor = Sticky;

	if(window.addEventListener) {
		window.addEventListener('scroll', scroller, false);
		window.addEventListener('resize', resizer, false);
	}
	else if(window.attachEvent) {
		window.attachEvent('onscroll', scroller);
		window.attachEvent('onresize', resizer);
	}

	$(document).ready(function () {
		setTimeout(function () {
			scroller();
			$('[data-sticky]').each(function () {
				var element = $(this);
				new Sticky(element, FEA.utils.options(element.data('sticky')));
			});
		}, 0);
	});
}(jQuery, jQuery.FEA));

(function ($, FEA) {
	'use strict';

	// Class
	var Switcher = function (element, options) {
		var base = this, active, toggles;

		base.element = element;
		base.options = $.extend({}, Switcher.defaults, options);

		if(window.location.hash) {
			active = base.element.children().filter(window.location.hash);
			if(active.length) {
				base.show(active);
			}
		}
		else {
			toggles = base.element.find(base.options.toggle);
			active = base.element.find(base.options.toggle).filter('active');
			if(active.length) {
				base.show(active);
			}
			else {
				active = toggles.eq(base.options.active);
				base.show(active.length ? active : toggles.eq(0));
			}
		}

		base.element.on('click', base.options.toggle, function (e) {
			var isDisabled = $(this).hasClass('disabled');
			if(!isDisabled) {
				base.show($(this));
			}
			e.preventDefault();
		});
	};

	Switcher.defaults = {
		'connect' : false,
		'toggle' : '>*',
		'active' : 0,
		'animation' : false
	};

	Switcher.prototype.show = function (toggle) {
		toggle.addClass('active').siblings().removeClass('active');
		if(this.options.connect) {
			var animation = this.options.animation;
			$(this.options.connect).each(function() {
				var index = toggle.index(),
					current = $(this).children().eq(index);
				if(animation) {
					current.addClass('animation-' + animation);
				}
				current.addClass('active').siblings().removeClass('active');
			});
		}
	};

	// Plugin
	var old = $.fn.switcher;
	$.fn.switcher = function (option) {
		return this.each(function () {
			var $this = $(this),
				data = $this.data('switcher'),
				options = typeof option === 'object' && option;

			if(!data) {
				$this.data('switcher', (data = new Switcher($this, options)));
			}
		});
	};
	// for common use
	$.fn.switcher.Constructor = Switcher;
	// no conflict
	$.fn.switcher.noConflict = function () {
		$.fn.switcher = old;
		return this;
	};

	// Data API
	$(document).ready(function () {
		$('[data-switcher]').each(function () {
			var element = $(this);
			new Switcher(element, FEA.utils.options(element.data('switcher')));
		});
	});
}(jQuery, jQuery.FEA));

(function ($) {
	'use strict';

	function subnavJustify() {
		$('.subnav-justify').each(function() {
			var itemNum = $(this).children('li').length,
				_w = ($(this).css('box-sizing') === 'border-box') ? $(this).innerWidth() : $(this).width(),
				_wli = Math.floor(_w / itemNum),
				_wlast = _w - _wli * (itemNum - 1);
			$(this).children('li').last().css('width', _wlast + 'px').siblings().css('width', _wli + 'px');
		});
	}

	// Data API
	$(document).ready(function () {
		subnavJustify();
	});
	$(window).resize(function() {
		subnavJustify();
	});
}(jQuery));

(function ($, FEA) {
	'use strict';

	// Class
	var Toggle = function (element, options) {
		var base = this;

		base.element = element;
		base.options = $.extend({}, Toggle.defaults, options);
		base.totoggle = base.options.target ? $(base.options.target) : [];

		base.element.on('click', function (e) {
			base.toggle();
			e.preventDefault();
		});
	};

	Toggle.defaults = {
		'target' : false,
		'toggleCls' : 'hide'
	};

	Toggle.prototype.toggle = function () {
		var base = this;
		if(!base.totoggle.length) {
			return;
		}
		this.totoggle.toggleClass(base.options.toggleCls);
	};


	// Plugin
	var old = $.fn.toggle;
	$.fn.toggle = function (option) {
		return this.each(function () {
			var $this = $(this),
				data = $this.data('toggle'),
				options = typeof option === 'object' && option;

			if(!data) {
				$this.data('toggle', (data = new Toggle($this, options)));
			}
		});
	};
	// for common use
	$.fn.toggle.Constructor = Toggle;
	// no conflict
	$.fn.toggle.noConflict = function () {
		$.fn.toggle = old;
		return this;
	};

	// Data API
	$(document).ready(function () {
		$('[data-toggle]').each(function () {
			var element = $(this);
			new Toggle(element, FEA.utils.options(element.data('toggle')));
		});
	});
}(jQuery, jQuery.FEA));
