/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.cache.local.util;

import java.io.Serializable;
import org.b3log.latke.cache.local.util.DoubleLinkedMapNode;

public final class DoubleLinkedMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int size = 0;
    private DoubleLinkedMapNode<K, V> first;
    private DoubleLinkedMapNode<K, V> last;

    public synchronized boolean remove(K key) {
        DoubleLinkedMapNode<K, V> node = this.getNode(key);
        if (node != null) {
            this.removeNode(node);
            return true;
        }
        return false;
    }

    public synchronized V get(K key) {
        if (this.first == null) {
            return null;
        }
        for (DoubleLinkedMapNode<K, V> current = this.first; current != null; current = current.getNext()) {
            if (!current.getKey().equals(key)) continue;
            return current.getValue();
        }
        return null;
    }

    public synchronized void addLast(K key, V value) {
        DoubleLinkedMapNode<K, V> node = new DoubleLinkedMapNode<K, V>(key, value);
        this.addLastNode(node);
    }

    public synchronized void addFirst(K key, V value) {
        if (null == key) {
            throw new IllegalArgumentException("Key is null!");
        }
        DoubleLinkedMapNode<K, V> node = new DoubleLinkedMapNode<K, V>(key, value);
        this.addFirstNode(node);
    }

    public synchronized void makeFirst(K key) {
        DoubleLinkedMapNode node = this.getNode(key);
        if (node.getPrev() == null) {
            return;
        }
        node.getPrev().setNext(node.getNext());
        if (node.getNext() == null) {
            this.last = node.getPrev();
            this.last.setNext(null);
        } else {
            node.getNext().setPrev(node.getPrev());
        }
        this.first.setPrev(node);
        node.setNext(this.first);
        node.setPrev(null);
        this.first = node;
    }

    public synchronized void removeAll() {
        DoubleLinkedMapNode me = this.first;
        while (me != null) {
            if (me.getPrev() != null) {
                me.setPrev(null);
            }
            DoubleLinkedMapNode<K, V> next = me.getNext();
            me = next;
        }
        this.first = null;
        this.last = null;
        this.size = 0;
    }

    public synchronized V removeLast() {
        DoubleLinkedMapNode<K, V> lastNode = this.removeLastNode();
        if (null != lastNode) {
            return lastNode.getValue();
        }
        return null;
    }

    public synchronized int size() {
        return this.size;
    }

    private synchronized DoubleLinkedMapNode<K, V> removeLastNode() {
        DoubleLinkedMapNode<K, V> ret = this.last;
        if (this.last != null) {
            this.removeNode(this.last);
        }
        return ret;
    }

    private synchronized DoubleLinkedMapNode<K, V> getNode(K key) {
        if (this.first == null) {
            return null;
        }
        for (DoubleLinkedMapNode<K, V> current = this.first; current != null; current = current.getNext()) {
            if (!current.getKey().equals(key)) continue;
            return current;
        }
        return null;
    }

    private synchronized void removeNode(DoubleLinkedMapNode<K, V> node) {
        if (node.getNext() == null) {
            if (node.getPrev() == null) {
                if (node == this.first && node == this.last) {
                    this.first = null;
                    this.last = null;
                }
            } else {
                this.last = node.getPrev();
                this.last.setNext(null);
                node.setPrev(null);
            }
        } else if (node.getPrev() == null) {
            this.first = node.getNext();
            this.first.setPrev(null);
            node.setNext(null);
        } else {
            node.getPrev().setNext(node.getNext());
            node.getNext().setPrev(node.getPrev());
            node.setPrev(null);
            node.setNext(null);
        }
        --this.size;
    }

    private synchronized void addLastNode(DoubleLinkedMapNode<K, V> node) {
        if (this.first == null) {
            this.first = node;
        } else {
            this.last.setNext(node);
            node.setPrev(this.last);
        }
        this.last = node;
        ++this.size;
    }

    private synchronized void addFirstNode(DoubleLinkedMapNode<K, V> node) {
        if (this.last == null) {
            this.last = node;
        } else {
            this.first.setPrev(node);
            node.setNext(this.first);
        }
        this.first = node;
        ++this.size;
    }
}

