/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.cron;

import java.net.URL;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.urlfetch.HTTPRequest;
import org.b3log.latke.urlfetch.URLFetchService;
import org.b3log.latke.urlfetch.URLFetchServiceFactory;

public final class Cron
extends TimerTask {
    private static final Logger LOGGER = Logger.getLogger(Cron.class.getName());
    public static final int SIXTY = 60;
    public static final int THOUSAND = 1000;
    private String url;
    private String description;
    private String schedule;
    private long period;

    public Cron(String url, String description, String schedule) {
        this.url = url;
        this.description = description;
        this.schedule = schedule;
        this.parse(schedule);
    }

    @Override
    public void run() {
        LOGGER.debug("Executing scheduled task....");
        URLFetchService urlFetchService = URLFetchServiceFactory.getURLFetchService();
        HTTPRequest request = new HTTPRequest();
        try {
            request.setURL(new URL(this.url));
            request.setRequestMethod(HTTPRequestMethod.GET);
            urlFetchService.fetchAsync(request);
            LOGGER.log(Level.DEBUG, "Executed scheduled task[url={0}]", this.url);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Scheduled task execute failed", e);
        }
    }

    private void parse(String schedule) {
        int num = Integer.valueOf(StringUtils.substringBetween((String)schedule, (String)" ", (String)" "));
        String timeUnit = StringUtils.substringAfterLast((String)schedule, (String)" ");
        LOGGER.log(Level.TRACE, "Parsed a cron job [schedule={0}]: [num={1}, timeUnit={2}, description={3}], ", schedule, num, timeUnit, this.description);
        if ("hours".equals(timeUnit)) {
            this.period = num * 60 * 60 * 1000;
        } else if ("minutes".equals(timeUnit)) {
            this.period = num * 60 * 1000;
        } else if ("seconds".equals(timeUnit)) {
            this.period = num * 1000;
        }
    }

    public long getPeriod() {
        return this.period;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public String getUrl() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }
}

