/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc.context;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.b3log.latke.ioc.context.LatkeBeansContext;

public abstract class AbstractContext
implements LatkeBeansContext {
    private boolean active;
    private Class<? extends Annotation> scopeType;
    private Map<Contextual<?>, Object> beanReferences;

    public AbstractContext(Class<? extends Annotation> scopeType) {
        this.scopeType = scopeType;
        this.beanReferences = new HashMap();
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public <T> void add(Contextual<T> bean, T reference) {
        this.beanReferences.put(bean, reference);
    }

    public <T> T get(Contextual<T> bean) {
        return this.getReference(bean, null);
    }

    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        return this.getReference(bean, creationalContext);
    }

    private <T> T getReference(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object ret = this.beanReferences.get(bean);
        if (null != ret) {
            return (T)ret;
        }
        ret = bean.create(creationalContext);
        if (null != ret) {
            this.beanReferences.put(bean, ret);
            return (T)ret;
        }
        throw new RuntimeException("Can't create reference for bean[" + bean + "]");
    }

    public <T> void remove(Contextual<T> bean) {
        if (null != this.beanReferences.get(bean)) {
            this.beanReferences.remove(bean);
        }
    }

    public <T> void destroy() {
        Set<Map.Entry<Contextual<?>, Object>> beanSet = this.beanReferences.entrySet();
        Iterator<Map.Entry<Contextual<?>, Object>> i = beanSet.iterator();
        Contextual<?> bean = null;
        while (i.hasNext()) {
            bean = i.next().getKey();
            Object instance = this.beanReferences.get(bean);
            this.destroyReference((Bean)bean, instance);
        }
        this.beanReferences.clear();
    }

    public Class<? extends Annotation> getScope() {
        return this.scopeType;
    }

    private <T> void destroyReference(Bean<T> bean, T beanInstance) {
        bean.destroy(beanInstance, null);
    }
}

