/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc.point;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.b3log.latke.ioc.util.Beans;

public abstract class AbstractInjectionPoint
implements InjectionPoint {
    private Annotated annotated;
    private Bean<?> ownerBean;

    public AbstractInjectionPoint(Bean<?> ownerBean, Annotated annotated) {
        this.ownerBean = ownerBean;
        this.annotated = annotated;
    }

    public Type getType() {
        Type baseType = this.annotated.getBaseType();
        if (baseType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)baseType;
            return parameterizedType.getActualTypeArguments()[0];
        }
        return baseType;
    }

    public Set<Annotation> getQualifiers() {
        Set annotations = this.annotated.getAnnotations();
        HashSet ret = Beans.selectQualifiers(annotations);
        return ret == null ? new HashSet() : ret;
    }

    public Bean<?> getBean() {
        return this.ownerBean;
    }

    public Annotated getAnnotated() {
        return this.annotated;
    }

    public boolean isDelegate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isTransient() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

