/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.bean.LatkeBean;
import org.b3log.latke.ioc.config.Configurator;
import org.b3log.latke.ioc.util.Beans;
import org.b3log.latke.util.Reflections;

public abstract class AbstractProvider<T>
implements Provider<T> {
    private LatkeBeanManager beanManager;
    private Configurator configurator;
    private Annotated annotated;
    private Type requiredType;

    public AbstractProvider(LatkeBeanManager beanManager, Annotated annotated) {
        this.beanManager = beanManager;
        this.annotated = annotated;
        this.configurator = beanManager.getConfigurator();
        this.requiredType = ((ParameterizedType)annotated.getBaseType()).getActualTypeArguments()[0];
    }

    public Annotated getAnnotated() {
        return this.annotated;
    }

    public T get() {
        Set<Class<?>> bindedBeanClasses;
        Set annotations = this.annotated.getAnnotations();
        Set<Annotation> requiredQualifiers = Beans.selectQualifiers(annotations);
        if (null == requiredQualifiers) {
            Class<?> beanClass;
            if (!Reflections.isConcrete(this.requiredType)) {
                bindedBeanClasses = this.configurator.getBindedBeanClasses(this.requiredType);
                assert (bindedBeanClasses.size() == 1);
                beanClass = bindedBeanClasses.iterator().next();
            } else {
                beanClass = (Class<?>)this.requiredType;
            }
            requiredQualifiers = this.configurator.getBindedQualifiers(beanClass);
        } else {
            bindedBeanClasses = this.configurator.getBindedBeanClasses(this.requiredType);
            for (Class<?> bindedBeanClass : bindedBeanClasses) {
                Set<Annotation> bindedQualifiers = this.configurator.getBindedQualifiers(bindedBeanClass);
                if (!bindedQualifiers.containsAll(requiredQualifiers)) continue;
                Class<?> beanClass = bindedBeanClass;
                requiredQualifiers = bindedQualifiers;
                break;
            }
        }
        LatkeBean<?> bean = this.beanManager.getBean(this.requiredType, requiredQualifiers);
        if (bean.getScope() != Singleton.class) {
            return (T)bean.create(null);
        }
        return (T)this.beanManager.getReference(bean, this.requiredType, null);
    }
}

