/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.logging;

import java.text.MessageFormat;
import org.b3log.latke.logging.Level;
import org.slf4j.LoggerFactory;

public final class Logger {
    private org.slf4j.Logger proxy;

    private Logger(String className) {
        this.proxy = LoggerFactory.getLogger((String)className);
    }

    public static Logger getLogger(String className) {
        return new Logger(className);
    }

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(clazz.getName());
    }

    public boolean isLoggable(Level level) {
        switch (level) {
            case TRACE: {
                return this.proxy.isTraceEnabled();
            }
            case DEBUG: {
                return this.proxy.isDebugEnabled();
            }
            case INFO: {
                return this.proxy.isInfoEnabled();
            }
            case WARN: {
                return this.proxy.isWarnEnabled();
            }
            case ERROR: {
                this.proxy.isErrorEnabled();
            }
        }
        throw new IllegalStateException("Logging level [" + (Object)((Object)level) + "] is invalid");
    }

    public void error(String msg) {
        if (this.proxy.isErrorEnabled()) {
            this.proxy.error(msg);
        }
    }

    public void warn(String msg) {
        if (this.proxy.isWarnEnabled()) {
            this.proxy.warn(msg);
        }
    }

    public void info(String msg) {
        if (this.proxy.isInfoEnabled()) {
            this.proxy.info(msg);
        }
    }

    public void debug(String msg) {
        if (this.proxy.isDebugEnabled()) {
            this.proxy.debug(msg);
        }
    }

    public void trace(String msg) {
        if (this.proxy.isTraceEnabled()) {
            this.proxy.trace(msg);
        }
    }

    public void log(Level level, String msg, Throwable throwable) {
        switch (level) {
            case ERROR: {
                if (!this.proxy.isErrorEnabled()) break;
                this.proxy.error(msg, throwable);
                break;
            }
            case WARN: {
                if (!this.proxy.isWarnEnabled()) break;
                this.proxy.warn(msg, throwable);
                break;
            }
            case INFO: {
                if (!this.proxy.isInfoEnabled()) break;
                this.proxy.info(msg, throwable);
                break;
            }
            case DEBUG: {
                if (!this.proxy.isDebugEnabled()) break;
                this.proxy.debug(msg, throwable);
                break;
            }
            case TRACE: {
                if (!this.proxy.isTraceEnabled()) break;
                this.proxy.trace(msg, throwable);
                break;
            }
            default: {
                throw new IllegalStateException("Logging level [" + (Object)((Object)level) + "] is invalid");
            }
        }
    }

    public void log(Level level, String msg, Object ... args) {
        String message = msg;
        if (null != args && 0 < args.length && (msg.indexOf("{0") >= 0 || msg.indexOf("{1") >= 0 || msg.indexOf("{2") >= 0 || msg.indexOf("{3") >= 0)) {
            message = MessageFormat.format(msg, args);
        }
        switch (level) {
            case ERROR: {
                if (!this.proxy.isErrorEnabled()) break;
                this.proxy.error(message);
                break;
            }
            case WARN: {
                if (!this.proxy.isWarnEnabled()) break;
                this.proxy.warn(message);
                break;
            }
            case INFO: {
                if (!this.proxy.isInfoEnabled()) break;
                this.proxy.info(message);
                break;
            }
            case DEBUG: {
                if (!this.proxy.isDebugEnabled()) break;
                this.proxy.debug(message);
                break;
            }
            case TRACE: {
                if (!this.proxy.isTraceEnabled()) break;
                this.proxy.trace(message);
                break;
            }
            default: {
                throw new IllegalStateException("Logging level [" + (Object)((Object)level) + "] is invalid");
            }
        }
    }

    public boolean isErrorEnabled() {
        return this.proxy.isErrorEnabled();
    }

    public boolean isWarnEnabled() {
        return this.proxy.isWarnEnabled();
    }

    public boolean isInfoEnabled() {
        return this.proxy.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.proxy.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.proxy.isTraceEnabled();
    }
}

