/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.mail;

import org.b3log.latke.Latkes;
import org.b3log.latke.RuntimeEnv;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.mail.MailService;

public final class MailServiceFactory {
    private static final Logger LOGGER = Logger.getLogger(MailServiceFactory.class.getName());
    private static final MailService MAIL_SERVICE;

    public static MailService getMailService() {
        return MAIL_SERVICE;
    }

    private MailServiceFactory() {
    }

    static {
        LOGGER.info("Constructing Mail Service....");
        RuntimeEnv runtimeEnv = Latkes.getRuntimeEnv();
        try {
            switch (runtimeEnv) {
                case LOCAL: {
                    Class<?> mailServiceClass = Class.forName("org.b3log.latke.mail.local.LocalMailService");
                    MAIL_SERVICE = (MailService)mailServiceClass.newInstance();
                    break;
                }
                case GAE: {
                    Class<?> mailServiceClass = Class.forName("org.b3log.latke.mail.gae.GAEMailService");
                    MAIL_SERVICE = (MailService)mailServiceClass.newInstance();
                    break;
                }
                default: {
                    throw new RuntimeException("Latke runs in the hell.... Please set the enviornment correctly");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can not initialize Mail Service!", e);
        }
        LOGGER.info("Constructed Mail Service");
    }
}

