/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.AbstractRepository;
import org.b3log.latke.repository.Repository;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.latke.util.Strings;
import org.json.JSONArray;
import org.json.JSONObject;

public final class Repositories {
    private static final Logger LOGGER = Logger.getLogger(Repositories.class.getName());
    private static final Map<String, Repository> REPOS_HOLDER = new ConcurrentHashMap<String, Repository>();
    private static JSONObject repositoriesDescription;
    private static boolean repositoryiesWritable;

    public static boolean getReposirotiesWritable() {
        return repositoryiesWritable;
    }

    public static void setRepositoriesWritable(boolean writable) {
        for (Map.Entry<String, Repository> entry : REPOS_HOLDER.entrySet()) {
            String repositoryName = entry.getKey();
            Repository repository = entry.getValue();
            repository.setWritable(writable);
            LOGGER.log(Level.INFO, "Sets repository[name={0}] writable[{1}]", repositoryName, writable);
        }
        repositoryiesWritable = writable;
    }

    public static JSONArray getRepositoryNames() {
        JSONArray ret = new JSONArray();
        if (null == repositoriesDescription) {
            LOGGER.log(Level.INFO, "Not found repository description[repository.json] file under classpath", new Object[0]);
            return ret;
        }
        JSONArray repositories = repositoriesDescription.optJSONArray("repositories");
        for (int i = 0; i < repositories.length(); ++i) {
            JSONObject repository = repositories.optJSONObject(i);
            ret.put(repository.optString("name"));
        }
        return ret;
    }

    public static JSONObject getRepositoriesDescription() {
        return repositoriesDescription;
    }

    public static void check(String repositoryName, JSONObject jsonObject, String ... ignoredKeys) throws RepositoryException {
        int i;
        if (null == jsonObject) {
            throw new RepositoryException("Null to persist to repository[" + repositoryName + "]");
        }
        boolean needIgnoreKeys = null != ignoredKeys && 0 < ignoredKeys.length;
        JSONArray names = jsonObject.names();
        Set nameSet = CollectionUtils.jsonArrayToSet(names);
        JSONArray keysDescription = Repositories.getRepositoryKeysDescription(repositoryName);
        if (null == keysDescription) {
            return;
        }
        HashSet<String> keySet = new HashSet<String>();
        for (i = 0; i < keysDescription.length(); ++i) {
            JSONObject keyDescription = keysDescription.optJSONObject(i);
            String key = keyDescription.optString("name");
            keySet.add(key);
            if (needIgnoreKeys && Strings.containsIgnoreCase(key, ignoredKeys) || keyDescription.optBoolean("nullable") || nameSet.contains(key)) continue;
            throw new RepositoryException("A json object to persist to repository[name=" + repositoryName + "] does not contain a key[" + key + "]");
        }
        for (i = 0; i < names.length(); ++i) {
            String name = names.optString(i);
            if (keySet.contains(name)) continue;
            throw new RepositoryException("A json object to persist to repository[name=" + repositoryName + "] contains an redundant key[" + name + "]");
        }
    }

    public static JSONArray getRepositoryKeysDescription(String repositoryName) {
        if (Strings.isEmptyOrNull(repositoryName)) {
            return null;
        }
        if (null == repositoriesDescription) {
            return null;
        }
        JSONArray repositories = repositoriesDescription.optJSONArray("repositories");
        for (int i = 0; i < repositories.length(); ++i) {
            JSONObject repository = repositories.optJSONObject(i);
            if (!repositoryName.equals(repository.optString("name"))) continue;
            return repository.optJSONArray("keys");
        }
        throw new RuntimeException("Not found the repository[name=" + repositoryName + "] description, please define it in repositories.json");
    }

    public static Set<String> getKeyNames(String repositoryName) {
        if (Strings.isEmptyOrNull(repositoryName)) {
            return Collections.emptySet();
        }
        if (null == repositoriesDescription) {
            return null;
        }
        JSONArray repositories = repositoriesDescription.optJSONArray("repositories");
        JSONArray keys = null;
        for (int i = 0; i < repositories.length(); ++i) {
            JSONObject repository = repositories.optJSONObject(i);
            if (!repositoryName.equals(repository.optString("name"))) continue;
            keys = repository.optJSONArray("keys");
        }
        if (null == keys) {
            throw new RuntimeException("Not found the repository[name=" + repositoryName + "] description, please define it in repositories.json");
        }
        HashSet<String> ret = new HashSet<String>();
        for (int i = 0; i < keys.length(); ++i) {
            JSONObject keyDescription = keys.optJSONObject(i);
            String key = keyDescription.optString("name");
            ret.add(key);
        }
        return ret;
    }

    public static Repository getRepository(String repositoryName) {
        return REPOS_HOLDER.get(repositoryName);
    }

    public static void addRepository(Repository repository) {
        REPOS_HOLDER.put(repository.getName(), repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadRepositoryDescription() {
        LOGGER.log(Level.INFO, "Loading repository description....", new Object[0]);
        InputStream inputStream = AbstractRepository.class.getResourceAsStream("/repository.json");
        if (null == inputStream) {
            LOGGER.log(Level.INFO, "Not found repository description[repository.json] file under classpath", new Object[0]);
            return;
        }
        LOGGER.log(Level.INFO, "Parsing repository description....", new Object[0]);
        try {
            String description = IOUtils.toString((InputStream)inputStream);
            LOGGER.log(Level.DEBUG, "{0}{1}", Strings.LINE_SEPARATOR, description);
            repositoriesDescription = new JSONObject(description);
            String tableNamePrefix = StringUtils.isNotBlank((String)Latkes.getLocalProperty("jdbc.tablePrefix")) ? Latkes.getLocalProperty("jdbc.tablePrefix") + "_" : "";
            JSONArray repositories = repositoriesDescription.optJSONArray("repositories");
            for (int i = 0; i < repositories.length(); ++i) {
                JSONObject repository = repositories.optJSONObject(i);
                repository.put("name", tableNamePrefix + repository.optString("name"));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Parses repository description failed", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.ERROR, e.getMessage(), e);
                throw new RuntimeException(e);
            }
        }
    }

    private Repositories() {
    }

    static {
        repositoryiesWritable = true;
        Repositories.loadRepositoryDescription();
    }
}

