/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.service;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Named;
import javax.inject.Singleton;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.json.JSONArray;
import org.json.JSONObject;

@Named
@Singleton
public class LangPropsServiceImpl
implements LangPropsService {
    private static final Logger LOGGER = Logger.getLogger(LangPropsServiceImpl.class.getName());
    private static final Map<Locale, Map<String, String>> LANGS = new HashMap<Locale, Map<String, String>>();

    @Override
    public Map<String, String> getAll(Locale locale) {
        Map<String, String> ret = LANGS.get(locale);
        if (null == ret) {
            ResourceBundle langBundle;
            ret = new HashMap<String, String>();
            try {
                langBundle = ResourceBundle.getBundle("lang", locale);
            }
            catch (MissingResourceException e) {
                LOGGER.log(Level.WARN, "{0}, using default locale[{1}] instead", e.getMessage(), Latkes.getLocale());
                try {
                    langBundle = ResourceBundle.getBundle("lang", Latkes.getLocale());
                }
                catch (MissingResourceException ex) {
                    LOGGER.log(Level.WARN, "{0}, using default lang.properties instead", e.getMessage());
                    langBundle = ResourceBundle.getBundle("lang");
                }
            }
            Enumeration<String> keys = langBundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = langBundle.getString(key);
                ret.put(key, value);
            }
            LANGS.put(locale, ret);
        }
        return ret;
    }

    @Override
    public JSONObject getLabels(Locale locale) {
        ResourceBundle langBundle;
        JSONObject ret = new JSONObject();
        try {
            langBundle = ResourceBundle.getBundle("lang", locale);
        }
        catch (MissingResourceException e) {
            LOGGER.log(Level.WARN, "{0}, using default locale[{1}]  instead", e.getMessage(), Latkes.getLocale());
            langBundle = ResourceBundle.getBundle("lang", Latkes.getLocale());
        }
        Enumeration<String> keys = langBundle.getKeys();
        JSONArray labels = new JSONArray();
        ret.put("labels", labels);
        while (keys.hasMoreElements()) {
            JSONObject label = new JSONObject();
            String key = keys.nextElement();
            label.put("labelId", key);
            label.put("labelText", langBundle.getString(key));
            labels.put(label);
        }
        return ret;
    }

    @Override
    public String get(String key) {
        return this.get("lang", key, Latkes.getLocale());
    }

    private String get(String baseName, String key, Locale locale) {
        if (!"lang".equals(baseName)) {
            RuntimeException e = new RuntimeException("i18n resource[baseName=" + baseName + "] not found");
            LOGGER.log(Level.ERROR, e.getMessage(), e);
            throw e;
        }
        try {
            return ResourceBundle.getBundle(baseName, locale).getString(key);
        }
        catch (MissingResourceException e) {
            LOGGER.log(Level.WARN, "{0}, get it from default locale[{1}]", e.getMessage(), Latkes.getLocale());
            return ResourceBundle.getBundle(baseName, Latkes.getLocale()).getString(key);
        }
    }
}

