/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet;

import java.util.Collection;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.b3log.latke.Latkes;
import org.b3log.latke.cron.CronService;
import org.b3log.latke.ioc.Lifecycle;
import org.b3log.latke.ioc.config.BeanModule;
import org.b3log.latke.ioc.config.Discoverer;
import org.b3log.latke.ioc.mock.MockServletContext;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.jdbc.JdbcRepository;

public abstract class AbstractServletListener
implements ServletContextListener,
ServletRequestListener,
HttpSessionListener {
    private static final Logger LOGGER = Logger.getLogger(AbstractServletListener.class.getName());
    private static ServletContext servletContext = new MockServletContext();

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        servletContext = servletContextEvent.getServletContext();
        Latkes.initRuntimeEnv();
        LOGGER.info("Initializing the context....");
        Latkes.setLocale(Locale.SIMPLIFIED_CHINESE);
        LOGGER.log(Level.INFO, "Default locale [{0}]", Latkes.getLocale());
        String realPath = servletContext.getRealPath("/");
        LOGGER.log(Level.INFO, "Server [realPath={0}, contextPath={1}]", realPath, servletContext.getContextPath());
        try {
            Collection<Class<?>> beanClasses = Discoverer.discover(Latkes.getScanPath());
            Lifecycle.startApplication(beanClasses, new BeanModule[0]);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Initializes request processors failed", e);
            throw new IllegalStateException("Initializes request processors failed");
        }
        CronService.start();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        LOGGER.info("Destroying the context....");
        Latkes.shutdown();
    }

    public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
        if (Latkes.runsWithJDBCDatabase()) {
            JdbcRepository.dispose();
        }
    }

    public abstract void requestInitialized(ServletRequestEvent var1);

    public abstract void sessionCreated(HttpSessionEvent var1);

    public abstract void sessionDestroyed(HttpSessionEvent var1);

    public static ServletContext getServletContext() {
        if (null == servletContext) {
            throw new IllegalStateException("Initializes the servlet context first!");
        }
        return servletContext;
    }
}

