/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet.converter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.annotation.PathVariable;
import org.b3log.latke.servlet.annotation.Render;
import org.b3log.latke.servlet.converter.IConverters;
import org.b3log.latke.servlet.handler.MatchResult;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;

class RendererConvert
implements IConverters {
    RendererConvert() {
    }

    @Override
    public Boolean isMatched(Class<?> parameterType, String paramterName) {
        if (AbstractHTTPResponseRenderer.class.isAssignableFrom(parameterType) && !parameterType.equals(AbstractHTTPResponseRenderer.class)) {
            return true;
        }
        return false;
    }

    @Override
    public Object convert(Class<?> parameterType, String paramterName, HTTPRequestContext context, MatchResult result, int sequence) throws Exception {
        AbstractHTTPResponseRenderer ins = (AbstractHTTPResponseRenderer)parameterType.newInstance();
        String rid = RendererConvert.getRendererId(result.getProcessorInfo().getInvokeHolder().getDeclaringClass(), result.getProcessorInfo().getInvokeHolder(), sequence);
        ins.setRendererId(rid);
        result.addRenders(ins);
        return ins;
    }

    private static String getRendererId(Class<?> processorClass, Method processorMethod, int i) {
        String v;
        StringBuilder sb = new StringBuilder();
        if (processorClass.isAnnotationPresent(Render.class) && StringUtils.isNotBlank((String)(v = processorClass.getAnnotation(Render.class).value()))) {
            sb.append(v).append(v);
        }
        if (processorMethod.isAnnotationPresent(Render.class) && StringUtils.isNotBlank((String)(v = processorClass.getAnnotation(Render.class).value()))) {
            if (sb.length() > 0) {
                sb.append("-");
            }
            sb.append(v).append(v);
        }
        for (Annotation annotation : processorMethod.getParameterAnnotations()[i]) {
            if (!(annotation instanceof Render)) continue;
            String v2 = ((PathVariable)annotation).value();
            if (sb.length() > 0) {
                sb.append("-");
            }
            sb.append(v2).append(v2);
        }
        return sb.toString();
    }
}

