/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet.filter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;

public abstract class AbstractGZIPFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(AbstractGZIPFilter.class.getName());

    public void init(FilterConfig cfg) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String requestURI = httpServletRequest.getRequestURI();
        if (this.shouldSkip(requestURI)) {
            LOGGER.log(Level.TRACE, "Skip GZIP filter request[URI={0}]", requestURI);
            chain.doFilter(request, response);
            return;
        }
        String acceptEncoding = httpServletRequest.getHeader("Accept-Encoding");
        boolean supportGZIP = false;
        if (null != acceptEncoding && 0 <= acceptEncoding.indexOf("gzip")) {
            supportGZIP = true;
        }
        if (!supportGZIP) {
            LOGGER.info("Gzip NOT be supported");
            chain.doFilter(request, response);
            return;
        }
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.addHeader("Content-Encoding", "gzip");
        httpServletResponse.addHeader("Vary", "Accept-Encoding");
        chain.doFilter(request, (ServletResponse)new GZIPServletResponseWrapper(httpServletResponse));
    }

    public abstract boolean shouldSkip(String var1);

    public void destroy() {
    }

    private class GZIPServletResponseWrapper
    extends HttpServletResponseWrapper {
        private GZIPOutputStream gzipStream;
        private ServletOutputStream servletOutputStream;
        private PrintWriter printWriter;

        GZIPServletResponseWrapper(HttpServletResponse httpServletResponse) throws IOException {
            super(httpServletResponse);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (null == this.servletOutputStream) {
                this.servletOutputStream = this.createOutputStream();
            }
            return this.servletOutputStream;
        }

        public PrintWriter getWriter() throws IOException {
            if (null == this.printWriter) {
                this.printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), this.getCharacterEncoding()));
            }
            return this.printWriter;
        }

        private ServletOutputStream createOutputStream() throws IOException {
            ServletResponse servletResponse = this.getResponse();
            this.gzipStream = new GZIPOutputStream((OutputStream)servletResponse.getOutputStream());
            return new ServletOutputStream(){

                public void write(int b) throws IOException {
                    GZIPServletResponseWrapper.this.gzipStream.write(b);
                }

                public void flush() throws IOException {
                    GZIPServletResponseWrapper.this.gzipStream.flush();
                }

                public void close() throws IOException {
                    GZIPServletResponseWrapper.this.gzipStream.close();
                }

                public void write(byte[] b) throws IOException {
                    GZIPServletResponseWrapper.this.gzipStream.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    GZIPServletResponseWrapper.this.gzipStream.write(b, off, len);
                }

                public boolean isReady() {
                    return true;
                }

                public void setWriteListener(WriteListener writeListener) {
                }
            };
        }
    }
}

