/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.util.Sessions;

public final class AuthenticationFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(AuthenticationFilter.class.getName());

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (!this.hasLoggedIn(httpServletRequest)) {
            LOGGER.log(Level.WARN, "Authenticate fail for request[{0}]", request);
            httpServletResponse.sendError(403);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private boolean hasLoggedIn(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String requestURL = request.getRequestURL().toString();
        LOGGER.log(Level.TRACE, "Request[URI={0}, URL={1}]", requestURI, requestURL);
        String userName = Sessions.currentUserName(request);
        LOGGER.log(Level.TRACE, "Session[userName={0}]", userName);
        return null != userName;
    }
}

