/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet.handler;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HttpControl;
import org.b3log.latke.servlet.handler.Handler;
import org.b3log.latke.servlet.renderer.StaticFileRenderer;
import org.b3log.latke.util.StaticResources;

public class StaticResourceHandler
implements Handler {
    private static final Logger LOGGER = Logger.getLogger(StaticResourceHandler.class.getName());
    private static final String COMMON_DEFAULT_SERVLET_NAME = "default";
    private static final String GAE_DEFAULT_SERVLET_NAME = "_ah_default";
    private static final String RESIN_DEFAULT_SERVLET_NAME = "resin-file";
    private static final String WEBLOGIC_DEFAULT_SERVLET_NAME = "FileServlet";
    private static final String WEBSPHERE_DEFAULT_SERVLET_NAME = "SimpleFileServlet";
    private static final String[] OPTION_SERVLET_NAME = new String[]{"default", "_ah_default", "resin-file", "FileServlet", "SimpleFileServlet"};
    private RequestDispatcher requestDispatcher;
    private String defaultServletName;

    public StaticResourceHandler(ServletContext servletContext) {
        for (String servletName : OPTION_SERVLET_NAME) {
            this.requestDispatcher = servletContext.getNamedDispatcher(servletName);
            if (this.requestDispatcher == null) continue;
            this.defaultServletName = servletName;
            break;
        }
        if (this.requestDispatcher == null) {
            throw new IllegalStateException("Unable to locate the default servlet for serving static content. Please report this bug on https://github.com/b3log/b3log-latke/issues/new");
        }
        LOGGER.log(Level.DEBUG, "The default servlet for serving static resource is [{0}]", this.defaultServletName);
    }

    @Override
    public void handle(HTTPRequestContext context, HttpControl httpControl) throws Exception {
        HttpServletRequest request = context.getRequest();
        if (StaticResources.isStatic(request)) {
            if (null == this.requestDispatcher) {
                throw new IllegalStateException("A RequestDispatcher could not be located for the default servlet [" + this.defaultServletName + "]");
            }
            context.setRenderer(new StaticFileRenderer(this.requestDispatcher));
            return;
        }
        httpControl.nextHandler();
    }
}

