/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet.renderer;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.json.JSONObject;

public final class JSONRenderer
extends AbstractHTTPResponseRenderer {
    private static final Logger LOGGER = Logger.getLogger(JSONRenderer.class.getName());
    private JSONObject jsonObject;
    private boolean isJSONP;
    private String callback = "callback";

    public void setJSONObject(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public JSONRenderer setJSONP(boolean isJSONP) {
        this.isJSONP = isJSONP;
        return this;
    }

    public void setCallback(String callback) {
        this.callback = callback;
        this.setJSONP(true);
    }

    @Override
    public void render(HTTPRequestContext context) {
        HttpServletResponse response = context.getResponse();
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            PrintWriter writer = response.getWriter();
            if (!this.isJSONP) {
                writer.println(this.jsonObject);
            } else {
                writer.print(this.callback + "(" + this.jsonObject + ")");
            }
            writer.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "FreeMarker renders error", e);
            try {
                response.sendError(500);
            }
            catch (IOException ex) {
                LOGGER.log(Level.ERROR, "Can not send error 500!", ex);
            }
        }
    }
}

