/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.thread;

import org.b3log.latke.Latkes;
import org.b3log.latke.RuntimeEnv;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.thread.ThreadService;

public final class ThreadServiceFactory {
    private static final Logger LOGGER = Logger.getLogger(ThreadServiceFactory.class.getName());
    private static final ThreadService THREAD_SERVICE;

    public static ThreadService getThreadService() {
        return THREAD_SERVICE;
    }

    private ThreadServiceFactory() {
    }

    static {
        LOGGER.info("Constructing Thread Service....");
        RuntimeEnv runtimeEnv = Latkes.getRuntimeEnv();
        try {
            Class<?> serviceClass = null;
            switch (runtimeEnv) {
                case LOCAL: {
                    serviceClass = Class.forName("org.b3log.latke.thread.local.LocalThreadService");
                    THREAD_SERVICE = (ThreadService)serviceClass.newInstance();
                    break;
                }
                case GAE: {
                    serviceClass = Class.forName("org.b3log.latke.thread.gae.GAEThreadService");
                    THREAD_SERVICE = (ThreadService)serviceClass.newInstance();
                    break;
                }
                default: {
                    throw new RuntimeException("Latke runs in the hell.... Please set the enviornment correctly");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can not initialize Thread Service!", e);
        }
        LOGGER.info("Constructed Thread Service");
    }
}

