/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.urlfetch;

import org.b3log.latke.Latkes;
import org.b3log.latke.RuntimeEnv;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.urlfetch.URLFetchService;

public final class URLFetchServiceFactory {
    private static final Logger LOGGER = Logger.getLogger(URLFetchServiceFactory.class.getName());
    private static final URLFetchService URL_FETCH_SERVICE;

    public static URLFetchService getURLFetchService() {
        return URL_FETCH_SERVICE;
    }

    private URLFetchServiceFactory() {
    }

    static {
        LOGGER.info("Constructing URL Fetch Service....");
        RuntimeEnv runtimeEnv = Latkes.getRuntimeEnv();
        try {
            switch (runtimeEnv) {
                case LOCAL: {
                    Class<?> serviceClass = Class.forName("org.b3log.latke.urlfetch.local.LocalURLFetchService");
                    URL_FETCH_SERVICE = (URLFetchService)serviceClass.newInstance();
                    break;
                }
                case GAE: {
                    Class<?> serviceClass = Class.forName("org.b3log.latke.urlfetch.gae.GAEURLFetchService");
                    URL_FETCH_SERVICE = (URLFetchService)serviceClass.newInstance();
                    break;
                }
                default: {
                    throw new RuntimeException("Latke runs in the hell.... Please set the enviornment correctly");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can not initialize URL Fetch Service!", e);
        }
        LOGGER.info("Constructed URL Fetch Service");
    }
}

