/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.urlfetch.local;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.thread.ThreadService;
import org.b3log.latke.thread.ThreadServiceFactory;
import org.b3log.latke.urlfetch.HTTPRequest;
import org.b3log.latke.urlfetch.HTTPResponse;
import org.b3log.latke.urlfetch.URLFetchService;
import org.b3log.latke.urlfetch.local.UrlFetchHandlerFactory;

public final class LocalURLFetchService
implements URLFetchService {
    private static final Logger LOGGER = Logger.getLogger(LocalURLFetchService.class.getName());
    private ThreadService threadService = ThreadServiceFactory.getThreadService();
    private static final long ASYNC_TIME_OUT = 10000L;

    @Override
    public HTTPResponse fetch(HTTPRequest request) throws IOException {
        HTTPRequestMethod requestMethod = request.getRequestMethod();
        if (requestMethod == null) {
            throw new IOException("RequestMethod  for URLFetch should not be null");
        }
        return UrlFetchHandlerFactory.getFetchHandler(requestMethod).doFetch(request);
    }

    @Override
    public Future<?> fetchAsync(final HTTPRequest request) {
        FutureTask<HTTPResponse> futureTask = new FutureTask<HTTPResponse>(new Callable<HTTPResponse>(){

            @Override
            public HTTPResponse call() throws Exception {
                LOGGER.log(Level.DEBUG, "Fetch async, request=[" + request.toString() + "]", new Object[0]);
                return LocalURLFetchService.this.fetch(request);
            }
        });
        this.threadService.submit(futureTask, 10000L);
        return futureTask;
    }
}

