/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.b3log.latke.logging.Logger;

public final class EmailSender
implements Runnable {
    public static final String MAIL_HOST = "smtp.gmail.com";
    private String from;
    private String to;
    private String message;
    private String subject;
    private String userName;
    private String password;

    public EmailSender(String userName, String password, String from, String to, String message, String subject) {
        this.userName = userName;
        this.password = password;
        this.from = from;
        this.to = to;
        this.message = message;
        this.subject = subject;
    }

    private void sendMail() throws MessagingException {
        Properties props = new Properties();
        props.put("mail.smtp.host", MAIL_HOST);
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        SMTPAuthenticator auth = new SMTPAuthenticator();
        MimeMessage msg = new MimeMessage(Session.getDefaultInstance((Properties)props, (Authenticator)auth));
        msg.setFrom((Address)new InternetAddress(this.from));
        msg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.to));
        msg.setSubject(this.subject);
        msg.setText(this.message);
        Transport.send((Message)msg);
    }

    @Override
    public void run() {
        try {
            this.sendMail();
        }
        catch (MessagingException ex) {
            Logger.getLogger(EmailSender.class.getName()).error(ex.getMessage());
        }
    }

    private class SMTPAuthenticator
    extends Authenticator {
        private SMTPAuthenticator() {
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(EmailSender.this.userName, EmailSender.this.password);
        }
    }
}

