/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.json.JSONObject;

public final class Sessions {
    private static final Logger LOGGER = Logger.getLogger(Sessions.class.getName());
    private static final int COOKIE_EXPIRY = 31536000;

    private Sessions() {
    }

    public static void login(HttpServletRequest request, HttpServletResponse response, JSONObject user) {
        HttpSession session = request.getSession(false);
        if (null == session) {
            LOGGER.warn("The session is null");
            return;
        }
        session.setAttribute("user", (Object)user);
        try {
            JSONObject cookieJSONObject = new JSONObject();
            cookieJSONObject.put("userEmail", user.optString("userEmail"));
            cookieJSONObject.put("userPassword", user.optString("userPassword"));
            Cookie cookie = new Cookie("b3log-latke", cookieJSONObject.toString());
            cookie.setPath("/");
            cookie.setMaxAge(31536000);
            response.addCookie(cookie);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Can not write cookie", e);
        }
    }

    public static boolean logout(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (null != session) {
            Cookie cookie = new Cookie("b3log-latke", null);
            cookie.setMaxAge(0);
            cookie.setPath("/");
            response.addCookie(cookie);
            session.invalidate();
            return true;
        }
        return false;
    }

    public static JSONObject currentUser(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (null != session) {
            return (JSONObject)session.getAttribute("user");
        }
        return null;
    }

    public static String currentUserPwd(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (null != session) {
            JSONObject user = (JSONObject)session.getAttribute("user");
            return user.optString("userPassword");
        }
        return null;
    }

    public static String currentUserName(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (null != session) {
            JSONObject user = (JSONObject)session.getAttribute("user");
            return user.optString("userName");
        }
        return null;
    }

    public static String currentUserEmail(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (null != session) {
            JSONObject user = (JSONObject)session.getAttribute("user");
            return user.optString("userEmail");
        }
        return null;
    }
}

