/*
 * Decompiled with CFR 0.152.
 */
package org.weborganic.furi;

import java.util.Hashtable;
import java.util.Map;
import org.weborganic.furi.Token;
import org.weborganic.furi.TokenLiteral;
import org.weborganic.furi.TokenOperatorD3;
import org.weborganic.furi.TokenOperatorDX;
import org.weborganic.furi.TokenOperatorPS;
import org.weborganic.furi.TokenVariable;
import org.weborganic.furi.Variable;

public class TokenFactory {
    private static final Map<Syntax, TokenFactory> FACTORIES = new Hashtable<Syntax, TokenFactory>();
    private Syntax _syntax;

    private TokenFactory(Syntax syntax) {
        this._syntax = syntax;
    }

    public Token newToken(String exp) {
        if (exp == null || exp.length() == 0) {
            return null;
        }
        if ("*".equals(exp)) {
            return TokenFactory.newWildcard();
        }
        int len = exp.length();
        if (len < 2) {
            return new TokenLiteral(exp);
        }
        if (exp.charAt(0) == '{' && exp.charAt(len - 1) == '}') {
            return this._syntax.newExpansion(exp.substring(1, len - 1));
        }
        return new TokenLiteral(exp);
    }

    public static Token newToken(String exp, Syntax syntax) {
        TokenFactory factory = TokenFactory.getInstance(syntax);
        return factory.newToken(exp);
    }

    private static final Token newWildcard() {
        return new TokenOperatorPS(TokenOperatorPS.Operator.URI_INSERT, new Variable(Variable.Reserved.WILDCARD));
    }

    public static TokenFactory getInstance() {
        return FACTORIES.get((Object)Syntax.DRAFTX);
    }

    public static TokenFactory getInstance(Syntax syntax) {
        return new TokenFactory(syntax);
    }

    static {
        for (Syntax syntax : Syntax.values()) {
            FACTORIES.put(syntax, new TokenFactory(syntax));
        }
    }

    public static enum Syntax {
        DRAFT3{

            @Override
            protected Token newExpansion(String exp) {
                if (exp.indexOf(124) >= 0) {
                    return TokenOperatorD3.parse(exp);
                }
                return new TokenVariable(Variable.parse(exp));
            }
        }
        ,
        PAGESEEDER{

            @Override
            protected Token newExpansion(String exp) {
                if (!Character.isLetter(exp.charAt(0)) && !Character.isDigit(exp.charAt(0))) {
                    return TokenOperatorPS.parse(exp);
                }
                return new TokenVariable(Variable.parse(exp));
            }
        }
        ,
        DRAFTX{

            @Override
            protected Token newExpansion(String exp) {
                if (!Character.isLetter(exp.charAt(0)) && !Character.isDigit(exp.charAt(0))) {
                    return TokenOperatorDX.parse(exp);
                }
                if (exp.indexOf(44) >= 0) {
                    return TokenOperatorDX.parse(exp);
                }
                return new TokenVariable(Variable.parse(exp));
            }
        };


        protected abstract Token newExpansion(String var1);
    }
}

