/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.Config;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.FormUploader;
import com.qiniu.storage.RecordKeyGenerator;
import com.qiniu.storage.Recorder;
import com.qiniu.storage.ResumeUploader;
import com.qiniu.util.StringMap;
import java.io.File;

public final class UploadManager {
    private final Client client = new Client();
    private final Recorder recorder;
    private final RecordKeyGenerator keyGen;

    public UploadManager() {
        this(null, null);
    }

    public UploadManager(Recorder recorder) {
        this(recorder, new RecordKeyGenerator(){

            @Override
            public String gen(String key, File file) {
                return key + "_._" + file.getAbsolutePath();
            }
        });
    }

    public UploadManager(Recorder recorder, RecordKeyGenerator keyGen) {
        this.recorder = recorder;
        this.keyGen = keyGen;
    }

    private static void checkArgs(String key, byte[] data, File f, String token) {
        String message = null;
        if (f == null && data == null) {
            message = "no input data";
        } else if (token == null || token.equals("")) {
            message = "no token";
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
    }

    private static StringMap filterParam(StringMap params) {
        final StringMap ret = new StringMap();
        if (params == null) {
            return ret;
        }
        params.forEach(new StringMap.Consumer(){

            @Override
            public void accept(String key, Object value) {
                if (value == null) {
                    return;
                }
                String val = value.toString();
                if (key.startsWith("x:") && !val.equals("")) {
                    ret.put(key, val);
                }
            }
        });
        return ret;
    }

    public Response put(byte[] data, String key, String token) throws QiniuException {
        return this.put(data, key, token, null, null, false);
    }

    public Response put(byte[] data, String key, String token, StringMap params, String mime, boolean checkCrc) throws QiniuException {
        UploadManager.checkArgs(key, data, null, token);
        if (mime == null) {
            mime = "application/octet-stream";
        }
        params = UploadManager.filterParam(params);
        return new FormUploader(this.client, token, key, data, params, mime, checkCrc).upload();
    }

    public Response put(String filePath, String key, String token) throws QiniuException {
        return this.put(filePath, key, token, null, null, false);
    }

    public Response put(String filePath, String key, String token, StringMap params, String mime, boolean checkCrc) throws QiniuException {
        return this.put(new File(filePath), key, token, params, mime, checkCrc);
    }

    public Response put(File file, String key, String token) throws QiniuException {
        return this.put(file, key, token, null, null, false);
    }

    public Response put(File file, String key, String token, StringMap params, String mime, boolean checkCrc) throws QiniuException {
        UploadManager.checkArgs(key, null, file, token);
        if (mime == null) {
            mime = "application/octet-stream";
        }
        params = UploadManager.filterParam(params);
        long size = file.length();
        if (size <= (long)Config.PUT_THRESHOLD) {
            return new FormUploader(this.client, token, key, file, params, mime, checkCrc).upload();
        }
        String recorderKey = key;
        if (this.keyGen != null) {
            recorderKey = this.keyGen.gen(key, file);
        }
        ResumeUploader uploader = new ResumeUploader(this.client, token, key, file, params, mime, this.recorder, recorderKey);
        return uploader.upload();
    }
}

