/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.api.metaweblog;

import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.TextXMLRenderer;
import org.b3log.latke.util.MD5;
import org.b3log.solo.repository.ArticleRepository;
import org.b3log.solo.service.ArticleMgmtService;
import org.b3log.solo.service.ArticleQueryService;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.TagQueryService;
import org.b3log.solo.service.UserQueryService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.jsoup.Jsoup;

@RequestProcessor
public class MetaWeblogAPI {
    private static final Logger LOGGER = Logger.getLogger((String)MetaWeblogAPI.class.getName());
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private TagQueryService tagQueryService;
    @Inject
    private ArticleQueryService articleQueryService;
    @Inject
    private ArticleMgmtService articleMgmtService;
    @Inject
    private ArticleRepository articleRepository;
    @Inject
    private UserQueryService userQueryService;
    private static final String METHOD_CALL = "methodCall";
    private static final String METHOD_NAME = "methodName";
    private static final String METHOD_GET_USERS_BLOGS = "blogger.getUsersBlogs";
    private static final String METHOD_GET_CATEGORIES = "metaWeblog.getCategories";
    private static final String METHOD_GET_RECENT_POSTS = "metaWeblog.getRecentPosts";
    private static final String METHOD_NEW_POST = "metaWeblog.newPost";
    private static final String METHOD_EDIT_POST = "metaWeblog.editPost";
    private static final String METHOD_GET_POST = "metaWeblog.getPost";
    private static final String METHOD_DELETE_POST = "blogger.deletePost";
    private static final int INDEX_USER_EMAIL = 1;
    private static final int INDEX_POST_ID = 0;
    private static final int INDEX_USER_PWD = 2;
    private static final int INDEX_NUM_OF_POSTS = 3;
    private static final int INDEX_POST = 3;
    private static final int INDEX_PUBLISH = 4;
    private static final int ARTICLE_ABSTRACT_LENGTH = 500;

    @RequestProcessing(value={"/apis/metaweblog"}, method={HTTPRequestMethod.POST})
    public void metaWeblog(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) {
        String responseContent;
        TextXMLRenderer renderer;
        block12: {
            renderer = new TextXMLRenderer();
            context.setRenderer((AbstractHTTPResponseRenderer)renderer);
            responseContent = null;
            try {
                String userEmail;
                JSONObject user;
                ServletInputStream inputStream = request.getInputStream();
                String xml = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                JSONObject requestJSONObject = XML.toJSONObject((String)xml);
                JSONObject methodCall = requestJSONObject.getJSONObject(METHOD_CALL);
                String methodName = methodCall.getString(METHOD_NAME);
                LOGGER.log(Level.INFO, "MetaWeblog[methodName={0}]", new Object[]{methodName});
                JSONArray params = methodCall.getJSONObject("params").getJSONArray("param");
                if (METHOD_DELETE_POST.equals(methodName)) {
                    params.remove(0);
                }
                if (null == (user = this.userQueryService.getUserByEmail(userEmail = params.getJSONObject(1).getJSONObject("value").getString("string")))) {
                    throw new Exception("No user[email=" + userEmail + "]");
                }
                String userPwd = params.getJSONObject(2).getJSONObject("value").getString("string");
                if (!user.getString("userPassword").equals(MD5.hash((String)userPwd))) {
                    throw new Exception("Wrong password");
                }
                if (METHOD_GET_USERS_BLOGS.equals(methodName)) {
                    responseContent = this.getUsersBlogs();
                    break block12;
                }
                if (METHOD_GET_CATEGORIES.equals(methodName)) {
                    responseContent = this.getCategories();
                    break block12;
                }
                if (METHOD_GET_RECENT_POSTS.equals(methodName)) {
                    int numOfPosts = params.getJSONObject(3).getJSONObject("value").getInt("int");
                    responseContent = this.getRecentPosts(numOfPosts);
                    break block12;
                }
                if (METHOD_NEW_POST.equals(methodName)) {
                    JSONObject article = this.parsetPost(methodCall);
                    article.put("articleAuthorEmail", (Object)userEmail);
                    this.addArticle(article);
                    StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><methodResponse>").append("<params><param><value><string>").append(article.getString(Keys.OBJECT_ID)).append("</string></value></param></params></methodResponse>");
                    responseContent = stringBuilder.toString();
                    break block12;
                }
                if (METHOD_GET_POST.equals(methodName)) {
                    String postId = params.getJSONObject(0).getJSONObject("value").getString("string");
                    responseContent = this.getPost(postId);
                    break block12;
                }
                if (METHOD_EDIT_POST.equals(methodName)) {
                    JSONObject article = this.parsetPost(methodCall);
                    String postId = params.getJSONObject(0).getJSONObject("value").getString("string");
                    article.put(Keys.OBJECT_ID, (Object)postId);
                    article.put("articleAuthorEmail", (Object)userEmail);
                    JSONObject updateArticleRequest = new JSONObject();
                    updateArticleRequest.put("article", (Object)article);
                    this.articleMgmtService.updateArticle(updateArticleRequest);
                    StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><methodResponse>").append("<params><param><value><string>").append(postId).append("</string></value></param></params></methodResponse>");
                    responseContent = stringBuilder.toString();
                    break block12;
                }
                if (METHOD_DELETE_POST.equals(methodName)) {
                    String postId = params.getJSONObject(0).getJSONObject("value").getString("string");
                    this.articleMgmtService.removeArticle(postId);
                    StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><methodResponse>").append("<params><param><value><boolean>").append(true).append("</boolean></value></param></params></methodResponse>");
                    responseContent = stringBuilder.toString();
                    break block12;
                }
                throw new UnsupportedOperationException("Unsupported method[name=" + methodName + "]");
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
                StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><methodResponse>").append("<fault><value><struct>").append("<member><name>faultCode</name><value><int>500</int></value></member>").append("<member><name>faultString</name><value><string>").append(e.getMessage()).append("</string></value></member></struct></value></fault></methodResponse>");
                responseContent = stringBuilder.toString();
            }
        }
        renderer.setContent(responseContent);
    }

    private String getPost(String postId) throws Exception {
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><methodResponse><params><param><value>");
        String posts = this.buildPost(postId);
        stringBuilder.append(posts);
        stringBuilder.append("</value></param></params></methodResponse>");
        return stringBuilder.toString();
    }

    private void addArticle(JSONObject article) throws Exception {
        Transaction transaction = this.articleRepository.beginTransaction();
        try {
            this.articleMgmtService.addArticleInternal(article);
            transaction.commit();
        }
        catch (ServiceException e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw e;
        }
    }

    private JSONObject parsetPost(JSONObject methodCall) throws Exception {
        JSONObject ret = new JSONObject();
        JSONArray params = methodCall.getJSONObject("params").getJSONArray("param");
        JSONObject post = params.getJSONObject(3).getJSONObject("value").getJSONObject("struct");
        JSONArray members = post.getJSONArray("member");
        for (int i = 0; i < members.length(); ++i) {
            JSONObject member = members.getJSONObject(i);
            String name = member.getString("name");
            if ("dateCreated".equals(name)) {
                Date date;
                String dateString = member.getJSONObject("value").getString("dateTime.iso8601");
                try {
                    date = (Date)DateFormatUtils.ISO_DATETIME_FORMAT.parseObject(dateString);
                }
                catch (ParseException e) {
                    LOGGER.log(Level.WARN, "Parses article create date failed with ISO8601, retry to parse with pattern[yyyy-MM-dd'T'HH:mm:ss, yyyyMMdd'T'HH:mm:ss'Z']", new Object[0]);
                    date = DateUtils.parseDate((String)dateString, (String[])new String[]{"yyyyMMdd'T'HH:mm:ss", "yyyyMMdd'T'HH:mm:ss'Z'"});
                }
                ret.put("articleCreateDate", (Object)date);
                continue;
            }
            if ("title".equals(name)) {
                ret.put("articleTitle", (Object)member.getJSONObject("value").getString("string"));
                continue;
            }
            if ("description".equals(name)) {
                String content = member.getJSONObject("value").getString("string");
                ret.put("articleContent", (Object)content);
                String plainTextContent = Jsoup.parse((String)content).text();
                if (plainTextContent.length() > 500) {
                    ret.put("articleAbstract", (Object)plainTextContent.substring(0, 500));
                    continue;
                }
                ret.put("articleAbstract", (Object)plainTextContent);
                continue;
            }
            if (!"categories".equals(name)) continue;
            StringBuilder tagBuilder = new StringBuilder();
            JSONObject data = member.getJSONObject("value").getJSONObject("array").getJSONObject("data");
            if (0 == data.length()) {
                throw new Exception("At least one Tag");
            }
            Object value = data.get("value");
            if (value instanceof JSONArray) {
                JSONArray tags = (JSONArray)value;
                for (int j = 0; j < tags.length(); ++j) {
                    String tagTitle = tags.getJSONObject(j).getString("string");
                    tagBuilder.append(tagTitle);
                    if (j >= tags.length() - 1) continue;
                    tagBuilder.append(",");
                }
            } else {
                JSONObject tag = (JSONObject)value;
                tagBuilder.append(tag.getString("string"));
            }
            ret.put("articleTags", (Object)tagBuilder.toString());
        }
        boolean publish = 1 == params.getJSONObject(4).getJSONObject("value").getInt("boolean");
        ret.put("articleIsPublished", publish);
        ret.put("articleCommentable", true);
        ret.put("articleViewPwd", (Object)"");
        return ret;
    }

    private String getRecentPosts(int fetchSize) throws Exception {
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><methodResponse><params><param><value><array><data>");
        String posts = this.buildRecentPosts(fetchSize);
        stringBuilder.append(posts);
        stringBuilder.append("</data></array></value></param></params></methodResponse>");
        return stringBuilder.toString();
    }

    private String getCategories() throws Exception {
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><methodResponse><params><param><value><array><data>");
        String categories = this.buildCategories();
        stringBuilder.append(categories);
        stringBuilder.append("</data></array></value></param></params></methodResponse>");
        return stringBuilder.toString();
    }

    private String getUsersBlogs() throws Exception {
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><methodResponse><params><param><value><array><data><value><struct>");
        JSONObject preference = this.preferenceQueryService.getPreference();
        String blogInfo = this.buildBlogInfo(preference);
        stringBuilder.append(blogInfo);
        stringBuilder.append("</struct></value></data></array></value></param></params></methodResponse>");
        return stringBuilder.toString();
    }

    private String buildPost(String postId) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        JSONObject result = this.articleQueryService.getArticle(postId);
        if (null == result) {
            throw new Exception("Not found article[id=" + postId + "]");
        }
        JSONObject article = result.getJSONObject("article");
        Date createDate = (Date)article.get("articleCreateDate");
        String articleTitle = StringEscapeUtils.escapeXml((String)article.getString("articleTitle"));
        stringBuilder.append("<struct>");
        stringBuilder.append("<member><name>dateCreated</name>").append("<value><dateTime.iso8601>").append(DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(createDate)).append("</dateTime.iso8601></value></member>");
        stringBuilder.append("<member><name>description</name>").append("<value>").append(StringEscapeUtils.escapeXml((String)article.getString("articleContent"))).append("</value></member>");
        stringBuilder.append("<member><name>title</name>").append("<value>").append(articleTitle).append("</value></member>");
        stringBuilder.append("<member><name>categories</name>").append("<value><array><data>");
        JSONArray tags = article.getJSONArray("articleTags");
        for (int i = 0; i < tags.length(); ++i) {
            String tagTitle = tags.getJSONObject(i).getString("tagTitle");
            stringBuilder.append("<value>").append(tagTitle).append("</value>");
        }
        stringBuilder.append("</data></array></value></member></struct>");
        return stringBuilder.toString();
    }

    private String buildRecentPosts(int fetchSize) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        List<JSONObject> recentArticles = this.articleQueryService.getRecentArticles(fetchSize);
        for (JSONObject article : recentArticles) {
            Date createDate = (Date)article.get("articleCreateDate");
            String articleTitle = StringEscapeUtils.escapeXml((String)article.getString("articleTitle"));
            stringBuilder.append("<value><struct>");
            stringBuilder.append("<member><name>dateCreated</name>").append("<value><dateTime.iso8601>").append(DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(createDate)).append("</dateTime.iso8601></value></member>");
            stringBuilder.append("<member><name>description</name>").append("<value>").append(StringEscapeUtils.escapeXml((String)article.getString("articleContent"))).append("</value></member>");
            stringBuilder.append("<member><name>title</name>").append("<value>").append(articleTitle).append("</value></member>");
            stringBuilder.append("<member><name>postid</name>").append("<value>").append(article.getString(Keys.OBJECT_ID)).append("</value></member>");
            stringBuilder.append("<member><name>categories</name>").append("<value><array><data>");
            String tagTitles = article.getString("articleTags");
            String[] tagTitleArray = tagTitles.split(",");
            for (int i = 0; i < tagTitleArray.length; ++i) {
                String tagTitle = tagTitleArray[i];
                stringBuilder.append("<value>").append(tagTitle).append("</value>");
            }
            stringBuilder.append("</data></array></value></member>");
            stringBuilder.append("</struct></value>");
        }
        return stringBuilder.toString();
    }

    private String buildCategories() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        List<JSONObject> tags = this.tagQueryService.getTags();
        for (JSONObject tag : tags) {
            String tagTitle = StringEscapeUtils.escapeXml((String)tag.getString("tagTitle"));
            String tagId = tag.getString(Keys.OBJECT_ID);
            stringBuilder.append("<value><struct>");
            stringBuilder.append("<member><name>description</name>").append("<value>").append(tagTitle).append("</value></member>");
            stringBuilder.append("<member><name>title</name>").append("<value>").append(tagTitle).append("</value></member>");
            stringBuilder.append("<member><name>categoryid</name>").append("<value>").append(tagId).append("</value></member>");
            stringBuilder.append("<member><name>htmlUrl</name>").append("<value>").append(Latkes.getServePath()).append("/tags/").append(tagTitle).append("</value></member>");
            stringBuilder.append("<member><name>rsslUrl</name>").append("<value>").append(Latkes.getServePath()).append("/tag-articles-rss.do?oId=").append(tagId).append("</value></member>");
            stringBuilder.append("</struct></value>");
        }
        return stringBuilder.toString();
    }

    private String buildBlogInfo(JSONObject preference) throws JSONException {
        String blogId = preference.getString(Keys.OBJECT_ID);
        String blogTitle = StringEscapeUtils.escapeXml((String)preference.getString("blogTitle"));
        StringBuilder stringBuilder = new StringBuilder("<member><name>blogid</name><value>").append(blogId).append("</value></member>");
        stringBuilder.append("<member><name>url</name><value>").append(Latkes.getServePath()).append("</value></member>");
        stringBuilder.append("<member><name>blogName</name><value>").append(blogTitle).append("</value></member>");
        return stringBuilder.toString();
    }
}

