/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.dev;

import java.io.IOException;
import java.util.Date;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateUtils;
import org.b3log.latke.Latkes;
import org.b3log.latke.RuntimeMode;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.util.Stopwatchs;
import org.b3log.solo.service.ArticleMgmtService;
import org.b3log.solo.service.UserQueryService;
import org.json.JSONObject;

@RequestProcessor
public class ArticleGenerator {
    private static final Logger LOGGER = Logger.getLogger((String)ArticleGenerator.class.getName());
    @Inject
    private ArticleMgmtService articleMgmtService;
    @Inject
    private UserQueryService userQueryService;

    @RequestProcessing(value={"/dev/articles/gen/*"}, method={HTTPRequestMethod.GET})
    public void genArticles(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (RuntimeMode.DEVELOPMENT != Latkes.getRuntimeMode()) {
            LOGGER.log(Level.WARN, "Article generation just for development mode, current runtime mode is [{0}]", new Object[]{Latkes.getRuntimeMode()});
            response.sendRedirect(Latkes.getServePath());
            return;
        }
        Stopwatchs.start((String)"Gen Articles");
        String requestURI = request.getRequestURI();
        int num = Integer.valueOf(requestURI.substring((Latkes.getContextPath() + "/dev/articles/gen/").length()));
        try {
            JSONObject admin = this.userQueryService.getAdmin();
            String authorEmail = admin.optString("userEmail");
            for (int i = 0; i < num; ++i) {
                JSONObject article = new JSONObject();
                article.put("articleTitle", (Object)("article title" + i));
                article.put("articleAbstract", (Object)("article" + i + " abstract"));
                int deviationTag = 3;
                article.put("articleTags", (Object)("taga,tagb,tag" + i % 3));
                article.put("articleAuthorEmail", (Object)authorEmail);
                article.put("articleCommentCount", 0);
                article.put("articleViewCount", 0);
                article.put("articleContent", (Object)"article content");
                article.put("articlePermalink", (Object)("article" + i + " permalink"));
                article.put("articleHadBeenPublished", true);
                article.put("articleIsPublished", true);
                article.put("articlePutTop", false);
                int deviationBase = 5;
                int deviationDay = -(Integer.valueOf(String.valueOf(i).substring(0, 1)) % 5);
                Date date = DateUtils.addMonths((Date)new Date(), (int)deviationDay);
                article.put("articleCreateDate", (Object)date);
                article.put("articleUpdateDate", (Object)date);
                article.put("articleRandomDouble", Math.random());
                article.put("articleCommentable", true);
                article.put("articleViewPwd", (Object)"");
                article.put("articleSignId", (Object)"1");
                this.articleMgmtService.addArticle(new JSONObject().put("article", (Object)article));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
        }
        Stopwatchs.end();
        response.sendRedirect(Latkes.getServePath());
    }
}

