/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.event.comment;

import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.event.AbstractEventListener;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.EventException;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.Lifecycle;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.mail.MailService;
import org.b3log.latke.mail.MailServiceFactory;
import org.b3log.latke.util.Strings;
import org.b3log.solo.repository.CommentRepository;
import org.b3log.solo.repository.impl.CommentRepositoryImpl;
import org.b3log.solo.service.PreferenceQueryService;
import org.json.JSONObject;

public final class ArticleCommentReplyNotifier
extends AbstractEventListener<JSONObject> {
    private static final Logger LOGGER = Logger.getLogger((String)ArticleCommentReplyNotifier.class.getName());
    private MailService mailService = MailServiceFactory.getMailService();

    public void action(Event<JSONObject> event) throws EventException {
        JSONObject eventData = (JSONObject)event.getData();
        JSONObject comment = eventData.optJSONObject("comment");
        JSONObject article = eventData.optJSONObject("article");
        LOGGER.log(Level.DEBUG, "Processing an event[type={0}, data={1}] in listener[className={2}]", new Object[]{event.getType(), eventData, ArticleCommentReplyNotifier.class.getName()});
        String originalCommentId = comment.optString("commentOriginalCommentId");
        if (Strings.isEmptyOrNull((String)originalCommentId)) {
            LOGGER.log(Level.DEBUG, "This comment[id={0}] is not a reply", new Object[]{comment.optString(Keys.OBJECT_ID)});
            return;
        }
        LatkeBeanManager beanManager = Lifecycle.getBeanManager();
        PreferenceQueryService preferenceQueryService = (PreferenceQueryService)beanManager.getReference(PreferenceQueryService.class);
        CommentRepository commentRepository = (CommentRepository)beanManager.getReference(CommentRepositoryImpl.class);
        try {
            String commentEmail = comment.getString("commentEmail");
            JSONObject originalComment = commentRepository.get(originalCommentId);
            String originalCommentEmail = originalComment.getString("commentEmail");
            if (originalCommentEmail.equalsIgnoreCase(commentEmail)) {
                return;
            }
            JSONObject preference = preferenceQueryService.getPreference();
            if (null == preference) {
                throw new EventException("Not found preference");
            }
            String blogTitle = preference.getString("blogTitle");
            String adminEmail = preference.getString("adminEmail");
            String commentContent = comment.getString("commentContent").replaceAll("_esc_enter_88250_", "<br/>");
            String commentSharpURL = comment.getString("commentSharpURL");
            MailService.Message message = new MailService.Message();
            message.setFrom(adminEmail);
            message.addRecipient(originalCommentEmail);
            JSONObject replyNotificationTemplate = preferenceQueryService.getReplyNotificationTemplate();
            String mailSubject = replyNotificationTemplate.getString("subject").replace("${blogTitle}", blogTitle);
            message.setSubject(mailSubject);
            String articleTitle = article.getString("articleTitle");
            String articleLink = Latkes.getServePath() + article.getString("articlePermalink");
            String commentName = comment.getString("commentName");
            String commentURL = comment.getString("commentURL");
            String commenter = !"http://".equals(commentURL) ? "<a target=\"_blank\" href=\"" + commentURL + "\">" + commentName + "</a>" : commentName;
            String mailBody = replyNotificationTemplate.getString("body").replace("${postLink}", articleLink).replace("${postTitle}", articleTitle).replace("${replier}", commenter).replace("${replyURL}", Latkes.getServePath() + commentSharpURL).replace("${replyContent}", commentContent);
            message.setHtmlBody(mailBody);
            LOGGER.log(Level.DEBUG, "Sending a mail[mailSubject={0}, mailBody=[{1}] to [{2}]", new Object[]{mailSubject, mailBody, originalCommentEmail});
            this.mailService.send(message);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            throw new EventException("Reply notifier error!");
        }
    }

    public String getEventType() {
        return "Add Comment To Article";
    }
}

