/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.event.symphony;

import java.net.MalformedURLException;
import java.net.URL;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.event.AbstractEventListener;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.EventException;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.Lifecycle;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.urlfetch.HTTPRequest;
import org.b3log.latke.urlfetch.URLFetchService;
import org.b3log.latke.urlfetch.URLFetchServiceFactory;
import org.b3log.solo.SoloServletListener;
import org.b3log.solo.event.rhythm.ArticleSender;
import org.b3log.solo.service.PreferenceQueryService;
import org.json.JSONObject;

public final class CommentSender
extends AbstractEventListener<JSONObject> {
    private static final Logger LOGGER = Logger.getLogger((String)CommentSender.class.getName());
    private final URLFetchService urlFetchService = URLFetchServiceFactory.getURLFetchService();
    private static final URL ADD_COMMENT_URL;

    public void action(Event<JSONObject> event) throws EventException {
        JSONObject data = (JSONObject)event.getData();
        LOGGER.log(Level.DEBUG, "Processing an event[type={0}, data={1}] in listener[className={2}]", new Object[]{event.getType(), data, ArticleSender.class.getName()});
        try {
            JSONObject originalComment = data.getJSONObject("comment");
            LatkeBeanManager beanManager = Lifecycle.getBeanManager();
            PreferenceQueryService preferenceQueryService = (PreferenceQueryService)beanManager.getReference(PreferenceQueryService.class);
            JSONObject preference = preferenceQueryService.getPreference();
            if (null == preference) {
                throw new EventException("Not found preference");
            }
            if (Latkes.getServePath().contains("localhost")) {
                LOGGER.log(Level.INFO, "Blog Solo runs on local server, so should not send this comment[id={0}] to Symphony", new Object[]{originalComment.getString(Keys.OBJECT_ID)});
                return;
            }
            HTTPRequest httpRequest = new HTTPRequest();
            httpRequest.setURL(ADD_COMMENT_URL);
            httpRequest.setRequestMethod(HTTPRequestMethod.POST);
            JSONObject requestJSONObject = new JSONObject();
            JSONObject comment = new JSONObject();
            comment.put("commentId", (Object)originalComment.optString(Keys.OBJECT_ID));
            comment.put("commentAuthorName", (Object)originalComment.getString("commentName"));
            comment.put("commentAuthorEmail", (Object)originalComment.getString("commentEmail"));
            comment.put("commentContent", (Object)originalComment.getString("commentContent"));
            comment.put("articleId", (Object)originalComment.getString("commentOnId"));
            requestJSONObject.put("comment", (Object)comment);
            requestJSONObject.put("clientVersion", (Object)"1.0.0");
            requestJSONObject.put("clientRuntimeEnv", (Object)Latkes.getRuntimeEnv().name());
            requestJSONObject.put("clientName", (Object)"B3log Solo");
            requestJSONObject.put("clientHost", (Object)(Latkes.getServerHost() + ":" + Latkes.getServerPort()));
            requestJSONObject.put("clientAdminEmail", (Object)preference.optString("adminEmail"));
            requestJSONObject.put("userB3Key", (Object)preference.optString("keyOfSolo"));
            httpRequest.setPayload(requestJSONObject.toString().getBytes("UTF-8"));
            this.urlFetchService.fetchAsync(httpRequest);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Sends a comment to Symphony error: {0}", new Object[]{e.getMessage()});
        }
        LOGGER.log(Level.DEBUG, "Sent a comment to Symphony", new Object[0]);
    }

    public String getEventType() {
        return "Add Comment To Article";
    }

    static {
        try {
            ADD_COMMENT_URL = new URL(SoloServletListener.B3LOG_SYMPHONY_SERVE_PATH + "/solo/comment");
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.ERROR, "Creates remote service address[symphony add comment] error!", new Object[0]);
            throw new IllegalStateException(e);
        }
    }
}

