/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.Latkes;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.Lifecycle;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.DispatcherServlet;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.HttpControl;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.HTTP500Renderer;
import org.b3log.solo.service.InitService;

public final class InitCheckFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger((String)InitCheckFilter.class.getName());

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String requestURI = httpServletRequest.getRequestURI();
        LOGGER.log(Level.TRACE, "Request[URI={0}]", new Object[]{requestURI});
        if (requestURI.startsWith(Latkes.getContextPath() + "/latke/remote")) {
            chain.doFilter(request, response);
            return;
        }
        LatkeBeanManager beanManager = Lifecycle.getBeanManager();
        InitService initService = (InitService)beanManager.getReference(InitService.class);
        if (initService.isInited()) {
            chain.doFilter(request, response);
            return;
        }
        if ("POST".equalsIgnoreCase(httpServletRequest.getMethod()) && (Latkes.getContextPath() + "/init").equals(requestURI)) {
            chain.doFilter(request, response);
            return;
        }
        LOGGER.log(Level.INFO, "Solo has not been initialized, so redirects to /init", new Object[0]);
        HTTPRequestContext context = new HTTPRequestContext();
        context.setRequest((HttpServletRequest)request);
        context.setResponse((HttpServletResponse)response);
        request.setAttribute("requestURI", (Object)(Latkes.getContextPath() + "/init"));
        request.setAttribute("requestMethod", (Object)HTTPRequestMethod.GET.name());
        HttpControl httpControl = new HttpControl(DispatcherServlet.SYS_HANDLER.iterator(), context);
        try {
            httpControl.nextHandler();
        }
        catch (Exception e) {
            context.setRenderer((AbstractHTTPResponseRenderer)new HTTP500Renderer(e));
        }
        DispatcherServlet.result((HTTPRequestContext)context);
    }

    public void destroy() {
    }
}

