/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.Lifecycle;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.servlet.DispatcherServlet;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.HttpControl;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.HTTP500Renderer;
import org.b3log.solo.repository.ArticleRepository;
import org.b3log.solo.repository.PageRepository;
import org.b3log.solo.repository.impl.ArticleRepositoryImpl;
import org.b3log.solo.repository.impl.PageRepositoryImpl;
import org.b3log.solo.service.ArticleQueryService;
import org.b3log.solo.service.PermalinkQueryService;
import org.json.JSONObject;

public final class PermalinkFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger((String)PermalinkFilter.class.getName());

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        JSONObject article;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String requestURI = httpServletRequest.getRequestURI();
        LOGGER.log(Level.DEBUG, "Request URI[{0}]", new Object[]{requestURI});
        String contextPath = Latkes.getContextPath();
        String permalink = StringUtils.substringAfter((String)requestURI, (String)contextPath);
        if (PermalinkQueryService.invalidPermalinkFormat(permalink)) {
            LOGGER.log(Level.DEBUG, "Skip filter request[URI={0}]", new Object[]{permalink});
            chain.doFilter(request, response);
            return;
        }
        JSONObject page = null;
        LatkeBeanManager beanManager = Lifecycle.getBeanManager();
        try {
            ArticleRepository articleRepository = (ArticleRepository)beanManager.getReference(ArticleRepositoryImpl.class);
            article = articleRepository.getByPermalink(permalink);
            if (null == article) {
                PageRepository pageRepository = (PageRepository)beanManager.getReference(PageRepositoryImpl.class);
                page = pageRepository.getByPermalink(permalink);
            }
            if (null == page && null == article) {
                LOGGER.log(Level.DEBUG, "Not found article/page with permalink[{0}]", new Object[]{permalink});
                chain.doFilter(request, response);
                return;
            }
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Processes article permalink filter failed", (Throwable)e);
            httpServletResponse.sendError(404);
            return;
        }
        ArticleQueryService articleQueryService = (ArticleQueryService)beanManager.getReference(ArticleQueryService.class);
        if (null != article && articleQueryService.needViewPwd(httpServletRequest, article)) {
            try {
                httpServletResponse.sendRedirect(Latkes.getServePath() + "/console/article-pwd?articleId=" + article.optString(Keys.OBJECT_ID));
                return;
            }
            catch (Exception e) {
                httpServletResponse.sendError(404);
                return;
            }
        }
        this.dispatchToArticleOrPageProcessor(request, response, article, page);
    }

    private void dispatchToArticleOrPageProcessor(ServletRequest request, ServletResponse response, JSONObject article, JSONObject page) throws ServletException, IOException {
        HTTPRequestContext context = new HTTPRequestContext();
        context.setRequest((HttpServletRequest)request);
        context.setResponse((HttpServletResponse)response);
        if (null != article) {
            request.setAttribute("article", (Object)article);
            request.setAttribute("requestURI", (Object)(Latkes.getContextPath() + "/article"));
        } else {
            request.setAttribute("page", (Object)page);
            request.setAttribute("requestURI", (Object)(Latkes.getContextPath() + "/page"));
        }
        request.setAttribute("requestMethod", (Object)HTTPRequestMethod.GET.name());
        HttpControl httpControl = new HttpControl(DispatcherServlet.SYS_HANDLER.iterator(), context);
        try {
            httpControl.nextHandler();
        }
        catch (Exception e) {
            context.setRenderer((AbstractHTTPResponseRenderer)new HTTP500Renderer(e));
        }
        DispatcherServlet.result((HTTPRequestContext)context);
    }

    public void destroy() {
    }
}

