/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.plugin.list;

import org.b3log.latke.Latkes;
import org.b3log.latke.event.AbstractEventListener;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.EventException;
import org.b3log.latke.logging.Logger;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ListHandler
extends AbstractEventListener<JSONObject> {
    private static final Logger LOGGER = Logger.getLogger((String)ListHandler.class.getName());

    public String getEventType() {
        return "Before Render Article";
    }

    public void action(Event<JSONObject> event) throws EventException {
        JSONObject data = (JSONObject)event.getData();
        JSONObject article = data.optJSONObject("article");
        String content = article.optString("articleContent");
        Document doc = Jsoup.parse((String)content);
        StringBuilder listBuilder = new StringBuilder();
        listBuilder.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + Latkes.getStaticPath() + "/plugins/list/style.css\" />");
        Elements hs = doc.select("h1, h2, h3, h4, h5");
        listBuilder.append("<ul class='b3-solo-list'>");
        for (int i = 0; i < hs.size(); ++i) {
            Element element = hs.get(i);
            String tagName = element.tagName().toLowerCase();
            String text = element.text();
            String id = "b3_solo_" + tagName + "_" + i;
            element.before("<span id='" + id + "'></span>");
            listBuilder.append("<li class='b3-solo-list-").append(tagName).append("'><a href='#").append(id).append("'>").append(text).append("</a></li>");
        }
        listBuilder.append("</ul>");
        Element body = doc.getElementsByTag("body").get(0);
        content = listBuilder.toString() + body.html();
        article.put("articleContent", (Object)content);
    }
}

