/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.b3log.latke.util.Requests;
import org.b3log.solo.service.CommentMgmtService;
import org.b3log.solo.service.UserMgmtService;
import org.b3log.solo.service.UserQueryService;
import org.json.JSONObject;

@RequestProcessor
public class CommentProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)CommentProcessor.class.getName());
    @Inject
    private LangPropsService langPropsService;
    @Inject
    private CommentMgmtService commentMgmtService;
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private UserMgmtService userMgmtService;

    @RequestProcessing(value={"/add-page-comment.do"}, method={HTTPRequestMethod.POST})
    public void addPageComment(HTTPRequestContext context) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = context.getRequest();
        HttpServletResponse httpServletResponse = context.getResponse();
        JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        requestJSONObject.put("type", (Object)"page");
        this.fillCommenter(requestJSONObject, httpServletRequest, httpServletResponse);
        JSONObject jsonObject = this.commentMgmtService.checkAddCommentRequest(requestJSONObject);
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setJSONObject(jsonObject);
        if (!jsonObject.optBoolean("sc")) {
            LOGGER.log(Level.WARN, "Can't add comment[msg={0}]", new Object[]{jsonObject.optString("msg")});
            return;
        }
        HttpSession session = httpServletRequest.getSession(false);
        if (null == session) {
            jsonObject.put("sc", false);
            jsonObject.put("msg", (Object)this.langPropsService.get("captchaErrorLabel"));
            return;
        }
        String storedCaptcha = (String)session.getAttribute("captcha");
        session.removeAttribute("captcha");
        if (!this.userQueryService.isLoggedIn(httpServletRequest, httpServletResponse)) {
            String captcha = requestJSONObject.optString("captcha");
            if (null == storedCaptcha || !storedCaptcha.equals(captcha)) {
                jsonObject.put("sc", false);
                jsonObject.put("msg", (Object)this.langPropsService.get("captchaErrorLabel"));
                return;
            }
        }
        try {
            JSONObject addResult = this.commentMgmtService.addPageComment(requestJSONObject);
            addResult.put("sc", true);
            renderer.setJSONObject(addResult);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Can not add comment on page", (Throwable)e);
            jsonObject.put("sc", false);
            jsonObject.put("msg", (Object)this.langPropsService.get("addFailLabel"));
        }
    }

    @RequestProcessing(value={"/add-article-comment.do"}, method={HTTPRequestMethod.POST})
    public void addArticleComment(HTTPRequestContext context) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = context.getRequest();
        HttpServletResponse httpServletResponse = context.getResponse();
        JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        requestJSONObject.put("type", (Object)"article");
        this.fillCommenter(requestJSONObject, httpServletRequest, httpServletResponse);
        JSONObject jsonObject = this.commentMgmtService.checkAddCommentRequest(requestJSONObject);
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setJSONObject(jsonObject);
        if (!jsonObject.optBoolean("sc")) {
            LOGGER.log(Level.WARN, "Can't add comment[msg={0}]", new Object[]{jsonObject.optString("msg")});
            return;
        }
        HttpSession session = httpServletRequest.getSession(false);
        if (null == session) {
            jsonObject.put("sc", false);
            jsonObject.put("msg", (Object)this.langPropsService.get("captchaErrorLabel"));
            return;
        }
        String storedCaptcha = (String)session.getAttribute("captcha");
        session.removeAttribute("captcha");
        if (!this.userQueryService.isLoggedIn(httpServletRequest, httpServletResponse)) {
            String captcha = requestJSONObject.optString("captcha");
            if (null == storedCaptcha || !storedCaptcha.equals(captcha)) {
                jsonObject.put("sc", false);
                jsonObject.put("msg", (Object)this.langPropsService.get("captchaErrorLabel"));
                return;
            }
        }
        try {
            JSONObject addResult = this.commentMgmtService.addArticleComment(requestJSONObject);
            addResult.put("sc", true);
            renderer.setJSONObject(addResult);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Can not add comment on article", (Throwable)e);
            jsonObject.put("sc", false);
            jsonObject.put("msg", (Object)this.langPropsService.get("addFailLabel"));
        }
    }

    private void fillCommenter(JSONObject requestJSONObject, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.userMgmtService.tryLogInWithCookie(httpServletRequest, httpServletResponse);
        JSONObject currentUser = this.userQueryService.getCurrentUser(httpServletRequest);
        if (null == currentUser) {
            return;
        }
        requestJSONObject.put("commentName", (Object)currentUser.optString("userName"));
        requestJSONObject.put("commentEmail", (Object)currentUser.optString("userEmail"));
        requestJSONObject.put("commentURL", (Object)currentUser.optString("userURL"));
    }
}

