/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor;

import freemarker.template.Template;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.Keys;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.URIPatternMode;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.freemarker.AbstractFreeMarkerRenderer;
import org.b3log.latke.servlet.renderer.freemarker.FreeMarkerRenderer;
import org.b3log.latke.util.Locales;
import org.b3log.latke.util.Requests;
import org.b3log.solo.processor.renderer.ConsoleRenderer;
import org.b3log.solo.processor.util.Filler;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.StatisticMgmtService;
import org.b3log.solo.util.Skins;
import org.json.JSONObject;

@RequestProcessor
public class IndexProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)IndexProcessor.class.getName());
    @Inject
    private Filler filler;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private LangPropsService langPropsService;
    @Inject
    private StatisticMgmtService statisticMgmtService;

    @RequestProcessing(value={"/\\d*", ""}, uriPatternsMode=URIPatternMode.REGEX, method={HTTPRequestMethod.GET})
    public void showIndex(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) {
        FreeMarkerRenderer renderer = new FreeMarkerRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setTemplateName("index.ftl");
        Map dataModel = renderer.getDataModel();
        String requestURI = request.getRequestURI();
        try {
            int currentPageNum = IndexProcessor.getCurrentPageNum(requestURI);
            JSONObject preference = this.preferenceQueryService.getPreference();
            Skins.fillLangs(preference.optString("localeString"), (String)request.getAttribute("templateDirName"), dataModel);
            this.filler.fillIndexArticles(request, dataModel, currentPageNum, preference);
            this.filler.fillSide(request, dataModel, preference);
            this.filler.fillBlogHeader(request, response, dataModel, preference);
            this.filler.fillBlogFooter(request, dataModel, preference);
            dataModel.put("paginationCurrentPageNum", currentPageNum);
            int previousPageNum = currentPageNum > 1 ? currentPageNum - 1 : 0;
            dataModel.put("paginationPreviousPageNum", previousPageNum);
            Integer pageCount = (Integer)dataModel.get("paginationPageCount");
            int nextPageNum = currentPageNum + 1 > pageCount ? pageCount : currentPageNum + 1;
            dataModel.put("paginationNextPageNum", nextPageNum);
            dataModel.put("path", "");
            this.statisticMgmtService.incBlogViewCount(request, response);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            try {
                response.sendError(404);
            }
            catch (IOException ex) {
                LOGGER.error(ex.getMessage());
            }
        }
    }

    @RequestProcessing(value={"/kill-browser"}, method={HTTPRequestMethod.GET})
    public void showKillBrowser(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) {
        KillBrowserRenderer renderer = new KillBrowserRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        Map dataModel = renderer.getDataModel();
        try {
            Map langs = this.langPropsService.getAll(Locales.getLocale((HttpServletRequest)request));
            dataModel.putAll(langs);
            JSONObject preference = this.preferenceQueryService.getPreference();
            this.filler.fillBlogFooter(request, dataModel, preference);
            Keys.fillRuntime((Map)dataModel);
            this.filler.fillMinified(dataModel);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            try {
                response.sendError(404);
            }
            catch (IOException ex) {
                LOGGER.error(ex.getMessage());
            }
        }
    }

    @RequestProcessing(value={"/register"}, method={HTTPRequestMethod.GET})
    public void register(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) {
        ConsoleRenderer renderer = new ConsoleRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setTemplateName("register.ftl");
        Map dataModel = renderer.getDataModel();
        try {
            Map langs = this.langPropsService.getAll(Locales.getLocale((HttpServletRequest)request));
            dataModel.putAll(langs);
            JSONObject preference = this.preferenceQueryService.getPreference();
            this.filler.fillBlogFooter(request, dataModel, preference);
            this.filler.fillMinified(dataModel);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            try {
                response.sendError(404);
            }
            catch (IOException ex) {
                LOGGER.error(ex.getMessage());
            }
        }
    }

    private static int getCurrentPageNum(String requestURI) {
        String pageNumString = StringUtils.substringAfterLast((String)requestURI, (String)"/");
        return Requests.getCurrentPageNum((String)pageNumString);
    }

    private static final class KillBrowserRenderer
    extends AbstractFreeMarkerRenderer {
        private static final Logger LOGGER = Logger.getLogger((String)KillBrowserRenderer.class.getName());

        private KillBrowserRenderer() {
        }

        public void render(HTTPRequestContext context) {
            HttpServletResponse response = context.getResponse();
            response.setContentType("text/html");
            response.setCharacterEncoding("UTF-8");
            try {
                Template template = ConsoleRenderer.TEMPLATE_CFG.getTemplate("kill-browser.ftl");
                PrintWriter writer = response.getWriter();
                StringWriter stringWriter = new StringWriter();
                template.setOutputEncoding("UTF-8");
                template.process((Object)this.getDataModel(), (Writer)stringWriter);
                String pageContent = stringWriter.toString();
                writer.write(pageContent);
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                try {
                    response.sendError(500);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.ERROR, "Can not sned error 500!", (Throwable)ex);
                }
            }
        }

        protected void afterRender(HTTPRequestContext context) throws Exception {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void beforeRender(HTTPRequestContext context) throws Exception {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

