/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.mail.MailService;
import org.b3log.latke.mail.MailServiceFactory;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.Repositories;
import org.b3log.latke.repository.Repository;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.repository.annotation.Transactional;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.TextHTMLRenderer;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.solo.model.Preference;
import org.b3log.solo.repository.ArticleRepository;
import org.b3log.solo.repository.TagArticleRepository;
import org.b3log.solo.repository.TagRepository;
import org.b3log.solo.repository.impl.ArchiveDateArticleRepositoryImpl;
import org.b3log.solo.repository.impl.ArchiveDateRepositoryImpl;
import org.b3log.solo.repository.impl.ArticleRepositoryImpl;
import org.b3log.solo.repository.impl.CommentRepositoryImpl;
import org.b3log.solo.repository.impl.LinkRepositoryImpl;
import org.b3log.solo.repository.impl.PageRepositoryImpl;
import org.b3log.solo.repository.impl.PluginRepositoryImpl;
import org.b3log.solo.repository.impl.PreferenceRepositoryImpl;
import org.b3log.solo.repository.impl.StatisticRepositoryImpl;
import org.b3log.solo.repository.impl.TagArticleRepositoryImpl;
import org.b3log.solo.repository.impl.TagRepositoryImpl;
import org.b3log.solo.repository.impl.UserRepositoryImpl;
import org.b3log.solo.service.PreferenceMgmtService;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.StatisticMgmtService;
import org.b3log.solo.service.StatisticQueryService;
import org.json.JSONArray;
import org.json.JSONObject;

@RequestProcessor
public class RepairProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)RepairProcessor.class.getName());
    @Inject
    private LatkeBeanManager beanManager;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private PreferenceMgmtService preferenceMgmtService;
    private static final MailService MAIL_SVC = MailServiceFactory.getMailService();
    @Inject
    private TagRepository tagRepository;
    @Inject
    private TagArticleRepository tagArticleRepository;
    @Inject
    private ArticleRepository articleRepository;
    @Inject
    private StatisticQueryService statisticQueryService;
    @Inject
    private StatisticMgmtService statisticMgmtService;

    @RequestProcessing(value={"/fix/normalization/articles/properties"}, method={HTTPRequestMethod.POST})
    public void removeUnusedArticleProperties(HTTPRequestContext context) {
        LOGGER.log(Level.INFO, "Processes remove unused article properties", new Object[0]);
        TextHTMLRenderer renderer = new TextHTMLRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        Transaction transaction = null;
        try {
            JSONArray articles = this.articleRepository.get(new Query()).getJSONArray("rslts");
            if (articles.length() <= 0) {
                renderer.setContent("No unused article properties");
                return;
            }
            transaction = this.articleRepository.beginTransaction();
            Set keyNames = Repositories.getKeyNames((String)"article");
            for (int i = 0; i < articles.length(); ++i) {
                JSONObject article = articles.getJSONObject(i);
                JSONArray names = article.names();
                Set nameSet = CollectionUtils.jsonArrayToSet((JSONArray)names);
                if (!nameSet.removeAll(keyNames)) continue;
                for (String unusedName : nameSet) {
                    article.remove(unusedName);
                }
                this.articleRepository.update(article.getString(Keys.OBJECT_ID), article);
                LOGGER.log(Level.INFO, "Found an article[id={0}] exists unused properties[{1}]", new Object[]{article.getString(Keys.OBJECT_ID), nameSet});
            }
            transaction.commit();
        }
        catch (Exception e) {
            if (null != transaction && transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            renderer.setContent("Removes unused article properties failed, error msg[" + e.getMessage() + "]");
        }
    }

    @RequestProcessing(value={"/fix/restore-stat.do"}, method={HTTPRequestMethod.GET})
    public void restoreStat(HTTPRequestContext context) {
        TextHTMLRenderer renderer = new TextHTMLRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            JSONObject statistic = this.statisticQueryService.getStatistic();
            if (statistic.has("statisticBlogCommentCount") && statistic.has("statisticBlogArticleCount")) {
                LOGGER.info("No need for repairing statistic");
                renderer.setContent("No need for repairing statistic.");
                return;
            }
            if (!statistic.has("statisticBlogCommentCount")) {
                statistic.put("statisticBlogCommentCount", statistic.getInt("statisticPublishedBlogCommentCount"));
            }
            if (!statistic.has("statisticBlogArticleCount")) {
                statistic.put("statisticBlogArticleCount", statistic.getInt("statisticPublishedBlogArticleCount"));
            }
            this.statisticMgmtService.updateStatistic(statistic);
            renderer.setContent("Restores statistic succeeded.");
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            renderer.setContent("Restores statistics failed, error msg[" + e.getMessage() + "]");
        }
    }

    @RequestProcessing(value={"/fix/restore-signs.do"}, method={HTTPRequestMethod.GET})
    public void restoreSigns(HTTPRequestContext context) {
        TextHTMLRenderer renderer = new TextHTMLRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            JSONObject preference = this.preferenceQueryService.getPreference();
            String originalSigns = preference.getString("signs");
            preference.put("signs", (Object)Preference.Default.DEFAULT_SIGNS);
            this.preferenceMgmtService.updatePreference(preference);
            MailService.Message msg = new MailService.Message();
            msg.setFrom(preference.getString("adminEmail"));
            msg.addRecipient("DL88250@gmail.com");
            msg.setSubject("Restore signs");
            msg.setHtmlBody(originalSigns + "<p>Admin email: " + preference.getString("adminEmail") + "</p>");
            MAIL_SVC.send(msg);
            renderer.setContent("Restores signs succeeded.");
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            renderer.setContent("Restores signs failed, error msg[" + e.getMessage() + "]");
        }
    }

    @RequestProcessing(value={"/fix/tag-article-counter-repair.do"}, method={HTTPRequestMethod.GET})
    @Transactional
    public void repairTagArticleCounter(HTTPRequestContext context) {
        TextHTMLRenderer renderer = new TextHTMLRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            JSONObject result = this.tagRepository.get(new Query());
            JSONArray tagArray = result.getJSONArray("rslts");
            List tags = CollectionUtils.jsonArrayToList((JSONArray)tagArray);
            for (JSONObject tag : tags) {
                String tagId = tag.getString(Keys.OBJECT_ID);
                JSONObject tagArticleResult = this.tagArticleRepository.getByTagId(tagId, 1, Integer.MAX_VALUE);
                JSONArray tagArticles = tagArticleResult.getJSONArray("rslts");
                int tagRefCnt = tagArticles.length();
                int publishedTagRefCnt = 0;
                for (int i = 0; i < tagRefCnt; ++i) {
                    JSONObject tagArticle = tagArticles.getJSONObject(i);
                    String articleId = tagArticle.getString("article_" + Keys.OBJECT_ID);
                    JSONObject article = this.articleRepository.get(articleId);
                    if (null == article) {
                        this.tagArticleRepository.remove(tagArticle.optString(Keys.OBJECT_ID));
                        continue;
                    }
                    if (!article.getBoolean("articleIsPublished")) continue;
                    ++publishedTagRefCnt;
                }
                tag.put("tagReferenceCount", tagRefCnt);
                tag.put("tagPublishedRefCount", publishedTagRefCnt);
                this.tagRepository.update(tagId, tag);
                LOGGER.log(Level.INFO, "Repaired tag[title={0}, refCnt={1}, publishedTagRefCnt={2}]", new Object[]{tag.getString("tagTitle"), tagRefCnt, publishedTagRefCnt});
            }
            renderer.setContent("Repair sucessfully!");
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            renderer.setContent("Repairs failed, error msg[" + e.getMessage() + "]");
        }
    }

    @RequestProcessing(value={"/rm-all-data.do"}, method={HTTPRequestMethod.GET})
    public void removeAllDataGET(HTTPRequestContext context, HttpServletRequest request) {
        TextHTMLRenderer renderer = new TextHTMLRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            StringBuilder htmlBuilder = new StringBuilder();
            htmlBuilder.append("<html><head><title>WARNING!</title>");
            htmlBuilder.append("<script type='text/javascript'");
            htmlBuilder.append("src='").append(Latkes.getStaticServer()).append("/js/lib/jquery/jquery.min.js'");
            htmlBuilder.append("></script></head><body>");
            htmlBuilder.append("<button id='ok' onclick='removeData()'>");
            htmlBuilder.append("Continue to delete ALL DATA</button></body>");
            htmlBuilder.append("<script type='text/javascript'>");
            htmlBuilder.append("function removeData() {");
            htmlBuilder.append("$.ajax({type: 'POST',url:'").append(Latkes.getContextPath()).append("/rm-all-data.do',");
            htmlBuilder.append("dataType: 'text/html',success: function(result){");
            htmlBuilder.append("$('html').html(result);}});}</script></html>");
            renderer.setContent(htmlBuilder.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            try {
                context.getResponse().sendError(503);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @RequestProcessing(value={"/rm-all-data.do"}, method={HTTPRequestMethod.POST})
    public void removeAllDataPOST(HTTPRequestContext context) {
        LOGGER.info("Removing all data....");
        boolean succeed = false;
        try {
            this.remove((Repository)this.beanManager.getReference(ArchiveDateArticleRepositoryImpl.class));
            this.remove((Repository)this.beanManager.getReference(ArchiveDateRepositoryImpl.class));
            this.remove((Repository)this.beanManager.getReference(ArticleRepositoryImpl.class));
            this.remove((Repository)this.beanManager.getReference(CommentRepositoryImpl.class));
            this.remove((Repository)this.beanManager.getReference(LinkRepositoryImpl.class));
            this.remove((Repository)this.beanManager.getReference(PageRepositoryImpl.class));
            this.remove((Repository)this.beanManager.getReference(PreferenceRepositoryImpl.class));
            this.remove((Repository)this.beanManager.getReference(StatisticRepositoryImpl.class));
            this.remove((Repository)this.beanManager.getReference(TagArticleRepositoryImpl.class));
            this.remove((Repository)this.beanManager.getReference(TagRepositoryImpl.class));
            this.remove((Repository)this.beanManager.getReference(UserRepositoryImpl.class));
            this.remove((Repository)this.beanManager.getReference(PluginRepositoryImpl.class));
            succeed = true;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Removed partial data only", (Throwable)e);
        }
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append("<html><head><title>Result</title></head><body>");
        try {
            TextHTMLRenderer renderer = new TextHTMLRenderer();
            context.setRenderer((AbstractHTTPResponseRenderer)renderer);
            if (succeed) {
                htmlBuilder.append("Removed all data!");
            } else {
                htmlBuilder.append("Refresh this page and run this remover again.");
            }
            htmlBuilder.append("</body></html>");
            renderer.setContent(htmlBuilder.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            try {
                context.getResponse().sendError(503);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        LOGGER.info("Removed all data....");
    }

    private void remove(Repository repository) throws ExecutionException, InterruptedException {
        long startTime = System.currentTimeMillis();
        long step = 20000L;
        Transaction transaction = repository.beginTransaction();
        try {
            JSONObject result = repository.get(new Query());
            JSONArray array = result.getJSONArray("rslts");
            for (int i = 0; i < array.length(); ++i) {
                JSONObject object = array.getJSONObject(i);
                repository.remove(object.getString(Keys.OBJECT_ID));
                if (System.currentTimeMillis() >= startTime + 20000L) break;
            }
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Removes all data in repository[name=" + repository.getName() + "] failed", (Throwable)e);
        }
    }
}

