/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor;

import freemarker.template.Template;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.freemarker.FreeMarkerRenderer;
import org.b3log.latke.util.Locales;
import org.b3log.latke.util.freemarker.Templates;
import org.b3log.solo.processor.ArticleProcessor;
import org.b3log.solo.processor.util.Filler;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.StatisticMgmtService;
import org.b3log.solo.util.Skins;
import org.json.JSONObject;

@RequestProcessor
public class UserTemplateProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)ArticleProcessor.class.getName());
    @Inject
    private Filler filler;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private LangPropsService langPropsService;
    @Inject
    private StatisticMgmtService statisticMgmtService;

    @RequestProcessing(value={"/*.html"}, method={HTTPRequestMethod.GET})
    public void showPage(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestURI = request.getRequestURI();
        String templateName = StringUtils.substringAfterLast((String)requestURI, (String)"/");
        templateName = StringUtils.substringBefore((String)templateName, (String)".") + ".ftl";
        LOGGER.log(Level.DEBUG, "Shows page[requestURI={0}, templateName={1}]", new Object[]{requestURI, templateName});
        FreeMarkerRenderer renderer = new FreeMarkerRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        renderer.setTemplateName(templateName);
        Map dataModel = renderer.getDataModel();
        Template template = Templates.getTemplate((String)((String)request.getAttribute("templateDirName")), (String)templateName);
        if (null == template) {
            try {
                response.sendError(404);
                return;
            }
            catch (IOException ex) {
                LOGGER.error(ex.getMessage());
            }
        }
        try {
            Map langs = this.langPropsService.getAll(Locales.getLocale((HttpServletRequest)request));
            dataModel.putAll(langs);
            JSONObject preference = this.preferenceQueryService.getPreference();
            this.filler.fillBlogHeader(request, response, dataModel, preference);
            this.filler.fillUserTemplate(request, template, dataModel, preference);
            this.filler.fillBlogFooter(request, dataModel, preference);
            Skins.fillLangs(preference.optString("localeString"), (String)request.getAttribute("templateDirName"), dataModel);
            this.statisticMgmtService.incBlogViewCount(request, response);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            try {
                response.sendError(404);
            }
            catch (IOException ex) {
                LOGGER.error(ex.getMessage());
            }
        }
    }
}

