/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor.console;

import com.qiniu.util.Auth;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.EventException;
import org.b3log.latke.event.EventManager;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.plugin.ViewLoadEventData;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.util.Strings;
import org.b3log.solo.processor.renderer.ConsoleRenderer;
import org.b3log.solo.processor.util.Filler;
import org.b3log.solo.service.OptionQueryService;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.UserQueryService;
import org.b3log.solo.util.Thumbnails;
import org.json.JSONObject;

@RequestProcessor
public class AdminConsole {
    private static final Logger LOGGER = Logger.getLogger((String)AdminConsole.class.getName());
    @Inject
    private LangPropsService langPropsService;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private OptionQueryService optionQueryService;
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private Filler filler;
    @Inject
    private EventManager eventManager;

    @RequestProcessing(value={"/admin-index.do"}, method={HTTPRequestMethod.GET})
    public void showAdminIndex(HttpServletRequest request, HTTPRequestContext context) {
        ConsoleRenderer renderer = new ConsoleRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        String templateName = "admin-index.ftl";
        renderer.setTemplateName("admin-index.ftl");
        Map langs = this.langPropsService.getAll(Latkes.getLocale());
        Map dataModel = renderer.getDataModel();
        dataModel.putAll(langs);
        JSONObject currentUser = this.userQueryService.getCurrentUser(request);
        String userName = currentUser.optString("userName");
        dataModel.put("userName", userName);
        String roleName = currentUser.optString("userRole");
        dataModel.put("userRole", roleName);
        String email = currentUser.optString("userEmail");
        String gravatar = Thumbnails.getGravatarURL(email, "60");
        dataModel.put("gravatar", gravatar);
        try {
            JSONObject qiniu = this.optionQueryService.getOptions("qiniu");
            dataModel.put("qiniuDomain", "");
            dataModel.put("qiniuUploadToken", "");
            if (null != qiniu) {
                Auth auth = Auth.create((String)qiniu.optString("qiniuAccessKey"), (String)qiniu.optString("qiniuSecretKey"));
                String uploadToken = auth.uploadToken(qiniu.optString("qiniuBucket"));
                dataModel.put("qiniuUploadToken", uploadToken);
                dataModel.put("qiniuDomain", qiniu.optString("qiniuDomain"));
            }
            JSONObject preference = this.preferenceQueryService.getPreference();
            dataModel.put("localeString", preference.getString("localeString"));
            dataModel.put("blogTitle", preference.getString("blogTitle"));
            dataModel.put("blogSubtitle", preference.getString("blogSubtitle"));
            dataModel.put("version", "1.0.0");
            dataModel.put("staticResourceVersion", Latkes.getStaticResourceVersion());
            dataModel.put("year", String.valueOf(Calendar.getInstance().get(1)));
            dataModel.put("articleListDisplayCount", preference.getInt("articleListDisplayCount"));
            dataModel.put("articleListPaginationWindowSize", preference.getInt("articleListPaginationWindowSize"));
            dataModel.put("localeString", preference.getString("localeString"));
            dataModel.put("editorType", preference.getString("editorType"));
            dataModel.put("skinDirName", preference.getString("skinDirName"));
            Keys.fillRuntime((Map)dataModel);
            this.filler.fillMinified(dataModel);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Admin index render failed", (Throwable)e);
        }
        this.fireFreeMarkerActionEvent("admin-index.ftl", dataModel);
    }

    @RequestProcessing(value={"/admin-article.do", "/admin-article-list.do", "/admin-comment-list.do", "/admin-link-list.do", "/admin-page-list.do", "/admin-others.do", "/admin-draft-list.do", "/admin-user-list.do", "/admin-plugin-list.do", "/admin-main.do", "/admin-about.do"}, method={HTTPRequestMethod.GET})
    public void showAdminFunctions(HttpServletRequest request, HTTPRequestContext context) {
        ConsoleRenderer renderer = new ConsoleRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        String requestURI = request.getRequestURI();
        String templateName = StringUtils.substringBetween((String)requestURI, (String)(Latkes.getContextPath() + '/'), (String)".") + ".ftl";
        LOGGER.log(Level.TRACE, "Admin function[templateName={0}]", new Object[]{templateName});
        renderer.setTemplateName(templateName);
        Locale locale = Latkes.getLocale();
        Map langs = this.langPropsService.getAll(locale);
        Map dataModel = renderer.getDataModel();
        dataModel.putAll(langs);
        Keys.fillRuntime((Map)dataModel);
        dataModel.put("localeString", locale.toString());
        this.fireFreeMarkerActionEvent(templateName, dataModel);
    }

    @RequestProcessing(value={"/admin-preference.do"}, method={HTTPRequestMethod.GET})
    public void showAdminPreferenceFunction(HttpServletRequest request, HTTPRequestContext context) {
        ConsoleRenderer renderer = new ConsoleRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        String templateName = "admin-preference.ftl";
        renderer.setTemplateName("admin-preference.ftl");
        Locale locale = Latkes.getLocale();
        Map langs = this.langPropsService.getAll(locale);
        Map dataModel = renderer.getDataModel();
        dataModel.putAll(langs);
        dataModel.put("localeString", locale.toString());
        JSONObject preference = null;
        try {
            preference = this.preferenceQueryService.getPreference();
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, "Loads preference failed", (Throwable)e);
        }
        StringBuilder timeZoneIdOptions = new StringBuilder();
        String[] availableIDs = TimeZone.getAvailableIDs();
        for (int i = 0; i < availableIDs.length; ++i) {
            String id = availableIDs[i];
            String option = id.equals(preference.optString("timeZoneId")) ? "<option value=\"" + id + "\" selected=\"true\">" + id + "</option>" : "<option value=\"" + id + "\">" + id + "</option>";
            timeZoneIdOptions.append(option);
        }
        dataModel.put("timeZoneIdOptions", timeZoneIdOptions.toString());
        this.fireFreeMarkerActionEvent("admin-preference.ftl", dataModel);
    }

    private void fireFreeMarkerActionEvent(String hostTemplateName, Map<String, Object> dataModel) {
        try {
            ViewLoadEventData data = new ViewLoadEventData();
            data.setViewName(hostTemplateName);
            data.setDataModel(dataModel);
            this.eventManager.fireEventSynchronously(new Event("FreeMarkerAction", (Object)data));
            if (Strings.isEmptyOrNull((String)((String)dataModel.get("plugins")))) {
                dataModel.put("plugins", "");
            }
        }
        catch (EventException e) {
            LOGGER.log(Level.WARN, "Event[FREEMARKER_ACTION] handle failed, ignores this exception for kernel health", (Throwable)e);
        }
    }
}

