/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor.console;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.b3log.latke.util.Requests;
import org.b3log.latke.util.Strings;
import org.b3log.solo.service.ArticleMgmtService;
import org.b3log.solo.service.ArticleQueryService;
import org.b3log.solo.service.UserQueryService;
import org.b3log.solo.util.Markdowns;
import org.b3log.solo.util.QueryResults;
import org.json.JSONArray;
import org.json.JSONObject;

@RequestProcessor
public class ArticleConsole {
    private static final Logger LOGGER = Logger.getLogger((String)ArticleConsole.class.getName());
    @Inject
    private ArticleMgmtService articleMgmtService;
    @Inject
    private ArticleQueryService articleQueryService;
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private LangPropsService langPropsService;

    @RequestProcessing(value={"/console/markdown/2html"}, method={HTTPRequestMethod.POST})
    public void markdown2HTML(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject result = new JSONObject();
        renderer.setJSONObject(result);
        result.put("sc", true);
        JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
        String markdownText = requestJSONObject.getString("markdownText");
        if (Strings.isEmptyOrNull((String)markdownText)) {
            result.put("html", (Object)"");
            return;
        }
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        try {
            String html = Markdowns.toHTML(markdownText);
            result.put("html", (Object)html);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/article/*"}, method={HTTPRequestMethod.GET})
    public void getArticle(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            String articleId = request.getRequestURI().substring((Latkes.getContextPath() + "/console/article/").length());
            JSONObject result = this.articleQueryService.getArticle(articleId);
            result.put("sc", true);
            renderer.setJSONObject(result);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/articles/status/*/*/*/*"}, method={HTTPRequestMethod.GET})
    public void getArticles(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            String path = request.getRequestURI().substring((Latkes.getContextPath() + "/console/articles/status/").length());
            String status = StringUtils.substringBefore((String)path, (String)"/");
            path = path.substring((status + "/").length());
            boolean published = "published".equals(status);
            JSONObject requestJSONObject = Requests.buildPaginationRequest((String)path);
            requestJSONObject.put("articleIsPublished", published);
            JSONArray excludes = new JSONArray();
            excludes.put((Object)"articleContent");
            excludes.put((Object)"articleUpdateDate");
            excludes.put((Object)"articleCreateDate");
            excludes.put((Object)"articleAuthorEmail");
            excludes.put((Object)"articleHadBeenPublished");
            excludes.put((Object)"articleIsPublished");
            excludes.put((Object)"articleRandomDouble");
            requestJSONObject.put("excludes", (Object)excludes);
            JSONObject result = this.articleQueryService.getArticles(requestJSONObject);
            result.put("sc", true);
            renderer.setJSONObject(result);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/article/{articleId}"}, method={HTTPRequestMethod.DELETE})
    public void removeArticle(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response, String articleId) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        renderer.setJSONObject(ret);
        try {
            if (!this.articleQueryService.canAccessArticle(articleId, request)) {
                ret.put("sc", false);
                ret.put("msg", (Object)this.langPropsService.get("forbiddenLabel"));
                return;
            }
            this.articleMgmtService.removeArticle(articleId);
            ret.put("sc", true);
            ret.put("msg", (Object)this.langPropsService.get("removeSuccLabel"));
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = new JSONObject();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("sc", false);
            jsonObject.put("msg", (Object)this.langPropsService.get("removeFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/article/unpublish/*"}, method={HTTPRequestMethod.PUT})
    public void cancelPublishArticle(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        renderer.setJSONObject(ret);
        try {
            String articleId = request.getRequestURI().substring((Latkes.getContextPath() + "/console/article/unpublish/").length());
            if (!this.articleQueryService.canAccessArticle(articleId, request)) {
                ret.put("sc", false);
                ret.put("msg", (Object)this.langPropsService.get("forbiddenLabel"));
                return;
            }
            this.articleMgmtService.cancelPublishArticle(articleId);
            ret.put("sc", true);
            ret.put("msg", (Object)this.langPropsService.get("unPulbishSuccLabel"));
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = new JSONObject();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("sc", false);
            jsonObject.put("msg", (Object)this.langPropsService.get("unPulbishFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/article/canceltop/*"}, method={HTTPRequestMethod.PUT})
    public void cancelTopArticle(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        renderer.setJSONObject(ret);
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            ret.put("msg", (Object)this.langPropsService.get("forbiddenLabel"));
            ret.put("sc", false);
            return;
        }
        try {
            String articleId = request.getRequestURI().substring((Latkes.getContextPath() + "/console/article/canceltop/").length());
            this.articleMgmtService.topArticle(articleId, false);
            ret.put("sc", true);
            ret.put("msg", (Object)this.langPropsService.get("cancelTopSuccLabel"));
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = new JSONObject();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("sc", false);
            jsonObject.put("msg", (Object)this.langPropsService.get("cancelTopFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/article/puttop/*"}, method={HTTPRequestMethod.PUT})
    public void putTopArticle(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        renderer.setJSONObject(ret);
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            ret.put("msg", (Object)this.langPropsService.get("forbiddenLabel"));
            ret.put("sc", false);
            return;
        }
        try {
            String articleId = request.getRequestURI().substring((Latkes.getContextPath() + "/console/article/puttop/").length());
            this.articleMgmtService.topArticle(articleId, true);
            ret.put("sc", true);
            ret.put("msg", (Object)this.langPropsService.get("putTopSuccLabel"));
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = new JSONObject();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("sc", false);
            jsonObject.put("msg", (Object)this.langPropsService.get("putTopFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/article/"}, method={HTTPRequestMethod.PUT})
    public void updateArticle(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            JSONObject article = requestJSONObject.getJSONObject("article");
            String articleId = article.getString(Keys.OBJECT_ID);
            renderer.setJSONObject(ret);
            if (!this.articleQueryService.canAccessArticle(articleId, request)) {
                ret.put("msg", (Object)this.langPropsService.get("forbiddenLabel"));
                ret.put("sc", false);
                return;
            }
            this.articleMgmtService.updateArticle(requestJSONObject);
            ret.put("msg", (Object)this.langPropsService.get("updateSuccLabel"));
            ret.put("sc", true);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)e.getMessage());
        }
    }

    @RequestProcessing(value={"/console/article/"}, method={HTTPRequestMethod.POST})
    public void addArticle(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            JSONObject currentUser = this.userQueryService.getCurrentUser(request);
            requestJSONObject.getJSONObject("article").put("articleAuthorEmail", (Object)currentUser.getString("userEmail"));
            String articleId = this.articleMgmtService.addArticle(requestJSONObject);
            ret.put(Keys.OBJECT_ID, (Object)articleId);
            ret.put("msg", (Object)this.langPropsService.get("addSuccLabel"));
            ret.put("sc", true);
            renderer.setJSONObject(ret);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), new Object[0]);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)e.getMessage());
        }
    }
}

