/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor.console;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.b3log.latke.util.Requests;
import org.b3log.solo.service.PageMgmtService;
import org.b3log.solo.service.PageQueryService;
import org.b3log.solo.service.UserQueryService;
import org.b3log.solo.util.QueryResults;
import org.json.JSONArray;
import org.json.JSONObject;

@RequestProcessor
public class PageConsole {
    private static final Logger LOGGER = Logger.getLogger((String)PageConsole.class.getName());
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private PageQueryService pageQueryService;
    @Inject
    private PageMgmtService pageMgmtService;
    @Inject
    private LangPropsService langPropsService;

    @RequestProcessing(value={"/console/page/"}, method={HTTPRequestMethod.PUT})
    public void updatePage(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            this.pageMgmtService.updatePage(requestJSONObject);
            ret.put("sc", true);
            ret.put("msg", (Object)this.langPropsService.get("updateSuccLabel"));
            renderer.setJSONObject(ret);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)e.getMessage());
        }
    }

    @RequestProcessing(value={"/console/page/*"}, method={HTTPRequestMethod.DELETE})
    public void removePage(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        try {
            String pageId = request.getRequestURI().substring((Latkes.getContextPath() + "/console/page/").length());
            this.pageMgmtService.removePage(pageId);
            jsonObject.put("sc", true);
            jsonObject.put("msg", (Object)this.langPropsService.get("removeSuccLabel"));
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            jsonObject.put("sc", false);
            jsonObject.put("msg", (Object)this.langPropsService.get("removeFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/page/"}, method={HTTPRequestMethod.POST})
    public void addPage(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            String pageId = this.pageMgmtService.addPage(requestJSONObject);
            ret.put(Keys.OBJECT_ID, (Object)pageId);
            ret.put("msg", (Object)this.langPropsService.get("addSuccLabel"));
            ret.put("sc", true);
            renderer.setJSONObject(ret);
        }
        catch (ServiceException e) {
            LOGGER.log(Level.WARN, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)e.getMessage());
        }
    }

    @RequestProcessing(value={"/console/page/order/"}, method={HTTPRequestMethod.PUT})
    public void changeOrder(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject ret = new JSONObject();
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            String linkId = requestJSONObject.getString(Keys.OBJECT_ID);
            String direction = requestJSONObject.getString("direction");
            this.pageMgmtService.changeOrder(linkId, direction);
            ret.put("sc", true);
            ret.put("msg", (Object)this.langPropsService.get("updateSuccLabel"));
            renderer.setJSONObject(ret);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("updateFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/page/*"}, method={HTTPRequestMethod.GET})
    public void getPage(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            String requestURI = request.getRequestURI();
            String pageId = requestURI.substring((Latkes.getContextPath() + "/console/page/").length());
            JSONObject result = this.pageQueryService.getPage(pageId);
            if (null == result) {
                renderer.setJSONObject(QueryResults.defaultResult());
                return;
            }
            renderer.setJSONObject(result);
            result.put("sc", true);
            result.put("msg", (Object)this.langPropsService.get("getSuccLabel"));
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/pages/*/*/*"}, method={HTTPRequestMethod.GET})
    public void getPages(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            String requestURI = request.getRequestURI();
            String path = requestURI.substring((Latkes.getContextPath() + "/console/pages/").length());
            JSONObject requestJSONObject = Requests.buildPaginationRequest((String)path);
            JSONObject result = this.pageQueryService.getPages(requestJSONObject);
            JSONArray pages = result.optJSONArray("pages");
            for (int i = 0; i < pages.length(); ++i) {
                JSONObject page = pages.getJSONObject(i);
                if (!"page".equals(page.optString("pageType"))) continue;
                String permalink = page.optString("pagePermalink");
                page.put("pagePermalink", (Object)(Latkes.getServePath() + permalink));
            }
            result.put("sc", true);
            renderer.setJSONObject(result);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }
}

