/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor.console;

import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.Before;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.b3log.latke.util.Requests;
import org.b3log.solo.processor.console.common.ProcessAuthAdvice;
import org.b3log.solo.processor.renderer.ConsoleRenderer;
import org.b3log.solo.service.PluginMgmtService;
import org.b3log.solo.service.PluginQueryService;
import org.b3log.solo.util.QueryResults;
import org.json.JSONObject;

@RequestProcessor
@Before(adviceClass={ProcessAuthAdvice.class})
public class PluginConsole {
    private static final Logger LOGGER = Logger.getLogger((String)PluginConsole.class.getName());
    @Inject
    private PluginQueryService pluginQueryService;
    @Inject
    private PluginMgmtService pluginMgmtService;
    @Inject
    private LangPropsService langPropsService;

    @RequestProcessing(value={"/console/plugin/status/"}, method={HTTPRequestMethod.PUT})
    public void setPluginStatus(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
        String pluginId = requestJSONObject.getString(Keys.OBJECT_ID);
        String status = requestJSONObject.getString("status");
        JSONObject result = this.pluginMgmtService.setPluginStatus(pluginId, status);
        renderer.setJSONObject(result);
    }

    @RequestProcessing(value={"/console/plugins/*/*/*"}, method={HTTPRequestMethod.GET})
    public void getPlugins(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws Exception {
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            String requestURI = request.getRequestURI();
            String path = requestURI.substring((Latkes.getContextPath() + "/console/plugins/").length());
            JSONObject requestJSONObject = Requests.buildPaginationRequest((String)path);
            JSONObject result = this.pluginQueryService.getPlugins(requestJSONObject);
            renderer.setJSONObject(result);
            result.put("sc", true);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            renderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/plugin/toSetting"}, method={HTTPRequestMethod.POST})
    public void toSetting(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context, ConsoleRenderer renderer) throws Exception {
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        try {
            JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
            String pluginId = requestJSONObject.getString(Keys.OBJECT_ID);
            String setting = this.pluginQueryService.getPluginSetting(pluginId);
            renderer.setTemplateName("admin-plugin-setting.ftl");
            Map dataModel = renderer.getDataModel();
            Keys.fillRuntime((Map)dataModel);
            dataModel.put("setting", setting);
            dataModel.put(Keys.OBJECT_ID, pluginId);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            JSONObject jsonObject = QueryResults.defaultResult();
            JSONRenderer jsonRenderer = new JSONRenderer();
            jsonRenderer.setJSONObject(jsonObject);
            jsonObject.put("msg", (Object)this.langPropsService.get("getFailLabel"));
        }
    }

    @RequestProcessing(value={"/console/plugin/updateSetting"}, method={HTTPRequestMethod.POST})
    public void updateSetting(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context, JSONRenderer renderer) throws Exception {
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject requestJSONObject = Requests.parseRequestJSONObject((HttpServletRequest)request, (HttpServletResponse)response);
        String pluginoId = requestJSONObject.getString(Keys.OBJECT_ID);
        String settings = requestJSONObject.getString("setting");
        JSONObject ret = this.pluginMgmtService.updatePluginSetting(pluginoId, settings);
        renderer.setJSONObject(ret);
    }
}

